/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.j2ee.metadata.*;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;

/**
 *
 * @author Andrei Badea
 */
public class WeakProxyClassPathImplementationTest extends NbTestCase {

    public WeakProxyClassPathImplementationTest(String testName) {
        super(testName);
    }

    public void testWeakProxyClassPathImplementation() throws Exception {
        class PCL implements PropertyChangeListener {

            private int changeCount;

            public void propertyChange(PropertyChangeEvent event) {
                changeCount++;
            }

            private boolean testChangeAndReset() {
                boolean result = changeCount > 0;
                changeCount = 0;
                return result;
            }
        }

        URL url11 = new URL("file:///foo/bar11/");
        URL url12 = new URL("file:///foo/bar12/");
        URL url2 = new URL("file:///foo/bar2/");
        URL url3 = new URL("file:///foo/bar3/");

        ClassPathImpl classPath1 = new ClassPathImpl(new URL[] { url11 });
        ClassPathImpl classPath2 = new ClassPathImpl(new URL[] { url2 });
        ClassPathImpl classPath3 = new ClassPathImpl(new URL[] { url3 });

        WeakProxyClassPathImplementation proxyClassPath = new WeakProxyClassPathImplementation(new ClassPathImplementation[] { classPath1, classPath2, classPath3 });
        PCL pcl = new PCL();
        proxyClassPath.addPropertyChangeListener(pcl);

        assertResources(proxyClassPath.getResources(), new URL[] { url11, url2, url3 });

        // changing a delegate classpath by adding an entry

        classPath1.setResources(new URL[] { url11, url12 });

        assertTrue(pcl.testChangeAndReset());
        assertResources(proxyClassPath.getResources(), new URL[] { url11, url12, url2, url3 });

        // allowing a delegate classpath to be gc'd

        WeakReference<ClassPathImpl> classPath2Ref = new WeakReference<ClassPathImpl>(classPath2);
        classPath2 = null;
        assertGC("Should be able to gc classpath2", classPath2Ref);
        assertTrue(pcl.testChangeAndReset());
        assertResources(proxyClassPath.getResources(), new URL[] { url11, url12, url3 });

        // changing another delegate classpath by removing an entry

        classPath3.setResources(new URL[] { });

        assertTrue(pcl.testChangeAndReset());
        assertResources(proxyClassPath.getResources(), new URL[] { url11, url12 });

        WeakReference<ClassPathImpl> classPath1Ref = new WeakReference<ClassPathImpl>(classPath1);
        WeakReference<ClassPathImpl> classPath3Ref = new WeakReference<ClassPathImpl>(classPath3);
        classPath1 = null;
        classPath3 = null;
        assertGC("Should be able to gc classpath1", classPath1Ref);
        assertGC("Should be able to gc classpath3", classPath3Ref);
        assertResources(proxyClassPath.getResources(), new URL[0]);
    }

    private static void assertResources(List<PathResourceImplementation> expected, URL[] actual) {
        Set<URL> expectedSet = new HashSet<URL>();
        for (PathResourceImplementation resource: expected) {
            // taking the first root because our PathResourceImplementation's
            // all should only have one root
            expectedSet.add(resource.getRoots()[0]);
        }
        Set<URL> actualSet = new HashSet<URL>(Arrays.asList(actual));
        assertEquals(expectedSet, actualSet);
    }

    private static final class ClassPathImpl implements ClassPathImplementation {

        private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

        private List<PathResourceImplementation> resources;

        public ClassPathImpl(URL[] urls) {
            setResources(urls);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            propChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            propChangeSupport.removePropertyChangeListener(listener);
        }

        public List<PathResourceImplementation> getResources() {
            return resources;
        }

        public void setResources(URL[] urls) {
            List<PathResourceImplementation> newResources = new ArrayList<PathResourceImplementation>();
            for (URL url : urls) {
                newResources.add(ClassPathSupport.createResource(url));
            }
            resources = newResources;
            propChangeSupport.firePropertyChange(ClassPathImplementation.PROP_RESOURCES, null, null);
        }
    }
}
