/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.persistence.dd;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

/**
 * A metadata unit implementation which holds the classpath weakly. Needed when the 
 * metadata unit will be used as a value in a HashMap referenced from a static field. 
 * Holding the classpath strongly would have caused projects to leak, 
 * since a classpath can come from a project and can hold a reference
 * to this project. When the claspath is GCd an empty classpath
 * will be returned by {@link #getClassPath}.
 *
 * <p><strong>The classpath must be hold strongly by someone else!</strong>
 * Usually it will be held by the project it came from.</p>
 *
 * @author Andrei Badea
 */
public final class WeakMetadataUnit implements MetadataUnit {

    private FileObject deploymentDescriptor;

    // WeakReference<ClassPath> or empty ClassPath
    private Object classPath;

    public WeakMetadataUnit(FileObject deploymentDescriptor, ClassPath classPath) {
        synchronized (this) {
            this.deploymentDescriptor = deploymentDescriptor;
            if (classPath != null) {
                this.classPath = new WeakReference<ClassPath>(classPath);
            } else {
                this.classPath = ClassPathSupport.createClassPath(Collections.emptyList());
            }
        }
    }

    public synchronized FileObject getDeploymentDescriptor() {
        return deploymentDescriptor;
    }

    public synchronized ClassPath getClassPath() {
        ClassPath result;

        if (classPath instanceof Reference) {
            Reference ref = (Reference)classPath;
            result = (ClassPath)ref.get();
            if (result == null) {
                result = ClassPathSupport.createClassPath(Collections.emptyList());
                classPath = result;
            }
        } else {
            result = (ClassPath)classPath;
        }

        return result;
    }

    public synchronized void setDeploymentDescriptor(FileObject deploymentDescriptor) {
        // XXX should send some property change event here
        this.deploymentDescriptor = deploymentDescriptor;
    }
}
