/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.persistence.dd.orm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.NNModelBuilder;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;

/**
 * Annotation listener implementation for ORM Metadata
 *
 * @author Marek Fukala
 */
public class ORMNNListener extends NNModelBuilder {
    
    /** A map storing annotations to model structure mapping. */
    private Map<String,String> nn2modelMapping;
    private EntityMappings entityMappings;
    private ClassPath cp;
    
    private static final Collection<String> primaryAnnotations = Arrays.asList(new String[]{"javax.persistence.Entity", "javax.persistence.MappedSuperclass", "javax.persistence.Embeddable"});
    
    public ORMNNListener(EntityMappings nnEntityMappings, ClassPath cp) {
        super(nnEntityMappings);
        this.entityMappings = nnEntityMappings;
        this.cp =cp;
        initNN2ModelMapping();
    }

    public ClassPath getClassPath() {
        return cp;
    }
    
    public Map<String,String> getAnnotation2ModelMapping() {
        return nn2modelMapping;
    }

    public void classRemoved(String fqn) {
        Entity entityToRemove = findEntityForClass(fqn);
        entityMappings.removeEntity(entityToRemove);
    }
    
    public Collection<String> getPrimaryAnnotations() {
        return primaryAnnotations;
    }
    
    private void initNN2ModelMapping() {
        HashMap map = new HashMap();
        
        //mapping specific to @Entity and @Embeddable
        HashMap<String,String> imaps = new HashMap();
        imaps.put("javax.persistence.Table", "/Table"); //NOI18N
        imaps.put("javax.persistence.SecondaryTable", "/SecondaryTable");  //NOI18N
        
        //mapping for @Entity, @Embeddable and @MappedSuperclass
        HashMap<String,String> imapsGeneric = new HashMap();
        imapsGeneric.put("javax.persistence.OneToOne", "/Attributes/OneToOne#Name=$MEMBER"); //NOI18N
        imapsGeneric.put("javax.persistence.OneToMany", "/Attributes/OneToMany#Name=$MEMBER"); //NOI18N
        imapsGeneric.put("javax.persistence.ManyToMany", "/Attributes/ManyToMany#Name=$MEMBER"); //NOI18N
        imapsGeneric.put("javax.persistence.ManyToOne", "/Attributes/ManyToOne#Name=$MEMBER"); //NOI18N
        imapsGeneric.put("javax.persistence.Id", "/Attributes/Id#Name=$MEMBER"); //NOI18N
        imapsGeneric.put("javax.persistence.EmbeddedId", "/Attributes/EmbeddedId#Name=$MEMBER"); //NOI18N
        imapsGeneric.put("javax.persistence.Transient", "/Attributes/Transient#Name=$MEMBER"); //NOI18N
        imapsGeneric.put("javax.persistence.IdClass", "/IdClass#!value=class2"); //NOI18N
        
        //generate mappings; the resulting mappings will look like:
        //  "javax.persistence.OneToOne?Entity#Class2=$JAVACLASS" => "Entity#Class2=$JAVACLASS/Attributes/OneToOne#Name=$MEMBER"
        
        //mappings for entity classes
        String ENTITY_MAPPING = "Entity#Class2=$JAVACLASS"; //NOI18N
        map.put("javax.persistence.Entity", ENTITY_MAPPING); //NOI18N
        generateItemsMappings(ENTITY_MAPPING, ENTITY_MAPPING, map, imaps);
        generateItemsMappings(ENTITY_MAPPING, ENTITY_MAPPING, map, imapsGeneric);
        
        //mappings for MappedSuperclass classes
        String MS_MAPPING = "MappedSuperclass#Class2=$JAVACLASS"; //NOI18N
        map.put("javax.persistence.MappedSuperclass", MS_MAPPING); //NOI18N
        generateItemsMappings(MS_MAPPING, MS_MAPPING, map, imapsGeneric);
        
        String EMBEDABLE_MAPPING = "Embeddable#Class2=$JAVACLASS"; //NOI18N
        map.put("javax.persistence.Embeddable", EMBEDABLE_MAPPING); //NOI18N
        generateItemsMappings(EMBEDABLE_MAPPING, EMBEDABLE_MAPPING, map, imaps);
        generateItemsMappings(EMBEDABLE_MAPPING, EMBEDABLE_MAPPING, map, imapsGeneric);
        
        nn2modelMapping = Collections.unmodifiableMap(map);
        
//        dumpMappings();
    }
    
    //generates real nnmodel builder mappings
    private void generateItemsMappings(String condition, String mappingPrefix, Map<String,String> mappings, Map<String,String> items) {
        Iterator<String> i = items.keySet().iterator();
        while(i.hasNext()) {
            String key = i.next();
            String value = items.get(key);
            //generate and store the real mapping
            mappings.put(key + "?" + condition, mappingPrefix + value);
        }
    }
    
    private void dumpMappings() {
        System.out.println("ORM NN model builder mappings:\n==============================\n");
        Iterator<String> i = getAnnotation2ModelMapping().keySet().iterator();
        while(i.hasNext()) {
            String key = i.next();
            String val = getAnnotation2ModelMapping().get(key);
            System.out.println(key + " -> " + val);
        }
    }

    private Entity findEntityForClass(String fqn) {
        if (fqn != null) {
            Entity[] entities = entityMappings.getEntity();
            for (int i = 0; i < entities.length; i++) {
                if (fqn.equals(entities[i].getClass2())) {
                    return entities[i];
                }
            }
        }
        return null;
    }
    
}
