/*
 * PersistenceChildren.java
 *
 * Created on August 17, 2005, 9:48 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package org.netbeans.modules.j2ee.persistence.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/**
 *
 * @author Martin Adamek
 */
public class PersistenceChildren extends Children.Keys implements PropertyChangeListener {
    
    private final EntityMappings model;
    private final ClassPath srcPath;
    
    public PersistenceChildren(EntityMappings model, ClassPath srcPath) {
        this.model = model;
        this.srcPath = srcPath;
    }
    
    protected void addNotify() {
        super.addNotify();
        updateKeys();
        model.addPropertyChangeListener(this);
    }

    private void updateKeys() {
        List keys = Collections.EMPTY_LIST;
        Entity[] entityBeans = model.getEntity();
        Comparator ejbComparator = new Comparator() {
            public int compare(Object o1, Object o2) {
                return getEjbDisplayName((Entity) o1).compareTo(getEjbDisplayName((Entity) o2));
            }
            
            private String getEjbDisplayName(Entity entity) {
                String name = entity.getName();
                if (name == null) {
                    name = "";
                }
                return name;
            }
        };
        Arrays.sort(entityBeans, ejbComparator);
        keys = new ArrayList(entityBeans.length);
        addKeyValues(keys, Arrays.asList(entityBeans));
        setKeys(keys);
    }
    
    protected void removeNotify() {
        model.removePropertyChangeListener(this);
        setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }
    
    protected Node[] createNodes(Object key) {
        Node[] node = null;
        if (key instanceof Entity) {
            node = new Node[] { new EntityNode((Entity)key, model, srcPath)};
        }
        return node == null?new Node[0]:node;
    }
    
    public void propertyChange(PropertyChangeEvent pce) {
	SwingUtilities.invokeLater(new Runnable() {
	    public void run() {
		updateKeys();
	    }
	});
    }
    
    private void addKeyValues(List keyContainer, List beans) {
        keyContainer.addAll(beans);
    }
    
}
