/*
 * PersistenceNode.java
 *
 * Created on August 17, 2005, 9:45 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package org.netbeans.modules.j2ee.persistence.ui;

import java.awt.Image;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;


/**
 *
 * @author Martin Adamek
 */
public class PersistenceNode extends AbstractNode {
    
    private static final String ORM_BADGE = "org/netbeans/modules/j2ee/persistence/ui/resources/PersistenceBadge.png"; // NOI18N
    
    public PersistenceNode(EntityMappings entMap, ClassPath srcPath) {
        this(new InstanceContent(), entMap, srcPath);
    }
    
    private PersistenceNode(InstanceContent content, EntityMappings entMap, ClassPath srcPath) {
        super(new PersistenceChildren(entMap, srcPath), new AbstractLookup(content));
        setName("Persistence");
        setDisplayName("Persistence");
        setShortDescription("Persistence short description");
        content.add(entMap);
    }

    @Override
    public Image getIcon(int type) {
        return computeIcon(false, type);
    }
    
    @Override
    public Image getOpenedIcon(int type) {
        return computeIcon(true, type);
    }
    
    private Image computeIcon(boolean opened, int type) {
        Image image;
        Node iconDelegate = getIconDelegate();
        if (opened) {
            image = iconDelegate != null ? iconDelegate.getOpenedIcon(type) : super.getOpenedIcon(type);
        } else {
            image = iconDelegate != null ? iconDelegate.getIcon(type) : super.getIcon(type);
        }
        Image badge = Utilities.loadImage(ORM_BADGE);
        return Utilities.mergeImages(image, badge, 7, 7);
    }
    
    private Node getIconDelegate() {
        try {
            return DataFolder.find(Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        } catch (DataObjectNotFoundException donfe) {
            return null;
        }
    }
    
}
