/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.project.Project;
import org.netbeans.junit.NbTestCase;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/**
 *
 * @author Andrei Badea
 */
public class TableSourceTest extends NbTestCase {

    public TableSourceTest(String testName) {
        super(testName);
    }

    public void testNoLeak() {
        Project project = new ProjectImpl();

        TableSource source = new TableSource("jndi/foo", TableSource.Type.DATA_SOURCE);
        TableSource.put(project, source);

        assertSame(source, TableSource.get(project));

        Reference<Project> projectRef = new WeakReference(project);
        project = null;
        assertGC("Should be possible to GC project", projectRef);
    }

    private static final class ProjectImpl implements Project {

        public FileObject getProjectDirectory() {
            return null;
        }

        public Lookup getLookup() {
            return null;
        }
    }
}
