/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;

/**
 * This class represents an annotation reference to an entity.
 *
 * @author Erno Mononen
 */
public class EntityAnnotationReference {
    
    /**
     * The attribute value that references other entity.
     */
    private AttributeValue attributeValue;
    /**
     * Referencing annotation.
     */
    private Annotation annotation;
    /**
     * The entity that has the feature with referencing annotation.
     */
    private JavaClass referring;
    /**
     * The entity that is referenced.
     */
    private JavaClass referenced;
    
    /**
     * The feature (field or method) that has the referencing annotation.
     */
    private Feature referringProperty;
    /**
     * Creates a new instance of EntityAssociation
     * @param referenced the entity that is referenced.
     * @param referring the entity that has the property with referencing annotation.
     * @param property the property that hat the referencing annotation.
     * @param annotation the referencing annotation
     * @param attributeValue the attribute value of the annotation that references other entity
     */
    public EntityAnnotationReference(JavaClass referenced, JavaClass referring, Feature property,
            Annotation annotation, AttributeValue attributeValue) {
        this.referenced = referenced;
        this.referring = referring;
        this.referringProperty = property;
        this.annotation = annotation;
        this.attributeValue = attributeValue;
    }
    
    /**
     * @see #attributeValue
     */
    public AttributeValue getAttributeValue() {
        return attributeValue;
    }
    
    /**
     * @see #annotation
     */
    public Annotation getAnnotation() {
        return annotation;
    }

    /**
     * @see #referringProperty
     */
    public Feature getReferringProperty() {
        return referringProperty;
    }


    /**
     * @see #referring
     */
    public JavaClass getReferring() {
        return referring;
    }
    
    /**
     * @see #referenced
     */
    public JavaClass getReferenced(){
        return referenced;
    }
}
