/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.jaxwssupport;

import java.io.IOException;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/**
 * Base class for jax ws refactoring elements.
 *
 * @author Erno Mononen
 */
public abstract class JaxWsXmlRefactoringElementSupport extends AbstractRenameRefactoringElement implements ExternalChange {
    
    protected JaxWsModel model;
    protected Service service;
    
    /**
     * Creates a new instance of JaxWsXmlRefactoringElementSupport
     * @param oldName the fully qualified old name of the implementation class
     * @param newName the fully qualified new name of the implementation class
     * @service the service whose implementation class is to be renamed
     * @parentFile the file object representing jax-ws.xml
     */
    public JaxWsXmlRefactoringElementSupport(String oldName,  String newName,  
            JaxWsModel model, Service service, FileObject parentFile) {
        
        this.oldName = oldName;
        this.newName = newName;
        this.model = model;
        this.parentFile = parentFile;
        this.service = service;
    }

    
    public void performExternalChange() {
        service.setImplementationClass(newName);
        writeModel();
    }
    
    public void undoExternalChange() {
        service.setImplementationClass(oldName);
        writeModel();
    }
    
    private void writeModel(){
        try {
            model.write();
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }
    
    /**
     * Performs the change represented by this refactoring element.
     */
    public void performChange() {
        JavaMetamodel.getManager().registerExtChange(this);
    }
    
}
