/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.jaxwssupport;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

/**
 * Base class for sun jax ws refactoring elements.
 *
 * @author Erno Mononen
 */
public abstract class SunJaxWsXmlElementSupport extends AbstractRenameRefactoringElement implements ExternalChange {
    
    private Endpoint endpoint;
    private Endpoints model;
    
    /**
     * Creates a new instance of JaxWsXmlRefactoringElementSupport
     * @param oldName the fully qualified old name of the implementation class.
     * @param newName the fully qualified new name of the implementation class.
     * @model the model representing <code>sun-jaxws.xml</code>.
     * @endpoint the endpoint whose implementation class is to be renamed.
     * @parentFile the file object representing jax-ws.xml.
     */
    public SunJaxWsXmlElementSupport(String oldName,  String newName,
            Endpoints model, Endpoint endpoint,  FileObject parentFile) {
        
        this.oldName = oldName;
        this.newName = newName;
        this.endpoint = endpoint;
        this.model = model;
        this.parentFile = parentFile;
    }
    
    public void undoExternalChange() {
        model.findEndpointByName(endpoint.getEndpointName()).setImplementation(oldName);
        writeModel();
    }
    
    public void performExternalChange() {
        model.findEndpointByName(endpoint.getEndpointName()).setImplementation(newName);
        writeModel();
    }
    
    /**
     * Writes the model.
     */
    protected void writeModel(){
        FileLock lock = null;
        try {
            lock = parentFile.lock();
            OutputStream os = parentFile.getOutputStream(lock);
            try{
                model.write(os);
            } finally {
                os.close();
            }
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ex);
        } finally {
            lock.releaseLock();
        }
    }
    public void performChange() {
        JavaMetamodel.getManager().registerExtChange(this);
    }
    
    
}
