/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.text.MessageFormat;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class provides rename refactoring support for entity annotations.
 *
 * @author Erno Mononen
 */
public class EntityRenameRefactoring {
    
    /**
     * Creates a new instance of EntityRenameRefactoring
     */
    public EntityRenameRefactoring() {
    }
    
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject,
            String newName, RefactoringElementsBag refactoringElements) {
        
        if (!(refObject instanceof Feature)){
            return null;
        }
        
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try{
            Feature property = (Feature) refObject;
            JavaClass jc = null;
            if  (property.refImmediateComposite() instanceof JavaClass){
                jc = (JavaClass) property.refImmediateComposite();
            }
            
            if (jc != null && PersistenceRefactoringUtil.isEntity(jc)){
                List allEntities = PersistenceRefactoringUtil.getEntitiesInProject(jc);
                EntityAssociationResolver resolver = new EntityAssociationResolver(jc, allEntities);
                List<EntityAnnotationReference> references = resolver.getMappedByReferences(property);
                
                for (EntityAnnotationReference elem : references) {
                    Resource res = elem.getReferring().getResource();
                    FileObject fo = JavaModel.getFileObject(res);
                    
                    RefactoringElementImplementation refactoringElem =
                            new EntityRenameRefactoringElement(elem, property.getName(), newName, fo);
                    refactoringElements.add(refactoring, refactoringElem);
                    
                }
            }
            rollback = false;
        } finally {
            JMIUtils.endJmiTransaction(rollback);
        }
        
        return null;
    }
    
    /**
     * Rename element for entity annotation.
     */
    private static class EntityRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        private EntityAnnotationReference reference;
        /**
         * New value for the annotation attribute value, i.e. new name of the method 
         * that's being renamed without 'get' prefix.
         */
        private String newPropertyName;
        
        public EntityRenameRefactoringElement(EntityAnnotationReference reference,
                String oldName,  String newName, FileObject parentFile) {
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.reference = reference;
            this.newPropertyName = Utility.getPropertyName(newName);
        }
        
        /**
         * @return the old value of the annotation attribute value that is to
         * be renamed.
         */
        private String getOldValue(){
            JMIUtils.beginJmiTransaction();
            boolean rollback = true;
            String oldValue = null;
            try{
                oldValue = ((StringLiteral) reference.getAttributeValue().getValue()).getValue();
                rollback = false;
            } finally {
                JMIUtils.endJmiTransaction(rollback);
            }
            return oldValue;
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), getOldValue(), newPropertyName};
            return MessageFormat.format(NbBundle.getMessage(EntityRenameRefactoring.class, "TXT_EntityAnnotationRename"), args);
        }
        
        public void performExternalChange() {
        }
        
        
        public void undoExternalChange() {
        }
        
        public void performChange() {
            JMIUtils.beginJmiTransaction(true);
            boolean rollback = true;
            StringLiteral stringLiteral = null;
            try{
                String newPropertyName = Utility.getPropertyName(newName);
                stringLiteral = ((JavaModelPackage) reference.getAnnotation().refImmediatePackage()).getStringLiteral().createStringLiteral(newPropertyName);
                reference.getAttributeValue().setValue(stringLiteral);
                rollback = false;
            } finally {
                JMIUtils.endJmiTransaction(rollback);
            }
        }
    }
}
