/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.TLDLoader;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class TldRenameRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N

    public TldRenameRefactoring() { }

    /** Find usages in web deployment descriptor: web.xml 
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
            
        Problem problem = null;
        if (refObject instanceof JavaClass) {
            
            JavaClass jClass = (JavaClass)refObject;
            
            String name = jClass.getName();
            err.log("name: " + name);

            newName = name.substring(0, name.lastIndexOf('.') + 1) + newName;
            err.log("newName: " + newName);

            Resource res = jClass.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            WebModule wm = WebModule.getWebModule(fo);
            
            if (wm != null) {              // the class is in a web module, therefore tld makes sense
                FileObject webInf = wm.getWebInf();
                Enumeration e = null;
                if (webInf != null) {
                    e = webInf.getChildren(true);
                }
                if (e != null) {
                    while (e.hasMoreElements()) {
                        FileObject tld = (FileObject)e.nextElement();
                        if (isTld(tld)) {
                            DataObject tldData = null;
                            try {
                                tldData = DataObject.find(tld);
                            } catch (DataObjectNotFoundException dne) {
                                // ignore
                            }
                            if ((tldData != null) && (tldData instanceof TLDDataObject)) {
                                Taglib taglib = null;
                                try {
                                    taglib = ((TLDDataObject)tldData).getTaglib();
                                } catch (IOException ioe) {}
                                if (taglib != null) {
                                    // tag element
                                    TagType[] tagTypes = taglib.getTag();
                                    if ((tagTypes != null) && (tagTypes.length > 0)) {
                                        for (int tt = 0; tt < tagTypes.length; tt++) {
                                            TagType tagT = tagTypes[tt];
                                            String tagClass = tagT.getTagClass();
                                            if ((tagClass != null) && (tagClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibTagClassRenameRefactoringElement(taglib, name, newName, tagT, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String teiClass = tagT.getTeiClass();
                                            if ((teiClass != null) && (teiClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibTeiClassRenameRefactoringElement(taglib, name, newName, tagT, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                    FunctionType[] functionTypes = taglib.getFunction();
                                    if ((functionTypes != null) && (functionTypes.length > 0)) {
                                        for (int tt = 0; tt < functionTypes.length; tt++) {
                                            FunctionType functionT = functionTypes[tt];
                                            String functionClass = functionT.getFunctionClass();
                                            if ((functionClass != null) && (functionClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibFunctionClassRenameRefactoringElement(taglib, name, newName, functionT, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                    // validator element
                                    ValidatorType validatorType = taglib.getValidator();
                                    if (validatorType != null) {
                                        String validatorClass = validatorType.getValidatorClass();
                                        if ((validatorClass != null) && (validatorClass.equals(name))) {
                                            RefactoringElementImplementation elem = new TaglibValidatorClassRenameRefactoringElement(taglib, name, newName, validatorType, tld);
                                            refactoringElements.add(refactoring, elem);
                                        }
                                    }

                                    // listener element
                                    org.netbeans.modules.web.taglib.model.ListenerType[] listenerTypes = taglib.getListener();
                                    if ((listenerTypes != null) && (listenerTypes.length > 0)) {
                                        for (int tt = 0; tt < listenerTypes.length; tt++) {
                                            org.netbeans.modules.web.taglib.model.ListenerType listenerT = listenerTypes[tt];
                                            String listenerClass = listenerT.getListenerClass();
                                            if ((listenerClass != null) && (listenerClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibListenerClassRenameRefactoringElement(taglib, name, newName, listenerT, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                } else {
                                    Object[] args = new Object [] {tld.getNameExt()};
                                    String msg = MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, "TXT_TaglibRenameInvalidProblem"), args);
                                    Problem newProblem = new Problem(false, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                }
                            }
                        }
                    } // while
                }
            }
        } // javaclass
        return problem;
    }

    private boolean isTld(FileObject fo) {
        boolean isTld = false;
        if (fo != null) {
            String ext = fo.getExt();
            if (TLDLoader.tldExt.equalsIgnoreCase(ext)) {
                isTld = true;
            }
        }
        return isTld;
    }
    
    public final class TaglibTagClassRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected Taglib tld;
        private TagType tagType;
        
        /** Creates a new instance of TaglibTagClassRenameRefactoringElement */
        public TaglibTagClassRenameRefactoringElement(Taglib tld, String oldName, String newName, TagType tagType, FileObject parentFile) { 
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.tagType = tagType;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, "TXT_TaglibTagClassRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            tagType.setTagClass(newName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            tagType.setTagClass(oldName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class TaglibTeiClassRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected Taglib tld;
        private TagType tagType;

        /** Creates a new instance of TaglibTagClassRenameRefactoringElement */
        public TaglibTeiClassRenameRefactoringElement(Taglib tld, String oldName, String newName, TagType tagType, FileObject parentFile) { 
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.tagType = tagType;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, "TXT_TaglibTeiClassRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            tagType.setTeiClass(newName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            tagType.setTeiClass(oldName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
    }    
    
    public final class TaglibFunctionClassRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected Taglib tld;
        private FunctionType functionType;

        /** Creates a new instance of TaglibFunctionClassRenameRefactoringElement */
        public TaglibFunctionClassRenameRefactoringElement(Taglib tld, String oldName, String newName, FunctionType functionType, FileObject parentFile) { 
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.functionType = functionType;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, "TXT_TaglibFunctionClassRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            functionType.setFunctionClass(newName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            functionType.setFunctionClass(oldName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class TaglibValidatorClassRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected Taglib tld;
        private ValidatorType validatorType;

        /** Creates a new instance of TaglibFunctionClassRenameRefactoringElement */
        public TaglibValidatorClassRenameRefactoringElement(Taglib tld, String oldName, String newName, ValidatorType validatorType, FileObject parentFile) { 
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.validatorType = validatorType;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, "TXT_TaglibValidatorClassRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            validatorType.setValidatorClass(newName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            validatorType.setValidatorClass(oldName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
    }    

    public final class TaglibListenerClassRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {

        protected Taglib tld;
        private org.netbeans.modules.web.taglib.model.ListenerType listenerType;

        /** Creates a new instance of TaglibFunctionClassRenameRefactoringElement */
        public TaglibListenerClassRenameRefactoringElement(Taglib tld, String oldName, String newName, 
                org.netbeans.modules.web.taglib.model.ListenerType listenerType, FileObject parentFile) { 
            this.tld = tld;
            this.oldName = oldName;
            this.newName = newName;
            this.listenerType = listenerType;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldRenameRefactoring.class, "TXT_TaglibListenerClassRename"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            listenerType.setListenerClass(newName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            listenerType.setListenerClass(oldName);
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(parentFile);
                if (tdo != null) {
                    tdo.write(tld);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
}
