/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class WebXmlRenameRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N
    
    public WebXmlRenameRefactoring() { }
    
    public Problem precheck() {
        return null;
    }
    
    /** Find usages in web deployment descriptor: web.xml
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        
        Problem problem = null;
        // Going to rename Class
        if (refObject instanceof JavaClass) {
            JavaClass jClass = (JavaClass)refObject;
            
            String name = jClass.getName();
            err.log("name: " + name);
            
            newName = name.substring(0, name.lastIndexOf('.') + 1) + newName;
            err.log("newName: " + newName);
            
            Resource res = jClass.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            Collection wmodules = Utility.getRelevantWebModules(fo);
            Iterator wmIter = null;
            
            if (wmodules != null) {
                wmIter = wmodules.iterator();
            }
            if (wmIter != null) {
                while (wmIter.hasNext()) {
                    WebModule wm = (WebModule)wmIter.next();
                    if (wm != null) {              // the class is in a web module
                        FileObject webXmlFO = wm.getDeploymentDescriptor();
                        WebApp webXmlDD = null;
                        try {
                            webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
                        } catch (IOException ioe) {
                            // ignore
                        }
                        if ((webXmlDD != null) && (webXmlDD.getStatus()!=WebApp.STATE_INVALID_UNPARSABLE)) {
                            //servlets
                            Servlet[] servlets = webXmlDD.getServlet();
                            if ((servlets!=null) && (servlets.length > 0)) {
                                for (int s=0; s < servlets.length; s++) {
                                    Servlet servlet = (Servlet)servlets[s];
                                    err.log("Servlet: " + servlet);
                                    String servletClass = servlet.getServletClass();
                                    err.log("Servlet class: " + servletClass);
                                    if ((servletClass != null) && (servletClass.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlServletRenameRefactoringElement(webXmlDD, name, newName,
                                                servlet, webXmlFO
                                                );
                                        refactoringElements.add(refactoring, elem);
                                        // servlet name
                                        String servletName = servlet.getServletName();
                                        String unqualifiedName = Utility.unqualify(name);
                                        if (servletName != null && servletName.equals(unqualifiedName)) {
                                            RefactoringElementImplementation nameElem =
                                                    new WebXmlServletNameRenameRefactoringElement(webXmlDD, unqualifiedName, Utility.unqualify(newName),
                                                    servlet, webXmlFO
                                                    );
                                            refactoringElements.add(refactoring, nameElem);
                                        }
                                    }
                                    
                                }
                            }
                            //listeners
                            Listener[] listeners = webXmlDD.getListener();
                            if ((listeners!=null) && (listeners.length > 0)) {
                                for (int s=0; s < listeners.length; s++) {
                                    Listener listener = (Listener)listeners[s];
                                    err.log("Listener: " + listener);
                                    String listenerClass = listener.getListenerClass();
                                    err.log("Listener class: " + listenerClass);
                                    if ((listenerClass != null) && (listenerClass.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlListenerRenameRefactoringElement(webXmlDD, name, newName,
                                                listener, webXmlFO
                                                );
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }
                            //filters
                            Filter[] filters = webXmlDD.getFilter();
                            if ((filters!=null) && (filters.length > 0)) {
                                for (int s=0; s < filters.length; s++) {
                                    Filter filter = (Filter)filters[s];
                                    err.log("Filter: " + filter);
                                    String filterClass = filter.getFilterClass();
                                    err.log("Filter class: " + filterClass);
                                    if ((filterClass != null) && (filterClass.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlFilterRenameRefactoringElement(webXmlDD, name, newName,
                                                filter, webXmlFO
                                                );
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }
                            
                            // refs
                            org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = webXmlDD.getEjbRef();
                            if ((refs != null) && (refs.length > 0)) {
                                for (int l=0; l < refs.length; l++) {
                                    org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)refs[l];
                                    err.log("EJB ref: " + ref);
                                    String refHome = ref.getHome();
                                    err.log("home ref: " + refHome);
                                    if ((refHome != null) && (refHome.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlRefHomeRenameRefactoringElement(webXmlDD, name, newName,
                                                (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref,
                                                webXmlFO
                                                );
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String refRemote = ref.getRemote();
                                    err.log("localHome ref: " + refRemote);
                                    if ((refRemote != null) && (refRemote.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlRefRemoteRenameRefactoringElement(webXmlDD, name, newName,
                                                (org.netbeans.modules.j2ee.dd.api.common.EjbRef)ref,
                                                webXmlFO
                                                );
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }
                            
                            // local refs
                            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] localRefs = webXmlDD.getEjbLocalRef();
                            if ((localRefs != null) && (localRefs.length > 0)) {
                                for (int l=0; l < localRefs.length; l++) {
                                    org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef = (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRefs[l];
                                    err.log("EJB local ref: " + localRef);
                                    String refLocal = localRef.getLocal();
                                    err.log("local ref: " + refLocal);
                                    if ((refLocal != null) && (refLocal.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlRefLocalRenameRefactoringElement(webXmlDD, name, newName,
                                                (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef,
                                                webXmlFO
                                                );
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String refLocalHome = localRef.getLocalHome();
                                    err.log("localHome ref: " + refLocalHome);
                                    if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlRefLocalHomeRenameRefactoringElement(webXmlDD, name, newName,
                                                (org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef)localRef,
                                                webXmlFO
                                                );
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }
                            
                        } else {
                            Problem newProblem = new Problem(false, NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlInvalidProblem"));
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }
                    }
                } //while
            }
        }
        return problem;
    }
    /**
     * Refactoring element for servlet name.
     */
    public final class WebXmlServletNameRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private Servlet servlet;
        
        /** Creates a new instance of WebXmlServletNameRenameRefactoringElement */
        public WebXmlServletNameRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Servlet servlet, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.servlet = servlet;
            this.parentFile = parentFile;
            // should be disabled by default
            this.enabled = false;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlServletNameRename"), args);
        }
        
        public void performExternalChange() {
            servlet.setServletName(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            servlet.setServletName(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
    }
    
    public final class WebXmlServletRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private Servlet servlet;
        
        /** Creates a new instance of WebXmlServletRenameRefactoringElement */
        public WebXmlServletRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Servlet servlet, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.servlet = servlet;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlServletRename"), args);
        }
        
        public void performExternalChange() {
            servlet.setServletClass(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            servlet.setServletClass(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
    }
    
    public final class WebXmlListenerRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private Listener listener;
        
        /** Creates a new instance of WebXmlListenerRenameRefactoringElement */
        public WebXmlListenerRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Listener listener, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.listener = listener;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlListenerRename"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            listener.setListenerClass(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            listener.setListenerClass(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class WebXmlFilterRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private Filter filter;
        
        /** Creates a new instance of WebXmlFilterRenameRefactoringElement */
        public WebXmlFilterRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Filter filter, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.filter = filter;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlFilterRename"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            filter.setFilterClass(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            filter.setFilterClass(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class WebXmlRefHomeRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbRef ref;
        
        /** Creates a new instance of WebXmlRefHomeRenameRefactoringElement */
        public WebXmlRefHomeRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlRefHomeRename"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            ref.setHome(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ref.setHome(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class WebXmlRefRemoteRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbRef ref;
        
        /** Creates a new instance of WebXmlRefRemoteRenameRefactoringElement */
        public WebXmlRefRemoteRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlRefRemoteRename"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            ref.setRemote(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ref.setRemote(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class WebXmlRefLocalRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref;
        
        /** Creates a new instance of WebXmlRefLocalRenameRefactoringElement */
        public WebXmlRefLocalRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlRefLocalRename"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            ref.setLocal(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ref.setLocal(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
    public final class WebXmlRefLocalHomeRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        protected WebApp webXmlDD;
        private org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref;
        
        /** Creates a new instance of WebXmlRefLocalHomeRenameRefactoringElement */
        public WebXmlRefLocalHomeRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, "TXT_WebXmlRefLocalHomeRename"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            ref.setLocalHome(newName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
        
        public void undoExternalChange() {
            ref.setLocalHome(oldName);
            try {
                webXmlDD.write(parentFile);
            } catch (IOException ioe) {
                //TODO
            }
        }
    }
    
}
