/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.util.NbBundle;

/**
 * @author pfiala
 */
public class EjbCmpFieldSafeDeleteRefactoring extends BaseRefactoring {

    private Entity entity;
    private CmpField field;

    public EjbCmpFieldSafeDeleteRefactoring(EjbHelper helper, Entity entity, CmpField field) {
        super(helper);
        this.entity = entity;
        this.field = field;
    }

    protected Problem preCheckThis() {
        if (field.getFieldName().equals(entity.getPrimkeyField())) {
            return new Problem(true, NbBundle.getMessage(EjbCmpFieldSafeDeleteRefactoring.class,
                    "TXT_CmpPrimaryKeySafeDelete", field.getFieldName(), entity.getEjbName()));
        } else {
            return new Problem(false, NbBundle.getMessage(EjbCmpFieldSafeDeleteRefactoring.class,
                "TXT_CmpFieldGetterSetterMethodWarningSafeDelete", field.getFieldName()));
        }
    }

    public Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        helper.addRefactoringElement(refactoringElementsBag, new EjbJarRefactoringElement());
        return null;
    }

    public final class EjbJarRefactoringElement extends AbstractSafeDeleteRefactoringElement implements ExternalChange {

        public EjbJarRefactoringElement() {
            super(helper.getFileObject());
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(EjbCmpFieldSafeDeleteRefactoring.class, "TXT_EjbJarCmpFieldSafeDelete",
                    field.getFieldName());  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            entity.removeCmpField(field);
            helper.writeDD();
        }

        public void undoExternalChange() {
            entity.addCmpField(field);
            helper.writeDD();
        }
    }
}
