/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class handles safe delete refactoring of a web service endpoint implementation class
 * that is listed in sun-jaxws.xml. To be specific, this class does not delete reference to the
 * removed class but collects its usages from sun-jaxws.xml for displaying these
 * as problems to the user.
 *
 * @author Erno Mononen
 */
public class SunJaxWsXmlSafeDeleteRefactoring extends JaxWsXmlRefactoringSupport implements J2EERefactoring {
    
    /**
     * The java class that's being removed.
     */
    private JavaClass javaClass;
    
    /**
     * Creates a new instance of SunJaxWsXmlSafeDeleteRefactoring
     */
    public SunJaxWsXmlSafeDeleteRefactoring(JavaClass javaClass) {
        this.javaClass = javaClass;
    }
    
    /**
     * Checks whether the java class to be removed is listed as an endpoint implementation
     * class in sun-jaxws.xml and returns appropriate problem (warning) if it is.
     */
    public Problem preCheck() {
        
        if (!isWebSvcFromWsdl(javaClass)){
            return null;
        }

        FileObject sunjaxwsfile = getSunJaxWsXmlFile(javaClass);
        Problem result = null;
        
        for (Endpoint each : getEndpoints(javaClass)) {
            Problem problem = new Problem(false, NbBundle.getMessage(SunJaxWsXmlSafeDeleteRefactoring.class,
                   "TXT_SunJaxWsXmlSafeDeleteWarning", javaClass.getName(), sunjaxwsfile.getNameExt()));  //NOI18N
            if (result != null){
                result.setNext(problem);
            } else {
                result = problem;
            }
        }
        return result;
    }
    
    public Problem checkParameters() {
        return null;
    }
    
    public Problem fastCheckParameters() {
        return null;
    }
    
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        return null;
    }
}
