/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.whereused;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.ExcludeList;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class EjbJarWhereUsedRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.whereused");   // NOI18N

    public EjbJarWhereUsedRefactoring() { }

    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
        RefactoringSession session = refactoringElements.getSession();
        Problem problem = null;
        if (refObject instanceof JavaClass) {
            
            JavaClass jClass = (JavaClass)refObject;
            err.log("jClass: " + jClass);
            
            String name = jClass.getName();
            err.log("name: " + name);
            Collection emodules = Utility.getRelevantEjbModules(jClass);
            Iterator emIter = null;

            if (emodules != null) {
                emIter = emodules.iterator();
            }
            if (emIter != null) {
                while (emIter.hasNext()) {
                    org.netbeans.modules.j2ee.api.ejbjar.EjbJar em = (org.netbeans.modules.j2ee.api.ejbjar.EjbJar)emIter.next();
                    if (em != null) {              // the class is in an ejb module
                        FileObject ejbJarFO = em.getDeploymentDescriptor();
                        EjbJar ejbJarDD = null;
                        try {
                            ejbJarDD = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(em.getMetadataUnit());
                        } catch (IOException ioe) {
                            // ignore
                        }
                        if ((ejbJarDD != null) && (ejbJarDD.getStatus()!=EjbJar.STATE_INVALID_UNPARSABLE) && ejbJarFO != null) {
                            EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();

                            /* First check Session beans */
                            Session [] sessionBeans = eBeans.getSession();
                            err.log("Session Beans: " + sessionBeans);
                            if ((sessionBeans != null) && (sessionBeans.length > 0)) {
                                for (int b=0; b < sessionBeans.length; b++) {
                                    Session sBean = sessionBeans[b];
                                    err.log("Session Bean: " + sBean);
                                    String ejbClass = sBean.getEjbClass();
                                    err.log("EJB Class: " + ejbClass);
                                    if ((ejbClass != null) && (ejbClass.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarBeanClassWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocal = sBean.getLocal();
                                    err.log("EJB Local: " + ejbLocal);
                                    if ((ejbLocal != null) && (ejbLocal.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocalHome = sBean.getLocalHome();
                                    err.log("EJB LocalHome: " + ejbLocalHome);
                                    if ((ejbLocalHome != null) && (ejbLocalHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbHome = sBean.getHome();
                                    err.log("EJB Home: " + ejbHome);
                                    if ((ejbHome != null) && (ejbHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbRemote = sBean.getRemote();
                                    err.log("EJB Remote: " + ejbRemote);
                                    if ((ejbRemote != null) && (ejbRemote.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarRemoteWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }

                                    // service endpoint is related to ejb based web services
                                    String serviceEndpoint;
                                    try {
                                        serviceEndpoint = sBean.getServiceEndpoint();
                                        err.log("EJB Service Endpoint: " + serviceEndpoint);
                                        if ((serviceEndpoint != null) && (serviceEndpoint.equals(name))) {
                                            RefactoringElementImplementation elem = new EjbJarServiceEndpointWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                            refactoringElements.add(refactoring, elem);
                                        }
                                    } catch (VersionNotSupportedException versionex) {
                                        // No problem, just ignore
                                        err.log("Service endpoint not supported in this version of dd.");
                                    }
                                    // refs
                                    EjbRef[] refs = sBean.getEjbRef();
                                    if ((refs != null) && (refs.length > 0)) {
                                        for (int l=0; l < refs.length; l++) {
                                            EjbRef ref = refs[l];
                                            err.log("EJB ref: " + ref);
                                            String refHome = ref.getHome();
                                            if ((refHome != null) && (refHome.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refRemote = ref.getRemote();
                                            if ((refRemote != null) && (refRemote.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefRemoteWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                    // local refs
                                    EjbLocalRef[] localRefs = sBean.getEjbLocalRef();
                                    if ((localRefs != null) && (localRefs.length > 0)) {
                                        for (int l=0; l < localRefs.length; l++) {
                                            EjbLocalRef localRef = localRefs[l];
                                            err.log("EJB local ref: " + localRef);
                                            String refLocal = localRef.getLocal();
                                            if ((refLocal != null) && (refLocal.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefLocalWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refLocalHome = localRef.getLocalHome();
                                            if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefLocalHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }
                                }
                            }

                            /* Then entity beans */
                            Entity [] entityBeans = eBeans.getEntity();
                            err.log("Entity Beans: " + entityBeans);
                            if ((entityBeans != null) && (entityBeans.length > 0)) {
                                for (int b=0; b < entityBeans.length; b++) {
                                    Entity entBean = entityBeans[b];
                                    err.log("Entity Bean: " + entBean);
                                    String ejbClass = entBean.getEjbClass();
                                    err.log("EJB Class: " + ejbClass);
                                    if ((ejbClass != null) && (ejbClass.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarBeanClassWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocal = entBean.getLocal();
                                    err.log("EJB Local: " + ejbLocal);
                                    if ((ejbLocal != null) && (ejbLocal.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbLocalHome = entBean.getLocalHome();
                                    err.log("EJB LocalHome: " + ejbLocalHome);
                                    if ((ejbLocalHome != null) && (ejbLocalHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarLocalHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbHome = entBean.getHome();
                                    err.log("EJB Home: " + ejbHome);
                                    if ((ejbHome != null) && (ejbHome.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String ejbRemote = entBean.getRemote();
                                    err.log("EJB Remote: " + ejbRemote);
                                    if ((ejbRemote != null) && (ejbRemote.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarRemoteWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }

                                    // refs
                                    EjbRef[] refs = entBean.getEjbRef();
                                    if ((refs != null) && (refs.length > 0)) {
                                        for (int l=0; l < refs.length; l++) {
                                            EjbRef ref = refs[l];
                                            err.log("EJB ref: " + ref);
                                            String refHome = ref.getHome();
                                            if ((refHome != null) && (refHome.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refRemote = ref.getRemote();
                                            if ((refRemote != null) && (refRemote.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefRemoteWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                    // local refs
                                    EjbLocalRef[] localRefs = entBean.getEjbLocalRef();
                                    if ((localRefs != null) && (localRefs.length > 0)) {
                                        for (int l=0; l < localRefs.length; l++) {
                                            EjbLocalRef localRef = localRefs[l];
                                            err.log("EJB local ref: " + localRef);
                                            String refLocal = localRef.getLocal();
                                            if ((refLocal != null) && (refLocal.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefLocalWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refLocalHome = localRef.getLocalHome();
                                            if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefLocalHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }                            
                                }
                            }

                            /* And finally message driven beans */
                            MessageDriven [] messageBeans = eBeans.getMessageDriven();
                            err.log("MessageDriven Beans: " + messageBeans);
                            if ((messageBeans != null) && (messageBeans.length > 0)) {
                                for (int b=0; b < messageBeans.length; b++) {
                                    MessageDriven msgBean = messageBeans[b];
                                    err.log("MessageDriven Bean: " + msgBean);
                                    String ejbClass = msgBean.getEjbClass();
                                    err.log("EJB Class: " + ejbClass);
                                    if ((ejbClass != null) && (ejbClass.equals(name))) {
                                        RefactoringElementImplementation elem = new EjbJarBeanClassWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                        refactoringElements.add(refactoring, elem);
                                    }

                                    // refs
                                    EjbRef[] refs = msgBean.getEjbRef();
                                    if ((refs != null) && (refs.length > 0)) {
                                        for (int l=0; l < refs.length; l++) {
                                            EjbRef ref = refs[l];
                                            err.log("EJB ref: " + ref);
                                            String refHome = ref.getHome();
                                            if ((refHome != null) && (refHome.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refRemote = ref.getRemote();
                                            if ((refRemote != null) && (refRemote.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefRemoteWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                    // local refs
                                    EjbLocalRef[] localRefs = msgBean.getEjbLocalRef();
                                    if ((localRefs != null) && (localRefs.length > 0)) {
                                        for (int l=0; l < localRefs.length; l++) {
                                            EjbLocalRef localRef = localRefs[l];
                                            err.log("EJB local ref: " + localRef);
                                            String refLocal = localRef.getLocal();
                                            if ((refLocal != null) && (refLocal.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefLocalWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String refLocalHome = localRef.getLocalHome();
                                            if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                                RefactoringElementImplementation elem = new EjbJarRefLocalHomeWhereUsedRefactoringElement(ejbJarDD, name, ejbJarFO);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }                            
                                }
                            }

                        } else {
                            Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarWhereUsedInvalidProblem"));
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }
                    } // find usages in ejb-jar.xml
                }
            }
        } // javaclass
        
        if (refObject instanceof Method) {
            Method method = (Method)refObject;
            FileObject fo = JavaModel.getFileObject(method.getResource());
            Collection emodules = Utility.getRelevantEjbModules(method);
            if ((emodules != null) && (emodules.size() > 0)) { // there are ejb modules that can be affected by the change
                ClassDefinition jc = method.getDeclaringClass();
                err.log("classdefinition classDefinition: " + jc);
                if (jc instanceof JavaClass) {

                    // update Assembly descriptor part
                    Iterator emIter = emodules.iterator();
                    while (emIter.hasNext()) {
                        org.netbeans.modules.j2ee.api.ejbjar.EjbJar em = (org.netbeans.modules.j2ee.api.ejbjar.EjbJar)emIter.next();
                        if (em != null) {              // the class is in an ejb module
                            FileObject ejbJarFO = em.getDeploymentDescriptor();
                            EjbJar ejbJarDD = null;
                            try {
                                ejbJarDD = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(em.getMetadataUnit());
                            } catch (IOException ioe) {
                                // ignore
                            }
                            if ((ejbJarDD != null) && (ejbJarDD.getStatus()!=EjbJar.STATE_INVALID_UNPARSABLE) && ejbJarFO != null) {
                                AssemblyDescriptor asmDesc = ejbJarDD.getSingleAssemblyDescriptor();
                                err.log("asm desc: " + asmDesc);
                                
                                if (asmDesc != null) {
                                    // container transaction part under assembly descriptor
                                    ContainerTransaction[] contTx = asmDesc.getContainerTransaction();
                                    if ((contTx != null) && (contTx.length > 0)) {
                                        for (int c=0; c<contTx.length; c++) {
                                            ContainerTransaction cTx = contTx[c];
                                            err.log("ctx: " + cTx);
                                            if (cTx != null) {
                                                org.netbeans.modules.j2ee.dd.api.ejb.Method[] mtds = cTx.getMethod();
                                                if ((mtds != null) && (mtds.length > 0)) {
                                                    for (int m=0; m < mtds.length; m++) {
                                                        org.netbeans.modules.j2ee.dd.api.ejb.Method mtd = mtds[m];
                                                        err.log("mtd: " + mtd);
                                                        String mtdName = mtd.getMethodName();
                                                        err.log("mtdName: " + mtdName);
                                                        if (mtdName.equals(method.getName())) {
                                                            String invokedEjbName = mtd.getEjbName();
                                                            err.log("invokedejb: " + invokedEjbName);
                                                            String ejbName = Utility.getEjbNameForClass(ejbJarDD, jc);
                                                            err.log("ejbname: " + ejbName);
                                                            if (invokedEjbName.equals(ejbName)) {
                                                                RefactoringElementImplementation elem = new EjbJarContainerTxWhereUsedRefactoringElement(ejbJarDD, mtdName, ejbName, ejbJarFO);
                                                                refactoringElements.add(refactoring, elem);
                                                            }
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    }

                                    // method permissions part under assembly descriptor
                                    MethodPermission[] mtdPerms = asmDesc.getMethodPermission();
                                    if ((mtdPerms != null) && (mtdPerms.length > 0)) {
                                        for (int c=0; c<mtdPerms.length; c++) {
                                            MethodPermission mtdPerm = mtdPerms[c];
                                            err.log("mtdPerm: " + mtdPerm);
                                            if (mtdPerm != null) {
                                                org.netbeans.modules.j2ee.dd.api.ejb.Method[] mtds = mtdPerm.getMethod();
                                                if ((mtds != null) && (mtds.length > 0)) {
                                                    for (int m=0; m < mtds.length; m++) {
                                                        org.netbeans.modules.j2ee.dd.api.ejb.Method mtd = mtds[m];
                                                        err.log("mtd: " + mtd);
                                                        String mtdName = mtd.getMethodName();
                                                        err.log("mtdName: " + mtdName);
                                                        if (mtdName.equals(method.getName())) {
                                                            String invokedEjbName = mtd.getEjbName();
                                                            err.log("invokedejb: " + invokedEjbName);
                                                            String ejbName = Utility.getEjbNameForClass(ejbJarDD, jc);
                                                            err.log("ejbname: " + ejbName);
                                                            if (invokedEjbName.equals(ejbName)) {
                                                                RefactoringElementImplementation elem = new EjbJarMethodPermissionWhereUsedRefactoringElement(ejbJarDD, mtdName, ejbName, ejbJarFO);
                                                                refactoringElements.add(refactoring, elem);
                                                            }
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    }

                                    // exclude list part under assembly descriptor
                                    ExcludeList excList = asmDesc.getExcludeList();
                                    err.log("excList: " + excList);
                                    if (excList != null) {
                                        org.netbeans.modules.j2ee.dd.api.ejb.Method[] mtds = excList.getMethod();
                                        if ((mtds != null) && (mtds.length > 0)) {
                                            for (int m=0; m < mtds.length; m++) {
                                                org.netbeans.modules.j2ee.dd.api.ejb.Method mtd = mtds[m];
                                                err.log("mtd: " + mtd);
                                                String mtdName = mtd.getMethodName();
                                                err.log("mtdName: " + mtdName);
                                                if (mtdName.equals(method.getName())) {
                                                    String invokedEjbName = mtd.getEjbName();
                                                    err.log("invokedejb: " + invokedEjbName);
                                                    String ejbName = Utility.getEjbNameForClass(ejbJarDD, jc);
                                                    err.log("ejbname: " + ejbName);
                                                    if (invokedEjbName.equals(ejbName)) {
                                                        RefactoringElementImplementation elem = new EjbJarExcludeListWhereUsedRefactoringElement(ejbJarDD, mtdName, ejbName, ejbJarFO);
                                                        refactoringElements.add(refactoring, elem);
                                                    }
                                                }

                                            }
                                        }
                                    }
                                }
                            
                            } else {
                                Problem newProblem = new Problem(false, NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarWhereUsedInvalidProblem"));
                                problem = Utility.addProblemsToEnd(problem, newProblem);
                            }
                        }
                        
                    }
                    
                    // method in SESSION BEAN IMPL CLASS
                    JavaClass javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.SESSION_BEAN);
                    err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        if (jc.isSubTypeOf(javaClass)) {
                            Method homeInHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, jc.getName(), false /*not local*/);
                            Method homeInLocalHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, jc.getName(), true /*local*/);
                            if (homeInHome != null) {
                                WhereUsedQuery whereHomeInHome = new WhereUsedQuery(homeInHome);
                                Problem p = whereHomeInHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            if (homeInLocalHome != null) {
                                WhereUsedQuery whereHomeInLocalHome = new WhereUsedQuery(homeInLocalHome);
                                Problem p = whereHomeInLocalHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            
                            return problem;
                        }
                    }
                    
                    // method in ENTITY BEANS IMPL CLASS
                    javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.ENTITY_BEAN);
                    err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        // first check if we are trying to rename a method from javax.ejb.EntityBean interface, and do not allow this
                        if (jc.isSubTypeOf(javaClass)) {
                            
                            // next check if we are trying to find some finder method finders in home/localhome need to be found, too
                            Method finderInHome = Utility.getHomeFinderMethodForImplFinderMethod(method, fo, jc.getName(), false /*not local*/);
                            Method finderInLocalHome = Utility.getHomeFinderMethodForImplFinderMethod(method, fo, jc.getName(), true /*local*/);
                            if (finderInHome != null) {
                                WhereUsedQuery whereFinderInHome = new WhereUsedQuery(finderInHome);
                                Problem p = whereFinderInHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            if (finderInLocalHome != null) {
                                WhereUsedQuery whereFinderInLocalHome = new WhereUsedQuery(finderInLocalHome);
                                Problem p = whereFinderInLocalHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }

                            Method homeInHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, jc.getName(), false /*not local*/);
                            Method homeInLocalHome = Utility.getHomeHomeMethodForSessionImplHomeMethod(method, fo, jc.getName(), true /*local*/);
                            if (homeInHome != null) {
                                WhereUsedQuery whereHomeInHome = new WhereUsedQuery(homeInHome);
                                Problem p = whereHomeInHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            if (homeInLocalHome != null) {
                                WhereUsedQuery whereHomeInLocalHome = new WhereUsedQuery(homeInLocalHome);
                                Problem p = whereHomeInLocalHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }

                            if (method.getName().startsWith("ejbSelect")) { // NOI18N
                                Project prj = FileOwnerQuery.getOwner(fo);
                                if (prj != null) {
                                    org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod =
                                            org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(prj.getProjectDirectory());
                                    Entity[] eBeans = Utility.getEntityBeans(emod);
                                    EjbJar ejbJarDD = Utility.getEjbJar(emod);
                                    if ((eBeans != null) && (ejbJarDD != null)) {
                                        for (int e = 0; e < eBeans.length; e++) {
                                            Entity entity = eBeans[e];
                                            String ejbClass = entity.getEjbClass();
                                            if (jc.getName().equals(ejbClass)) {
                                                Query[] queries = entity.getQuery();
                                                for (int q = 0; q < queries.length; q++) {
                                                    Query query = queries[q];
                                                    QueryMethod qm = query.getQueryMethod();
                                                    err.log("query method: " + qm);
                                                    if (method.getName().equals(qm.getMethodName())) {
                                                        RefactoringElementImplementation elem =
                                                                new EjbJarSelectMethodWhereUsedRefactoringElement(
                                                                        ejbJarDD, method.getName(),
                                                                        emod.getDeploymentDescriptor());
                                                        refactoringElements.add(refactoring, elem);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            return problem;
                        }
                    }

                    // HOME INTERFACE CLASS
                    javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_HOME);
                    err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        if (jc.isSubTypeOf(javaClass)) {

                            // next check if we are trying to rename some finder method - this is allowed with some restrictions and finders in implclass/localhome need to be renamed, too
                            Method finderInImpl = Utility.getImplFinderMethodForHomeFinderMethod(method, fo, jc.getName(), false /*not local*/);
                            Method finderInLocalHome = Utility.getHomeFinderMethodForHomeFinderMethod(method, fo, jc.getName(), true /*local*/);
                            if (finderInImpl != null) {
                                WhereUsedQuery renameFinderInImpl = new WhereUsedQuery(finderInImpl);
                                Problem p = renameFinderInImpl.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            if (finderInLocalHome != null) {
                                WhereUsedQuery renameFinderInLocalHome = new WhereUsedQuery(finderInLocalHome);
                                Problem p = renameFinderInLocalHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            Project prj = FileOwnerQuery.getOwner(fo);
                            if (prj != null) {                        
                                org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(prj.getProjectDirectory());
                                Entity[] eBeans = Utility.getEntityBeans(emod);
                                EjbJar ejbJarDD = Utility.getEjbJar(emod);
                                if ((eBeans != null) && (ejbJarDD != null)) {
                                    for (int e=0; e < eBeans.length; e++) {
                                        Entity entity = eBeans[e];
                                        String ejbClass = entity.getHome();
                                        if (jc.getName().equals(ejbClass)) {
                                            Query[] queries = entity.getQuery();
                                            for (int q=0; q<queries.length; q++) {
                                                Query query = queries[q];
                                                QueryMethod qm = query.getQueryMethod();
                                                err.log("query method: " + qm);
                                                if (method.getName().equals(qm.getMethodName())) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarFinderMethodWhereUsedRefactoringElement(ejbJarDD, method.getName(), emod.getDeploymentDescriptor());
                                                    refactoringElements.add(refactoring, elem);
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            // next check if we are trying to rename some home method - this is allowed with some restrictions and homes in implclass/localhome need to be renamed, too
                            Method homeInImpl = Utility.getImplHomeMethodForHomeHomeMethod(method, fo, jc.getName(), false /*not local*/);
                            Method homeInLocalHome = Utility.getHomeHomeMethodForHomeHomeMethod(method, fo, jc.getName(), true /*local*/);
                            if (homeInImpl != null) {
                                WhereUsedQuery renameHomeInImpl = new WhereUsedQuery(homeInImpl);
                                Problem p = renameHomeInImpl.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            if (homeInLocalHome != null) {
                                WhereUsedQuery renameHomeInLocalHome = new WhereUsedQuery(homeInLocalHome);
                                Problem p = renameHomeInLocalHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            return problem;
                        }
                    }

                    // LOCAL HOME INTERFACE CLASS
                    javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(Utility.EJB_LOCAL_HOME);
                    err.log("javaclass: " + javaClass);
                    if (!(javaClass instanceof UnresolvedClass)) {
                        if (jc.isSubTypeOf(javaClass)) {
                            
                            Method finderInImpl = Utility.getImplFinderMethodForHomeFinderMethod(method, fo, jc.getName(), true /*local*/);
                            Method finderInHome = Utility.getHomeFinderMethodForHomeFinderMethod(method, fo, jc.getName(), false /*not local*/);
                            if (finderInImpl != null) {
                                WhereUsedQuery renameFinderInImpl = new WhereUsedQuery(finderInImpl);
                                Problem p = renameFinderInImpl.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            if (finderInHome != null) {
                                WhereUsedQuery renameFinderInHome = new WhereUsedQuery(finderInHome);
                                Problem p = renameFinderInHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }

                            Project prj = FileOwnerQuery.getOwner(fo);
                            if (prj != null) {                        
                                org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(prj.getProjectDirectory());
                                Entity[] eBeans = Utility.getEntityBeans(emod);
                                EjbJar ejbJarDD = Utility.getEjbJar(emod);
                                if ((eBeans != null) && (ejbJarDD != null)) {
                                    for (int e=0; e < eBeans.length; e++) {
                                        Entity entity = eBeans[e];
                                        String ejbClass = entity.getLocalHome();
                                        if (jc.getName().equals(ejbClass)) {
                                            Query[] queries = entity.getQuery();
                                            for (int q=0; q<queries.length; q++) {
                                                Query query = queries[q];
                                                QueryMethod qm = query.getQueryMethod();
                                                err.log("query method: " + qm);
                                                if (method.getName().equals(qm.getMethodName())) {
                                                    RefactoringElementImplementation elem = 
                                                            new EjbJarFinderMethodWhereUsedRefactoringElement(ejbJarDD, method.getName(), emod.getDeploymentDescriptor());
                                                    refactoringElements.add(refactoring, elem);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            
                            // next check if we are trying to rename some home method - this is allowed with some restrictions and homes in implclass/home need to be renamed, too
                            Method homeInImpl = Utility.getImplHomeMethodForHomeHomeMethod(method, fo, jc.getName(), true /*not local*/);
                            Method homeInHome = Utility.getHomeHomeMethodForHomeHomeMethod(method, fo, jc.getName(), false /*local*/);
                            if (homeInImpl != null) {
                                WhereUsedQuery renameHomeInImpl = new WhereUsedQuery(homeInImpl);
                                Problem p = renameHomeInImpl.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            if (homeInHome != null) {
                                WhereUsedQuery renameHomeInHome = new WhereUsedQuery(homeInHome);
                                Problem p = renameHomeInHome.prepare(session);
                                problem = Utility.addProblemsToEnd(problem, p);
                            }
                            return problem;
                        }
                    }                    
                }
            }
            
        } // method
        
        return problem;
    }

    public final class EjbJarBeanClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarBeanWhereUsedRefactoringElement */
        public EjbJarBeanClassWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarBeanClassWhereUsed"), args);
        }
    }
    
    public final class EjbJarLocalWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarBeanWhereUsedRefactoringElement */
        public EjbJarLocalWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarLocalWhereUsed"), args);
        }
    }

    public final class EjbJarLocalHomeWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarLocalHomeWhereUsedRefactoringElement */
        public EjbJarLocalHomeWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarLocalHomeWhereUsed"), args);
        }
    }
    
    public final class EjbJarHomeWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarLocalHomeWhereUsedRefactoringElement */
        public EjbJarHomeWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarHomeWhereUsed"), args);
        }
    }

    public final class EjbJarRemoteWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarRemoteWhereUsedRefactoringElement */
        public EjbJarRemoteWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarRemoteWhereUsed"), args);
        }
    }

    public final class EjbJarServiceEndpointWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarServiceEndpointWhereUsedRefactoringElement */
        public EjbJarServiceEndpointWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarServiceEndpointWhereUsed"), args);
        }
    }    
    
    public final class EjbJarRefLocalWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarRefLocalWhereUsedRefactoringElement */
        public EjbJarRefLocalWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarRefLocalWhereUsed"), args);
        }
    }
    
    public final class EjbJarRefLocalHomeWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarRefLocalHomeWhereUsedRefactoringElement */
        public EjbJarRefLocalHomeWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarRefLocalHomeWhereUsed"), args);
        }
    }

    public final class EjbJarRefHomeWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarRefHomeWhereUsedRefactoringElement */
        public EjbJarRefHomeWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarRefHomeWhereUsed"), args);
        }
    }

    public final class EjbJarRefRemoteWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarRefRemoteWhereUsedRefactoringElement */
        public EjbJarRefRemoteWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarRefRemoteWhereUsed"), args);
        }
    }
    
    public final class EjbJarFinderMethodWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarFinderMethodWhereUsedRefactoringElement */
        public EjbJarFinderMethodWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarFinderMethodWhereUsed"), args);
        }
    }
    
    public final class EjbJarSelectMethodWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;

        /** Creates a new instance of EjbJarSelectMethodWhereUsedRefactoringElement */
        public EjbJarSelectMethodWhereUsedRefactoringElement(EjbJar ejbJarDD, String name, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarSelectMethodWhereUsed"), args);
        }
    }    

    public final class EjbJarContainerTxWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;
        protected String ejbName;

        /** Creates a new instance of EjbJarContainerTxWhereUsedRefactoringElement */
        public EjbJarContainerTxWhereUsedRefactoringElement(EjbJar ejbJarDD, String mtdName, String ejbName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = mtdName;
            this.ejbName = ejbName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name, ejbName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarContainerTxMethodWhereUsed"), args);
        }
    }    

    public final class EjbJarExcludeListWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;
        protected String ejbName;

        /** Creates a new instance of EjbJarExcludeListWhereUsedRefactoringElement */
        public EjbJarExcludeListWhereUsedRefactoringElement(EjbJar ejbJarDD, String mtdName, String ejbName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = mtdName;
            this.ejbName = ejbName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name, ejbName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarExcludeListMethodWhereUsed"), args);
        }
    }    

    public final class EjbJarMethodPermissionWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected EjbJar ejbJarDD;
        protected String ejbName;

        /** Creates a new instance of EjbJarMethodPermissionWhereUsedRefactoringElement */
        public EjbJarMethodPermissionWhereUsedRefactoringElement(EjbJar ejbJarDD, String mtdName, String ejbName, FileObject parentFile) { 
            this.ejbJarDD = ejbJarDD;
            this.name = mtdName;
            this.ejbName = ejbName;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name, ejbName};
            return MessageFormat.format(NbBundle.getMessage(EjbJarWhereUsedRefactoring.class, "TXT_EjbJarMethodPermissionMethodWhereUsed"), args);
        }
    }    
    
}
