/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.whereused;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class collects usages of managed classes listed
 * in the persistence.xml file.
 *
 * @author Erno Mononen
 */
public class PersistenceXmlWhereUsedRefactoring {
    
    /**
     * Creates a new instance of PersistenceXmlWhereUsedRefactoring
     */
    public PersistenceXmlWhereUsedRefactoring() {
    }
    
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
        
        Problem problem = null;
        
        if (!(refObject instanceof JavaClass)) {
            return null;
        }
        
        JavaClass javaClass = (JavaClass)refObject;
        
        for (FileObject ddFile : PersistenceRefactoringUtil.getPersistence(javaClass)) {
            
            PUDataObject dataObject = ProviderUtil.getPUDataObject(ddFile);
            
            if (!ProviderUtil.isValid(dataObject)){
                Problem newProblem =
                        new Problem(false, NbBundle.getMessage(PersistenceXmlWhereUsedRefactoring.class, "TXT_PersistenceXmlInvalidProblem", ddFile.getPath()));
                problem = Utility.addProblemsToEnd(problem, newProblem);
                continue;
            }
            
            PersistenceUnit[] persistenceUnits = ProviderUtil.getPersistenceUnits(dataObject);
            
            for (int i = 0; i < persistenceUnits.length; i++) {
                PersistenceUnit unit = persistenceUnits[i];
                for (int j = 0; j < unit.getClass2().length; j++) {
                    if (unit.getClass2()[j].equals(javaClass.getName())){
                        RefactoringElementImplementation refactoringElem =
                                new PersistenceXmlWhereUsedElement(javaClass.getName(), ddFile);
                        refactoringElements.add(refactoring, refactoringElem);
                    }
                    
                }
            }
        }
        
        return problem;
        
    }
    
    private static class PersistenceXmlWhereUsedElement extends AbstractWhereUsedRefactoringElement {
        
        public PersistenceXmlWhereUsedElement(String name, FileObject parentFile) {
            this.name = name;
            this.parentFile = parentFile;
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlWhereUsedRefactoring.class, "TXT_PersistenceXmlClassWhereUsed"), args);
        }
    }
    
}
