/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.whereused;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRefHandler;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * @author Martin Grebac
 */
public final class WebXmlWhereUsedRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.whereused");   // NOI18N

    public WebXmlWhereUsedRefactoring() { }

    /** Find usages in web deployment descriptor: web.xml 
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
            
        Problem problem = null;
        if (refObject instanceof JavaClass) {
            
            JavaClass jClass = (JavaClass)refObject;
            err.log("jClass: " + jClass);
            
            String name = jClass.getName();
            err.log("name: " + name);
            Resource res = jClass.getResource();
            err.log("res: " + res);
            
            FileObject fo = JavaModel.getFileObject(res);
            err.log("fo: " + fo);

            Collection wmodules = Utility.getRelevantWebModules(fo);
            Iterator wmIter = null;

            if (wmodules != null) {
                wmIter = wmodules.iterator();
            }
            if (wmIter != null) {
                while (wmIter.hasNext()) {
                    WebModule wm = (WebModule)wmIter.next();
                    if (wm != null) {              // the class is in a web module
                        FileObject webXmlFO = wm.getDeploymentDescriptor();
                        err.log("webxmlfo: " + webXmlFO);
                        WebApp webXmlDD = null;
                        try {
                            webXmlDD = org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(webXmlFO);
                        } catch (IOException ioe) {
                            //Ignore
                        }
                        err.log("webXmlDD: " + webXmlDD);
                        if ((webXmlDD != null) && (webXmlDD.getStatus()!=WebApp.STATE_INVALID_UNPARSABLE)) {

                            //servlets
                            Servlet[] servlets = webXmlDD.getServlet();
                            if ((servlets!=null) && (servlets.length > 0)) {
                                for (int s=0; s < servlets.length; s++) {
                                    Servlet servlet = servlets[s];
                                    err.log("Servlet: " + servlet);
                                    String servletClass = servlet.getServletClass();
                                    err.log("Servlet class: " + servletClass);
                                    if ((servletClass != null) && (servletClass.equals(name))) {
                                        RefactoringElementImplementation elem = 
                                                new WebXmlServletWhereUsedRefactoringElement(webXmlDD, name, webXmlFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }
                            //listeners
                            Listener[] listeners = webXmlDD.getListener();
                            if ((listeners!=null) && (listeners.length > 0)) {
                                for (int s=0; s < listeners.length; s++) {
                                    Listener listener = listeners[s];
                                    err.log("Listener: " + listener);
                                    String listenerClass = listener.getListenerClass();
                                    err.log("Listener class: " + listenerClass);
                                    if ((listenerClass != null) && (listenerClass.equals(name))) {
                                        RefactoringElementImplementation elem = 
                                                new WebXmlListenerWhereUsedRefactoringElement(webXmlDD, name, webXmlFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }

                            //filters
                            Filter[] filters = webXmlDD.getFilter();
                            if ((filters!=null) && (filters.length > 0)) {
                                for (int s=0; s < filters.length; s++) {
                                    Filter filter = filters[s];
                                    err.log("Filter: " + filter);
                                    String filterClass = filter.getFilterClass();
                                    err.log("Filter class: " + filterClass);
                                    if ((filterClass != null) && (filterClass.equals(name))) {
                                        RefactoringElementImplementation elem =
                                                new WebXmlFilterWhereUsedRefactoringElement(webXmlDD, name, webXmlFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }

                            // refs
                            org.netbeans.modules.j2ee.dd.api.common.EjbRef[] refs = webXmlDD.getEjbRef();
                            if ((refs != null) && (refs.length > 0)) {
                                for (int l=0; l < refs.length; l++) {
                                    org.netbeans.modules.j2ee.dd.api.common.EjbRef ref = refs[l];
                                    err.log("EJB ref: " + ref);
                                    String refHome = ref.getHome();
                                    err.log("home ref: " + refHome);
                                    if ((refHome != null) && (refHome.equals(name))) {
                                        RefactoringElementImplementation elem = 
                                                new WebXmlRefHomeWhereUsedRefactoringElement(webXmlDD, name, webXmlFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String refRemote = ref.getRemote();
                                    err.log("remote ref: " + refRemote);
                                    if ((refRemote != null) && (refRemote.equals(name))) {
                                        RefactoringElementImplementation elem = 
                                                new WebXmlRefRemoteWhereUsedRefactoringElement(webXmlDD, name, webXmlFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }

                            // local refs
                            org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef[] localRefs = webXmlDD.getEjbLocalRef();
                            if ((localRefs != null) && (localRefs.length > 0)) {
                                for (int l=0; l < localRefs.length; l++) {
                                    org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef localRef = localRefs[l];
                                    err.log("EJB local ref: " + localRef);
                                    String refLocal = localRef.getLocal();
                                    err.log("local ref: " + refLocal);
                                    if ((refLocal != null) && (refLocal.equals(name))) {
                                        RefactoringElementImplementation elem = 
                                                new WebXmlRefLocalWhereUsedRefactoringElement(webXmlDD, name, webXmlFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                    String refLocalHome = localRef.getLocalHome();
                                    err.log("localHome ref: " + refLocalHome);
                                    if ((refLocalHome != null) && (refLocalHome.equals(name))) {
                                        RefactoringElementImplementation elem = 
                                                new WebXmlRefLocalHomeWhereUsedRefactoringElement(webXmlDD, name, webXmlFO);
                                        refactoringElements.add(refactoring, elem);
                                    }
                                }
                            }
                            ServiceRef[] serviceRef;
                            try {
                                serviceRef = webXmlDD.getServiceRef();
                            } catch (VersionNotSupportedException e) {
                                serviceRef = null;
                            }
                            if (serviceRef != null) {
                                for (int i = 0; i < serviceRef.length; i++) {
                                    ServiceRefHandler[] handlers = serviceRef[i].getHandler();
                                    for (int j = 0; j < handlers.length; j++) {
                                        if (name.equals(handlers[j].getHandlerName())) {
                                            RefactoringElementImplementation elem =
                                                    new WebXmlHandlerNameWhereUsedRefactoringElement(webXmlDD, name,
                                                            webXmlFO);
                                            refactoringElements.add(refactoring, elem);
                                        }
                                        if (name.equals(handlers[j].getHandlerClass())) {
                                            RefactoringElementImplementation elem =
                                                    new WebXmlHandlerClassWhereUsedRefactoringElement(webXmlDD, name,
                                                            webXmlFO);
                                            refactoringElements.add(refactoring, elem);
                                        }
                                    }
                                }
                            }
                        } else {
                            Problem newProblem = new Problem(false, NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlWhereUsedInvalidProblem"));
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }
                    }
                } // while wmIter
            }
        } // javaclass
        return problem;
    }
    
    public final class WebXmlServletWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefactoringElement */
        public WebXmlServletWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlServletWhereUsed"), args);
        }
    }

    public final class WebXmlFilterWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefactoringElement */
        public WebXmlFilterWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlFilterWhereUsed"), args);
        }
    }

    public final class WebXmlListenerWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefactoringElement */
        public WebXmlListenerWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlListenerWhereUsed"), args);
        }
    }
            
    public final class WebXmlRefHomeWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefHomeWhereUsedRefactoringElement */
        public WebXmlRefHomeWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlRefHomeWhereUsed"), args);
        }
    }
    
    public final class WebXmlRefRemoteWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefRemoteWhereUsedRefactoringElement */
        public WebXmlRefRemoteWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlRefRemoteWhereUsed"), args);
        }
    }    

    public final class WebXmlRefLocalWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefLocalWhereUsedRefactoringElement */
        public WebXmlRefLocalWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) { 
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlRefLocalWhereUsed"), args);
        }
    }    
    
    public final class WebXmlHandlerClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        public WebXmlHandlerClassWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlHandlerClassWhereUsed", name);
        }
    }

    public final class WebXmlHandlerNameWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        public WebXmlHandlerNameWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlHandlerNameWhereUsed", name);
        }
    }

    public final class WebXmlRefLocalHomeWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected WebApp webXmlDD;

        /** Creates a new instance of WebXmlRefLocalHomeWhereUsedRefactoringElement */
        public WebXmlRefLocalHomeWhereUsedRefactoringElement(WebApp webXmlDD, String name, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(WebXmlWhereUsedRefactoring.class, "TXT_WebXmlRefLocalHomeWhereUsed"), args);
        }
    }        
    
}
