/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.test;

import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

import java.io.IOException;

/**
 *
 * @author Martin Grebac
 */
public class J2EEMoveClassRefactoringTest extends J2EERefactoringTest {
    private static final String PROJECT_WEBAPP = "webapp";
    private static final String PROJECT_WEBAPP2 = "webapp2";
    private static final String PROJECT_EJBMOD2 = "ejbmod2";
    private static final String PROJECT_WEBAPPEMPTY = "webapp-empty";

    public J2EEMoveClassRefactoringTest(String testName) {
        super(testName);
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite("J2EEMoveClassRefactoringTest");
        suite.addTest(new J2EEMoveClassRefactoringTest("testPrepare"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testTldMoveClass"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testWebMoveClass"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testTldMoveClassOtherProject"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testWebMoveClassOtherProject"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testTldMoveClassOtherEmptyProject"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testEjbMoveClass"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testWebsvcMoveClass"));
        suite.addTest(new J2EEMoveClassRefactoringTest("testCleanup"));
        return suite;
    }

    /**
     * Opens projects for tests
     */
    public void testPrepare() {
        openProject(PROJECT_WEBAPP);
        openProject(PROJECT_WEBAPP2);
        openProject(PROJECT_WEBAPPEMPTY);
        openProject(PROJECT_EJBMOD2);
    }

    /** Moves
     *      tag handler
     *  and checks moved files and mytld.tld for differences
     */
    public void testTldMoveClass() throws FileStateInvalidException, IOException {

        // this part is here to test if the documents opened in editor are changed, too, which is a bug 55045
        FileObject fo = FileUtil.toFileObject(getProjectFile(PROJECT_WEBAPP, "web/WEB-INF/tlds/mytld.tld"));
        TLDDataObject tdo = ((TLDDataObject)DataObject.find(fo));
        ((OpenCookie)tdo.getCookie(OpenCookie.class)).open();
        // end of 55045 part

        doMoveClassRefactoring(PROJECT_WEBAPP, "abc.NewTagHandler", null, "xyz.ccc", "move tag handler");

        // another 55045 specific part
        EditorCookie ec = (EditorCookie)tdo.getCookie(EditorCookie.class);
        try {
            ec.getDocument().insertString(0, " ", null);
            ec.saveDocument();
            ec.getDocument().remove(0, 1);
            ec.saveDocument();
        } catch (Exception e) {
            fail(e.toString());
        }
        // end of 55045 specific part

        // check modified files
        try {
            checkGoldenFile(PROJECT_WEBAPP, "src/java/xyz/ccc/NewTagHandler.java", "NewTagHandler.pass");

            // check TLD
            checkFile(PROJECT_WEBAPP, "web/WEB-INF/tlds/mytld.tld", new String[]{">xyz.ccc.NewTagHandler<"},
                    new String[]{">abc.NewTagHandler<"});

        } catch (FileStateInvalidException e) {
            fail(e.getMessage());
        } catch (IOException e) {
            fail(e.getMessage());
        }
    }

    /** Moves
     *      servlet
     *      filter
     *      listener
     *  and checks moved files and web.xml for differences
     */
    public void testWebMoveClass() throws FileStateInvalidException, IOException {

        doMoveClassRefactoring(PROJECT_WEBAPP, "abc.NewServlet", "abc.NewSimpleFilter", "abc.NewServletListener", "xyz.ccc",
                "move classes", null);

        // check modified files
        try {
            checkGoldenFile(PROJECT_WEBAPP, "src/java/xyz/ccc/NewServlet.java", "NewServlet.pass");
            checkGoldenFile(PROJECT_WEBAPP, "src/java/xyz/ccc/NewSimpleFilter.java", "NewSimpleFilter.pass");
            checkGoldenFile(PROJECT_WEBAPP, "src/java/xyz/ccc/NewServletListener.java", "NewServletListener.pass");
            // check web.xml
            checkFile(PROJECT_WEBAPP, "web/WEB-INF/web.xml",
                    new String[]{">xyz.ccc.NewServlet<", ">xyz.ccc.NewSimpleFilter<", ">xyz.ccc.NewServletListener<"},
                    new String[]{">abc.NewServlet<", ">abc.NewSimpleFilter<", ">abc.NewServletListener<"});
        } catch (FileStateInvalidException e) {
            fail(e.getMessage());
        } catch (IOException e) {
            fail(e.getMessage());
        }
    }

    /** Moves
     *      tag handler
     *  to a different project and checks moved files and mytld.tld and tld2.tld for differences
     */
    public void testTldMoveClassOtherProject() throws FileStateInvalidException, IOException {


        doMoveClassRefactoring(PROJECT_WEBAPP, "xyz.ccc.NewTagHandler", PROJECT_WEBAPP2, "pkg.subpkg", "move tag handler to other project"
        );

        // check modified files
        try {
            checkGoldenFile(PROJECT_WEBAPP2, "src/java/pkg/subpkg/NewTagHandler.java", "NewTagHandlerOtherProject.pass");

            // check TLD in original project
            checkFile(PROJECT_WEBAPP, "web/WEB-INF/tlds/mytld.tld", null,
                    new String[]{">xyz.ccc.NewTagHandler<", "NewTagHandler"});

            // check TLD in target project
            checkFile(PROJECT_WEBAPP2, "web/WEB-INF/tlds/tld2.tld",
                    new String[]{">pkg.subpkg.NewTagHandler<", "NewTagHandler<"}, null);
        } catch (FileStateInvalidException e) {
            fail(e.getMessage());
        } catch (IOException e) {
            fail(e.getMessage());
        }
    }

    /** Checks move
     *      tag handler
     *  to different project without TLD file
     */
    public void testTldMoveClassOtherEmptyProject() throws FileStateInvalidException, IOException {
        // move to other project without a tld file should warn user that the project doesn't contain tld
        // and mappings cannot be moved
        RefactoringSession result = RefactoringSession.create("move tag handler to other project where no tld exists");
        MoveClassRefactoring refactoring = createMoveClassRefactoring(PROJECT_WEBAPP2, "pkg.subpkg.NewTagHandler", PROJECT_WEBAPPEMPTY,
                "pkg1.pkg2"
        );
        assertNotNull(refactoring.prepare(result));
    }


    /** Moves
     *      servlet
     *      filter
     *      listener
     *  to other project and checks moved files and web.xmls for differences
     */
    public void testWebMoveClassOtherProject() throws FileStateInvalidException, IOException {

        doMoveClassRefactoring(PROJECT_WEBAPP, "xyz.ccc.NewServlet", "xyz.ccc.NewSimpleFilter", "xyz.ccc.NewServletListener",
                "pkg.subpkg", "move classes to other project", PROJECT_WEBAPP2);

        // check modified files
        try {
            checkGoldenFile(PROJECT_WEBAPP2, "src/java/pkg/subpkg/NewServlet.java", "NewServletOtherProject.pass");
            checkGoldenFile(PROJECT_WEBAPP2, "src/java/pkg/subpkg/NewSimpleFilter.java",
                    "NewSimpleFilterOtherProject.pass");
            checkGoldenFile(PROJECT_WEBAPP2, "src/java/pkg/subpkg/NewServletListener.java",
                    "NewServletListenerOtherProject.pass");

            // check web.xml in original project
            checkFile(PROJECT_WEBAPP, "web/WEB-INF/web.xml", null, new String[]{">xyz.ccc.NewServlet<",
                    ">xyz.ccc.NewSimpleFilter<", ">xyz.ccc.NewServletListener<", "NewSimpleFilter", "ServletContextListener",
                    "NewServlet"});
            // check web.xml in target project
            checkFile(PROJECT_WEBAPP2, "web/WEB-INF/web.xml", new String[]{">pkg.subpkg.NewServlet<",
                    ">pkg.subpkg.NewSimpleFilter<", ">pkg.subpkg.NewServletListener<", "NewSimpleFilter",
                    "ServletContextListener", "NewServlet"}, null);
        } catch (FileStateInvalidException e) {
            fail(e.getMessage());
        } catch (IOException e) {
            fail(e.getMessage());
        }
    }

    /** Moves
     *      session bean implementation class
     *      session bean local interface
     *      session bean local home interface
     *      session bean remote interface
     *      session bean remote home interface
     *      queue message bean impl class
     *      topic message bean impl class
     *      CMP entity bean impl class
     *      CMP entity bean local interface
     *      CMP entity bean local home interface
     *      BMP entity bean impl class
     *      BMP entity bean local interface
     *      BMP entity bean local home interface
     * and checks renamed files and ejb-jar.xml for differences
     */
    public void testEjbMoveClass() throws FileStateInvalidException, IOException {

//        File original;
//        String golden;
//
//        MoveClassRefactoring refactoring;
//        RefactoringSession result;
//
//        FileObject pkg = FileUtil.toFileObject(new File ( getDataDir().getAbsolutePath() + "/projects/webapp/src/java/xyz/ccc"));
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewSessionBean");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename session bean");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewSessionLocal");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename session bean's local interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewSessionLocalHome");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename session bean's local home interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewSessionRemote");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename session bean's remote interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewSessionRemoteHome");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename session bean's remote home interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewMessageBean");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename queue message bean");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewMessageTopicBean");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename topic message bean");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewEntityContainerBean");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename entity container bean");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewEntityContainerLocal");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename entity container bean's local interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewEntityContainerLocalHome");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename entity container bean's local home interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewEntityBeanMPBean");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename entity bmp bean");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.enterprise.beans.NewEntityBeanMPLocal");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename entity bmp bean's local interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//        
//        classDefinition = Helper.findClass("my.enterprise.beans.NewEntityBeanMPLocalHome");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename entity bmp bean's local home interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.ws.server.NewWebServiceBean");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename ws server impl bean");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        classDefinition = Helper.findClass("my.ws.server.NewWebServiceSEI");
//        refactoring = new MoveClassRefactoring(classDefinition);
//        refactoring.preCheck();
//        refactoring.setTarget(pkg);
//        refactoring.checkParameters();
//        result = RefactoringSession.create("rename ws server servlet endpoint interface");
//        refactoring.prepare(result);
//        assertNull(result.doRefactoring(true)); 
//
//        // check modified files
//        try {
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedSessionBean.java");
//            golden = "RenamedSessionBean.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//            
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedSessionLocal.java");
//            golden = "RenamedSessionLocal.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedSessionLocalHome.java");
//            golden = "RenamedSessionLocalHome.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedSessionRemote.java");
//            golden = "RenamedSessionRemote.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedSessionRemoteHome.java");
//            golden = "RenamedSessionRemoteHome.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedMessageBean.java");
//            golden = "RenamedMessageBean.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedMessageTopicBean.java");
//            golden = "RenamedMessageTopicBean.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedEntityContainerBean.java");
//            golden = "RenamedEntityContainerBean.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedEntityContainerLocal.java");
//            golden = "RenamedEntityContainerLocal.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedEntityContainerLocalHome.java");
//            golden = "RenamedEntityContainerLocalHome.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedEntityBeanMPBean.java");
//            golden = "RenamedEntityBeanMPBean.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedEntityBeanMPLocal.java");
//            golden = "RenamedEntityBeanMPLocal.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/enterprise/beans/RenamedEntityBeanMPLocalHome.java");
//            golden = "RenamedEntityBeanMPLocalHome.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/ws/server/RenamedWebServiceBean.java");
//            golden = "RenamedWebServiceBean.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/ws/server/RenamedWebServiceSEI.java");
//            golden = "RenamedWebServiceSEI.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/java/my/ws/server/NewWebService-config.xml");
//            golden = "NewWebService-configxml.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/conf/ejb-jar.xml");
//            golden = "ejbjarxml.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//            original = new File ( getDataDir().getAbsolutePath() + "/projects/ejbmod2/src/conf/webservices.xml");
//            golden = "webservicesxml.pass";
//            assertFile(original, getGoldenFile(golden), getWorkDir());
//
//        } catch (FileStateInvalidException e) {
//            fail(e.getMessage());
//        } catch (IOException e) {
//            fail(e.getMessage());
//        }
    }

    /** Moves
     *      ws server impl
     *      ws SEI
     *  and checks moved files, web.xml, webservices.xml for differences
     */
    public void testWebsvcMoveClass() throws FileStateInvalidException, IOException {

        doMoveClassRefactoring(PROJECT_EJBMOD2, "my.ws.server.NewWebServiceBean", null, "xyz.ccc", "move ws impl bean");

        // check modified files
        try {
            checkGoldenFile(PROJECT_EJBMOD2, "src/java/xyz/ccc/NewWebServiceBean.java", "NewWebServiceBean.pass");

            // check wscompile config file
            checkFile(PROJECT_EJBMOD2, "src/java/my/ws/server/NewWebService-config.xml",
                    new String[]{"xyz.ccc.NewWebServiceBean", "packageName=\"my.ws.server\""},
                    new String[]{"my.ws.server.NewWebServiceBean"});

            // check ejb-jar
            checkFile(PROJECT_EJBMOD2, "src/conf/ejb-jar.xml", new String[]{">xyz.ccc.NewWebServiceBean<"},
                    new String[]{">my.ws.server.NewWebServiceBean<"});

        } catch (FileStateInvalidException e) {
            fail(e.getMessage());
        } catch (IOException e) {
            fail(e.getMessage());
        }

        doMoveClassRefactoring(PROJECT_EJBMOD2, "my.ws.server.NewWebServiceSEI", null, "xyz.ccc", "move ws SEI");

        // check modified files
        try {
            checkGoldenFile(PROJECT_EJBMOD2, "src/java/xyz/ccc/NewWebServiceSEI.java", "NewWebServiceSEI.pass");

            // check wscompile config file
            checkFile(PROJECT_EJBMOD2, "src/java/xyz/ccc/NewWebService-config.xml",
                    new String[]{"xyz.ccc.NewWebServiceSEI", "packageName=\"xyz.ccc\""},
                    new String[]{"my.ws.server.NewWebServiceSEI"});

            // check webservices.xml
            checkFile(PROJECT_EJBMOD2, "src/conf/webservices.xml", new String[]{">xyz.ccc.NewWebServiceSEI<"},
                    new String[]{">my.ws.server.NewWebServiceSEI<"});

        } catch (FileStateInvalidException e) {
            fail(e.getMessage());
        } catch (IOException e) {
            fail(e.getMessage());
        }

    }

    /**
     * Opens projects for tests
     */
    public void testCleanup() {
        closeProject(PROJECT_WEBAPP);
        closeProject(PROJECT_WEBAPP2);
        closeProject(PROJECT_WEBAPPEMPTY);
        closeProject(PROJECT_EJBMOD2);
    }

    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
