/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.refactoring.test;

import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.ide.ProjectSupport;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.j2ee.refactoring.test.util.Helper;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.FileObject;

import java.io.IOException;
import java.io.File;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * @author pfiala
 */
public class J2EERefactoringTest extends NbTestCase {
    private static Map projectMap = new HashMap();

    public J2EERefactoringTest(String name) {
        super(name);
    }

    protected void doRenameRefactoring(String project, String className, String newName, String sessionDescription) {
        JavaClass javaClass = findClass(project, className);
        RenameRefactoring refactoring = new RenameRefactoring(javaClass);
        refactoring.preCheck();
        refactoring.setNewName(newName);
        refactoring.checkParameters();
        RefactoringSession result = RefactoringSession.create(sessionDescription);
        refactoring.prepare(result);
        assertNull(result.doRefactoring(true));
    }

    protected void checkGoldenFile(String project, String relativePath, String goldenFileName) throws IOException {
        assertFile(getProjectFile(project, relativePath), getGoldenFile(goldenFileName), getWorkDir());
    }

    protected String getProjectPath(String relativePath) {
        return getDataDir().getAbsolutePath() + "/projects/" + relativePath;
    }

    protected void doMoveClassRefactoring(String sourceProject, String className, String targetProject,
            String targetPackageName, String sessionDescription) {
        RefactoringSession result = RefactoringSession.create(sessionDescription);
        createMoveClassRefactoring(sourceProject, className, targetProject, targetPackageName).prepare(result);
        assertNull(result.doRefactoring(true));
    }

    protected void doMoveClassRefactoring(String sourceProject, String className1, String className2, String className3,
            String targetPackageName, String sessionDescription, String targetProject) {
        RefactoringSession result = RefactoringSession.create(sessionDescription);
        createMoveClassRefactoring(sourceProject, className1, className2, className3, targetProject, targetPackageName).prepare(result);
        assertNull(result.doRefactoring(true));
    }

    protected MoveClassRefactoring createMoveClassRefactoring(String sourceProject, String className,
            String targetProject, String targetPackage) {
        JavaClass javaClass = findClass(sourceProject, className);
        MoveClassRefactoring refactoring = new MoveClassRefactoring(javaClass);
        prepareMoveClassRefactoring(refactoring, javaClass, targetPackage, targetProject);
        return refactoring;
    }

    private void prepareMoveClassRefactoring(MoveClassRefactoring refactoring, JavaClass javaClass, String targetPackageName,
            String projectName) {
        refactoring.preCheck();
        FileObject targetClassPathRoot;
        if (projectName == null) {
            FileObject fileObject = JavaModel.getFileObject(javaClass.getResource());
            targetClassPathRoot = ClassPath.getClassPath(fileObject, ClassPath.SOURCE).getRoots()[0];
        } else {
            targetClassPathRoot = getProjectClasspathRoot(projectName);
        }
        refactoring.setTargetClassPathRoot(targetClassPathRoot);
        refactoring.setTargetPackageName(targetPackageName);
        refactoring.checkParameters();
    }

    private FileObject getProjectClasspathRoot(String projectName) {
        FileObject targetClassPathRoot;
        FileObject fileObject = FileUtil.toFileObject(getProjectFile(projectName, ""));
        Sources sources = ProjectUtils.getSources(FileOwnerQuery.getOwner(fileObject));
        SourceGroup[] sourceGroups = sources.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
        targetClassPathRoot = sourceGroups[0].getRootFolder();
        return targetClassPathRoot;
    }

    private MoveClassRefactoring createMoveClassRefactoring(String sourceProject, String className1, String className2,
            String className3, String targetProject, String targetPackage) {
        JavaClass javaClass = findClass(sourceProject, className1);
        Collection c = new ArrayList(3);
        c.add(javaClass.getResource());
        c.add(findClass(sourceProject, className2).getResource());
        c.add(findClass(sourceProject, className3).getResource());
        MoveClassRefactoring refactoring = new MoveClassRefactoring(c);
        prepareMoveClassRefactoring(refactoring, javaClass, targetPackage, targetProject);
        return refactoring;
    }

    protected void checkFile(String project, String relativePath, String[] mustContain, String[] mustNotContain) throws IOException{
        File file = getProjectFile(project, relativePath);
        String content = Helper.readFileContent(file);
        if (mustContain != null) {
            for (int i = 0; i < mustContain.length; i++) {
                String s = mustContain[i];
                if (!(content.indexOf(s) >= 0)) {
                    copyFile(file);
                    fail("File: " + file.getName() + " does not contain string: " + s);
                }
            }
        }
        if (mustNotContain != null) {
            for (int i = 0; i < mustNotContain.length; i++) {
                String s = mustNotContain[i];
                if (content.indexOf(s) >= 0) {
                    copyFile(file);
                    fail("File: " + file.getName() + " contains string: " + s);
                }

            }
        }
    }

    private void copyFile(File file) {
        String fileName = file.getName();
        try {
            FileUtil.copyFile(FileUtil.toFileObject(file), FileUtil.toFileObject(getWorkDir()),
                    fileName.substring(0, fileName.indexOf('.')));
        } catch (Exception e) {
            System.out.println("Exc: " + e);
        }
    }

    protected void openProject(String projectName) {
        projectMap.put(projectName, ProjectSupport.openProject(getProjectFile(projectName, "")));
    }

    protected void closeProject(String projectName) {
        Project project = (Project) projectMap.remove(projectName);
        if (project != null) {
            ProjectSupport.closeProject(ProjectUtils.getInformation(project).getDisplayName());
        }
    }

    protected File getProjectFile(String project, String relativePath) {
        return new File(getProjectPath(project + "/" + relativePath));
    }

    public JavaClass findClass(String project, String className) {
        for (int i = 0; i < 20; i++) {
            ClassPath classPath = ClassPath.getClassPath(getProjectClasspathRoot(project), ClassPath.SOURCE);
            JavaClass javaClass = findClass(className, classPath);
            if (javaClass !=null) {
                return javaClass;
            } else {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        throw new IllegalStateException("Class " + className + " not found.");
    }

    private static JavaClass findClass(String className, ClassPath classPath) {
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath(classPath);
            JavaClass javaClass = (JavaClass) JavaModel.getDefaultExtent().getType().resolve(className);
            return javaClass instanceof UnresolvedClass ? null : javaClass;
        } finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }
}
