/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.refactoring.test.util;

import org.openide.ErrorManager;

import javax.swing.*;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class Helper {

    /* Reads File into String array*/
    public static String readFileContent(File f) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileReader fileReader = new FileReader(f);
        int i;
        while ((i = fileReader.read()) != -1) {
            sb.append((char) i);
        }
        return sb.toString();
    }

    public static void waitForAWTDispatchThread() {
        final boolean[] finished = new boolean[]{false};
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                finished[0] = true;
            }
        });
        while (!finished[0]) {
            try {
                Thread.sleep(200);
            } catch (Exception e) {
                ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, e);
            }
        }
    }
}
