package league.ejb.session;
import java.math.BigDecimal;
import java.sql.Timestamp;
import league.ejb.*;
import league.ejb.entity.*;
import java.util.*;
import league.util.League;
import league.util.Match;
import league.util.Result;
import league.util.Round;

/**
 * This is the bean class for the LeagueFacadeBean enterprise bean.
 * Created Mar 9, 2005 1:40:25 PM
 * @author honza
 */
public class LeagueFacadeBean implements javax.ejb.SessionBean, league.ejb.session.LeagueFacadeRemoteBusiness {
    private javax.ejb.SessionContext context;
    private league.ejb.entity.LeagueLocalHome league=null;
    private league.ejb.entity.RoundLocalHome round=null;
    private league.ejb.entity.GroupsLocalHome groups=null;
    private league.ejb.entity.TeamLocalHome team=null;
    private league.ejb.entity.PlayerLocalHome player=null;
    private league.ejb.entity.PlaceInGroupLocalHome place=null;
    private league.ejb.entity.MatchLocalHome match=null;
    private league.ejb.entity.ResultLocalHome result=null;
    
    
    // <editor-fold defaultstate="collapsed" desc="EJB infrastructure methods. Click the + sign on the left to edit the code.">
    // TODO Add code to acquire and use other enterprise resources (DataSource, JMS, enterprise bean, Web services)
    // TODO Add business methods
    /**
     * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
     */
    public void setSessionContext(javax.ejb.SessionContext aContext) {
        context = aContext;
    }
    
    /**
     * @see javax.ejb.SessionBean#ejbActivate()
     */
    public void ejbActivate() {
        
    }
    
    /**
     * @see javax.ejb.SessionBean#ejbPassivate()
     */
    public void ejbPassivate() {
        
    }
    
    /**
     * @see javax.ejb.SessionBean#ejbRemove()
     */
    public void ejbRemove() {
        
    }
    // </editor-fold>
    
    /**
     * See section 7.10.3 of the EJB 2.0 specification
     * See section 7.11.3 of the EJB 2.1 specification
     */
    public void ejbCreate() {
        // TODO implement ejbCreate if necessary, acquire resources
        // This method has access to the JNDI context so resource aquisition
        // spanning all methods can be performed here such as home interfaces
        // and data sources.
        league=lookupLeague();
        round=lookupRound();
        groups=lookupGroups();
        team=lookupTeam();
        player=lookupPlayer();
        place=lookupPlaceInGroup();
        match=lookupMatch();
        result=lookupResult();
    }
    
    private league.ejb.entity.LeagueLocalHome lookupLeague() {
        try {
            return (league.ejb.entity.LeagueLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/League");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    private league.ejb.entity.RoundLocalHome lookupRound() {
        try {
            return (league.ejb.entity.RoundLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/Round");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    private league.ejb.entity.GroupsLocalHome lookupGroups() {
        try {
            return (league.ejb.entity.GroupsLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/Groups");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    private league.ejb.entity.TeamLocalHome lookupTeam() {
        try {
            return (league.ejb.entity.TeamLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/Team");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    private league.ejb.entity.PlayerLocalHome lookupPlayer() {
        try {
            return (league.ejb.entity.PlayerLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/Player");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    private league.ejb.entity.PlaceInGroupLocalHome lookupPlaceInGroup() {
        try {
            return (league.ejb.entity.PlaceInGroupLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/PlaceInGroup");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    private league.ejb.entity.MatchLocalHome lookupMatch() {
        try {
            return (league.ejb.entity.MatchLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/Match");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    private league.ejb.entity.ResultLocalHome lookupResult() {
        try {
            return (league.ejb.entity.ResultLocalHome) CachingServiceLocator.getInstance().getLocalHome("java:comp/env/ejb/Result");
        } catch(javax.naming.NamingException ne) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ne);
            throw new RuntimeException(ne);
        }
    }
    
    public league.util.League createLeague(java.lang.String name, java.util.Date startDate, java.util.Date endDate, java.lang.String note) {
        try {
            league.ejb.entity.LeagueLocal ll=league.create(name, startDate, endDate, note);
            return new league.util.League(new Integer(ll.getId().intValue()), name, startDate, endDate, note);
        } catch (javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        }
    }
    
    public java.util.Collection findAllLeagues() {
        try {
            ArrayList al=new ArrayList();
            Iterator it=league.findAll().iterator();
            while (it.hasNext()) {
                league.ejb.entity.LeagueLocal ll=(league.ejb.entity.LeagueLocal) it.next();
                al.add(new league.util.League(new Integer(ll.getId().intValue()), ll.getName(), ll.getStartDate(), ll.getEndDate(), ll.getNote()));
            }
            return al;
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    private league.ejb.entity.RoundLocal createEmptyRound(java.lang.String name, java.util.Date startDate, league.ejb.entity.LeagueLocal ll) {
        try {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"createEmptyRound() new round name : "+name);
            return round.create(name, new java.sql.Timestamp(startDate.getTime()), ll);
        } catch(javax.ejb.CreateException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public void createRound(java.lang.Integer leagueId, java.lang.String name, java.util.Date startDate) {
        league.ejb.entity.LeagueLocal ll=null;
        league.ejb.entity.RoundLocal rl=null;
        if (leagueId==null) throw new RuntimeException("unknown league when creating round");
        try {
            ll=league.findByPrimaryKey(new java.math.BigDecimal(leagueId.intValue()));
            
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
        //  try {
        //  rl=getActiveRound(ll);
            /*
            Collection groupsCol=groups.findByRound(rl); //rl.getGroups();
            Vector groups=new Vector(groupsCol.size());
            Iterator it=rl.getGroups().iterator();
            Hashtable ht=new Hashtable();
            while (it.hasNext()) {
                league.ejb.entity.GroupsLocal gl=(league.ejb.entity.GroupsLocal) it.next();
                ht.put(new Integer(gl.getPlace().intValue()), gl);
             
            }
            for (int i=1; i<=ht.size(); i++) {
                GroupsLocal gl=(GroupsLocal)ht.get(new Integer(i));
             
             
             
                Collection placesCol=place.findByGroupId(gl.getId()); //gl.getPlaceInGroup();
                Vector teams=new Vector(placesCol.size());
                Iterator it1=placesCol.iterator();
                Hashtable teamsInGroup=new Hashtable();
                while (it1.hasNext()) {
                    league.ejb.entity.PlaceInGroupLocal pl=(league.ejb.entity.PlaceInGroupLocal) it1.next();
                    teamsInGroup.put(pl.getTeam().getTeam(pl.getTeam()));
                }
             
             
            }
             */
        
        
        //Date d=round.getLastStartDate();
        //if (d!=null) rl=round.findByStartDate(new java.sql.Timestamp(d.getTime()));
        //  } catch (javax.ejb.FinderException fe) {
        
        //}
        if (rl==null) rl=createEmptyRound(name, startDate, ll);
        java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"new round name: "+rl.getName());
    }
    
    public java.util.Collection getPlayersInRound(league.ejb.entity.RoundLocal rl) {
        //TODO implement getPlayersInRound
        ArrayList al=new ArrayList();
        Iterator it=rl.getGroups().iterator();
        while (it.hasNext()) {
            league.ejb.entity.GroupsLocal gl=(league.ejb.entity.GroupsLocal) it.next();
            PlaceInGroupLocal pll=(PlaceInGroupLocal) gl.getPlaceInGroup();
            al.add(pll.getTeam().getName());
        }
        
        return null;
    }
    
    public void setTeamStartPoints(Integer teamId, Integer groupId, Integer startPoints) {
        try {
            PlaceInGroupPK pk=new PlaceInGroupPK();
            pk.groupId=new BigDecimal(groupId.intValue());
            pk.teamId=new BigDecimal(teamId.intValue());
            PlaceInGroupLocal pl=place.findByPrimaryKey(pk);
            pl.setStartPoints(startPoints);
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public java.lang.Integer createPlayer(java.lang.String name, java.lang.String note, java.lang.String userId) {
        try {
            league.ejb.entity.PlayerLocal pl=player.create(name, note, userId);
            return new Integer(pl.getId().intValue());
        } catch (javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        }
    }
    
    public league.util.Player getPlayer(league.ejb.entity.PlayerLocal pl) {
        league.util.Player player=new league.util.Player(new Integer(pl.getId().intValue()), pl.getName(), pl.getUserid(), pl.getNote());
        return player;
    }
    
    private PlaceInGroupLocal getActualPlace(TeamLocal tl, RoundLocal rl) {
        //RoundLocal rl=getActiveRound(ll);
        Iterator it=tl.getPlaceInGroup().iterator();
        
        while (it.hasNext()) {
            PlaceInGroupLocal plg = (PlaceInGroupLocal) it.next();
            if (rl.equals(plg.getGroups().getRoundId())) return plg;
        }
        return null;
    }
    
    public league.util.Team getTeam(league.ejb.entity.TeamLocal tl, RoundLocal rl) {
        Iterator it=tl.getPlayerId().iterator();
        ArrayList al=new ArrayList();
        //RoundLocal activeRl=getActiveRound(ll);
        while (it.hasNext()) {
            league.ejb.entity.PlayerLocal pl=(league.ejb.entity.PlayerLocal) it.next();
            al.add(getPlayer(pl));
        }
        
        PlaceInGroupLocal plg=getActualPlace(tl, rl);
        
        Iterator resIter =tl.getResult().iterator();
        int points=0;
        if (plg!=null) {
            Integer i=plg.getStartPoints();
            if (i!=null) points=i.intValue();
        }
        Integer startPoints=new Integer(points);
        System.out.println("startPoints "+startPoints.toString());
        while (resIter.hasNext()) {
            ResultLocal resl=(ResultLocal) resIter.next();
            if (rl.equals(resl.getMatch().getRound())) points += resl.getPoints().intValue();
        }
        league.util.Team team=new league.util.Team(new Integer(tl.getId().intValue()), tl.getName(), al, new Integer(points), startPoints);
        System.out.println("startPoints "+team.getStartPoints().toString());
        return team;
    }
    
    public league.util.Group getGroup(league.ejb.entity.GroupsLocal gl) {
        try {
            Collection placesCol=place.findByGroupId(gl.getId()); //gl.getPlaceInGroup();
            Vector teams=new Vector(placesCol.size());
            Iterator it=placesCol.iterator();
            while (it.hasNext()) {
                league.ejb.entity.PlaceInGroupLocal pl=(league.ejb.entity.PlaceInGroupLocal) it.next();
                //int p=pl.getPlace().intValue();
                teams.add(getTeam(pl.getTeam(), gl.getRoundId()));
            }
            return new league.util.Group(new Integer(gl.getId().intValue()), gl.getName(), teams);
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public league.util.Round getRound(Integer id) {
        
        return getRound(findRound(id));
        
    }
    
    private league.ejb.entity.TeamLocal findTeam(Integer id) {
        try {
            return team.findByPrimaryKey(new java.math.BigDecimal(id.intValue()));
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    private league.ejb.entity.RoundLocal findRound(Integer id) {
        try {
            return round.findByPrimaryKey(new java.math.BigDecimal(id.intValue()));
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    private league.ejb.entity.MatchLocal findMatch(Integer id) {
        try {
            return match.findByPrimaryKey(new java.math.BigDecimal(id.intValue()));
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    private league.ejb.entity.ResultLocal findResult(ResultPK pk) {
        try {
            return result.findByPrimaryKey(pk);
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    private league.ejb.entity.LeagueLocal findLeague(Integer id) {
        try {
            return league.findByPrimaryKey(new java.math.BigDecimal(id.intValue()));
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    private league.ejb.entity.GroupsLocal findGroups(Integer id) {
        try {
            return groups.findByPrimaryKey(new java.math.BigDecimal(id.intValue()));
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public league.util.Round getRound(league.ejb.entity.RoundLocal rl) {
        try {
            Collection groupsCol=groups.findByRound(rl); //rl.getGroups();
            Vector groups=new Vector(groupsCol.size());
            Iterator it=rl.getGroups().iterator();
            Hashtable ht=new Hashtable();
            while (it.hasNext()) {
                league.ejb.entity.GroupsLocal gl=(league.ejb.entity.GroupsLocal) it.next();
                ht.put(new Integer(gl.getPlace().intValue()), getGroup(gl));
                
            }
            for (int i=1; i<=ht.size(); i++) {
                groups.add(ht.get(new Integer(i)));
            }
            return new league.util.Round(new Integer(rl.getId().intValue()), rl.getName(), rl.getStartDate(), groups);
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public Collection getMatches(Integer roundId) {
        RoundLocal rl=findRound(roundId);
        ArrayList al=new ArrayList();
        Iterator it=rl.getMatches().iterator();
        while (it.hasNext()) {
            MatchLocal ml=(MatchLocal) it.next();
            Match m=new Match(new Integer(ml.getId().intValue()), new Date(ml.getDatePlayed().getTime()));
            Iterator resIter=ml.getResult().iterator();
            while (resIter.hasNext()) {
                ResultLocal resl=(ResultLocal) resIter.next();
                m.addResult(new Result(m.getId(), new Integer(resl.getTeam().getId().intValue()), new Integer(resl.getScore().intValue()), new Integer(resl.getPoints().intValue())));
            }
            al.add(m);
        }
        return al;
    }
    
    public Match getMatchById(Integer matchId) {
        MatchLocal ml=findMatch(matchId);
        Match m=new Match(new Integer(ml.getId().intValue()), new Date(ml.getDatePlayed().getTime()));
        Iterator resIter=ml.getResult().iterator();
        while (resIter.hasNext()) {
            ResultLocal resl=(ResultLocal) resIter.next();
            m.addResult(new Result(m.getId(), new Integer(resl.getTeam().getId().intValue()), new Integer(resl.getScore().intValue()), new Integer(resl.getPoints().intValue())));
        }
        
        return m;
    }
    
    public java.lang.Integer createTeam(java.lang.String name, Integer leagueId) {
        try {
            LeagueLocal ll=league.findByPrimaryKey(new java.math.BigDecimal(leagueId.intValue()));
            league.ejb.entity.TeamLocal tl=team.create(name, ll);
            return new Integer(tl.getId().intValue());
        } catch (javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public void addPlayerToTeam(java.lang.Integer playerId, java.lang.Integer teamId) {
        try {
            league.ejb.entity.TeamLocal tl=team.findByPrimaryKey(new java.math.BigDecimal(teamId.intValue()));
            league.ejb.entity.PlayerLocal pl=player.findByPrimaryKey(new java.math.BigDecimal(playerId.intValue()));
            ArrayList al=new ArrayList(tl.getPlayerId());
            al.add(pl);
            tl.setPlayerId(al);
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public Collection getTeamsInLeague(Integer id) {
        try {
            return getTeamsInLeague(league.findByPrimaryKey(new java.math.BigDecimal(id.intValue())));
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public Collection getTeamsInLeague(league.ejb.entity.LeagueLocal ll) {
        Iterator it=ll.getTeams().iterator();
        ArrayList al=new ArrayList();
        while (it.hasNext()) {
            TeamLocal tl=(TeamLocal) it.next();
            al.add(getTeam(tl, getActiveRound(ll)));
        }
        return al;
    }
    
    private league.ejb.entity.GroupsLocal createGroup(String name, Integer place, league.ejb.entity.RoundLocal rl) {
        try {
            return groups.create(name, new BigDecimal(place.intValue()), rl);
        } catch (javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        }
    }
    
    public java.util.Collection getRounds(Integer leagueId) {
        try {
            LeagueLocal ll=findLeague(leagueId);
            Iterator it=round.findByLeague(ll).iterator();
            ArrayList al=new ArrayList();
            while (it.hasNext()) {
                league.ejb.entity.RoundLocal rl=(league.ejb.entity.RoundLocal) it.next();
                al.add(getRound(rl));
            }
            return al;
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
        
    }
    
    /*
     *
     * vrati Collection vsech lig
     *
     */
    public java.util.Collection getLeagues() {
        try {
            Iterator it=league.findAll().iterator();
            ArrayList al=new ArrayList();
            while (it.hasNext()) {
                league.ejb.entity.LeagueLocal ll=(league.ejb.entity.LeagueLocal) it.next();
                al.add(new league.util.League(new Integer(ll.getId().intValue()), ll.getName(), ll.getStartDate(), ll.getEndDate(), ll.getNote()));
            }
            return al;
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
        
    }
    
    
    public League getLeagueById(Integer leagueId) {
        LeagueLocal ll=findLeague(leagueId);
        return new league.util.League(new Integer(ll.getId().intValue()), ll.getName(), ll.getStartDate(), ll.getEndDate(), ll.getNote());
    }
    
    
   /* public java.util.Collection getRounds(league.ejb.entity.LeagueLocal ll) {
        try {
            Iterator it=round.findByLeague(ll).iterator();
            ArrayList al=new ArrayList();
            while (it.hasNext()) {
                league.ejb.entity.RoundLocal rl=(league.ejb.entity.RoundLocal) it.next();
                al.add(new league.util.Round(new Integer(rl.getId().intValue()), rl.getName(), rl.getStartDate(), null));
            }
            return al;
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    
    }
    */
    public Round getActiveRound(Integer leagueId) {
        try {
            LeagueLocal ll=league.findByPrimaryKey(new java.math.BigDecimal(leagueId.intValue()));
            league.ejb.entity.RoundLocal rl=getActiveRound(ll);
            if (rl==null) return null;
            return getRound(rl);
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    public Integer createMatch(Integer roundId, Hashtable results) {
        if (results.size()!=2) return null;
        try {
            
            Enumeration e=results.keys();
            RoundLocal rl=findRound(roundId);
            MatchLocal ml=match.create(new java.sql.Timestamp(Calendar.getInstance().getTimeInMillis()));
            ml.setRound(rl);
            
            int a=0;
            int b=0;
            if (results.containsValue(new Integer(3))) {
                if (results.containsValue(new Integer(0))) {a=7;b=1;}
                if (results.containsValue(new Integer(1))) {a=6;b=2;}
                if (results.containsValue(new Integer(2))) {a=5;b=3;}
            } else
                if (results.containsValue(new Integer(-1))) {
                a=0;b=4;
                }
            while (e.hasMoreElements()) {
                Integer teamId=(Integer) e.nextElement();
                Integer score=(Integer) results.get(teamId);
                int p=0;
                if (score.intValue()==-1) p=-1;
                else if (score.intValue()==3) p=a;
                else p=b;
                result.create(new BigDecimal(score.intValue()), new BigDecimal(p), teamId, new Integer(ml.getId().intValue()));
            }
            return new Integer(ml.getId().intValue());
        } catch (javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        }
        
    }
    
    public void updateMatch(Match m) {
        MatchLocal ml=findMatch(m.getId());
        Iterator it=m.getResults().iterator();
        while (it.hasNext()) {
            Result r=(Result) it.next();
            ResultPK pk=new ResultPK();
            pk.matchId=ml.getId();
            pk.teamId =new BigDecimal(r.getTeamId().intValue());
            ResultLocal rl=findResult(pk);
            rl.setScore(new BigDecimal(r.getScore().intValue()));
            rl.setPoints(new BigDecimal(r.getPoints().intValue()));
        }
        
    }
 /*
    public Hashtable getResults(Integer roundId) {
        return getResults(findRound(roundId));
    }*/
 /*
    public Hashtable getResults(RoundLocal rl) {
        Iterator it=rl.getGroups().iterator();
        while (it.hasNext()) {
            GroupsLocal gl=(GroupsLocal) it.next();
            Iterator placeIter=place.findByGroupId(gl.getId()).iterator();
            while (placeIter.hasNext()) {
                PlaceInGoupLocal pll=(PlaceInGoupLocal)it.next();
              //  pll.get
  
            }
        }
        result.findByTeamId(teamId);
        return null;
    }
  */
    private league.ejb.entity.RoundLocal getActiveRound(league.ejb.entity.LeagueLocal ll) {
        try {
            Date last=round.getLastStartDate();
            if (last==null) return null;
            return round.findByStartDate(new Timestamp(last.getTime()));
        } catch (javax.ejb.FinderException fe) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,fe);
            throw new RuntimeException(fe);
        }
    }
    
    private void addTeamToGroup(GroupsLocal gl, TeamLocal tl) {
        try {
            
            Collection col=gl.getPlaceInGroup();
            place.create(gl, tl, new Integer(col.size()+1));
            /*if (col.isEmpty()) {
                ArrayList al=new ArrayList();
            }
            ArrayList al=new ArrayList();
            al.add(place.create(gl, tl, new Integer(al.size()+2)));*/
            //gl.setPlaceInGroup(al);
            
        } catch (javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        }
        
    }
    public String testGroups() {
        try {
            LeagueLocal ll=league.findByPrimaryKey(new java.math.BigDecimal(0));
            RoundLocal rl=getActiveRound(ll);
            //Iterator it=ll.getTeams().iterator();
            //while (it.hasNext()) {
            int[] p= {1,0,3,6,2,4,7,9,5,8,11,13,10,15,14,17,12,16,18,21,19,23,20,25,22,26,24};
            for (int i=0;i<=26;i++) {
                
                
                TeamLocal tl=team.findByPrimaryKey(new java.math.BigDecimal(p[i]));
                // addTeamToLastPlace(rl, tl);
            }
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "abcd";
    }
    public void addTeamToLastPlace(Integer roundId, Integer teamId) {
        RoundLocal rl=findRound(roundId);
        TeamLocal tl=findTeam(teamId);
        addTeamToLastPlace(rl, tl);
    }
    private void addTeamToLastPlace(RoundLocal rl, TeamLocal tl) {
        try {
            Collection groupsCol=rl.getGroups();
            int groupsCount=groupsCol.size();
            if (groupsCol.isEmpty()) {
                GroupsLocal gl=groups.create("group 1", new BigDecimal(1), rl);
                addTeamToGroup(gl, tl);
                return;
            }
            //Vector groups=new Vector(groupsCol.size());
            league.ejb.entity.GroupsLocal lastGroupLocal=null;
            int maxGroupId=0;
            Iterator it=groupsCol.iterator();
            int test=0;
            int i=0;
            while (it.hasNext()) {
                test++;
                league.ejb.entity.GroupsLocal gl=(league.ejb.entity.GroupsLocal) it.next();
                i=gl.getPlace().intValue();
                if (i>maxGroupId) { lastGroupLocal=gl;maxGroupId=i; }
                //groups.add(gl.getPlace().intValue()-1, gl);
            }
            //lastGroupLocal=(league.ejb.entity.GroupsLocal) groups.lastElement();
            //System.out.println("max group place "+String.valueOf(maxGroupId)+"/last group place "+String.valueOf(lastGroupLocal.getPlace().intValue())+" /group size "+String.valueOf(lastGroupLocal.getPlaceInGroup().size())+" test "+String.valueOf(test));
            if (lastGroupLocal.getPlaceInGroup().size()<4) addTeamToGroup(lastGroupLocal, tl);
            else {
                groupsCount++;
                lastGroupLocal=this.groups.create("group "+String.valueOf(groupsCount), new BigDecimal(groupsCount), rl);
                addTeamToGroup(lastGroupLocal, tl);
            }
        } catch (javax.ejb.CreateException ce) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,"exception caught" ,ce);
            throw new RuntimeException(ce);
        }
        
    }
}
