/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * TestingServlet.java
 *
 * Created on June 3, 2005, 5:57 PM
 */

package org.netbeans.test.examples.logging;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *
 * @author jungi
 * @version
 */
public class TestingServlet extends HttpServlet {
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Servlet TestingServlet</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h1>Servlet TestingServlet at " + request.getContextPath() + "</h1>");
        boolean b = false;
        Exception e = null;
        try {
            getBGTransPort().BGTranslate("Hello");
            b = true;
        } catch(java.rmi.RemoteException ex) {
            // TODO handle remote exception
            e = ex;
        }
        if (b) {
            out.println("<strong>Call was successful.</strong>");
        } else {
            out.println("<strong>Call was not successful!!!</strong>");
            out.println("<br/><br/>");
            e.printStackTrace(out);
        }
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
    
    private org.netbeans.test.examples.logging.BGTrans getBGTrans() {
        org.netbeans.test.examples.logging.BGTrans bGTrans = null;
        try {
            javax.naming.InitialContext ic = new javax.naming.InitialContext();
            bGTrans = (org.netbeans.test.examples.logging.BGTrans) ic.lookup("java:comp/env/service/BGTrans");
        } catch(javax.naming.NamingException ex) {
            // TODO handle JNDI naming exception
        }
        return bGTrans;
    }
    
    private org.netbeans.test.examples.logging.BGTransPortType getBGTransPort() {
        org.netbeans.test.examples.logging.BGTransPortType bGTransPort = null;
        try {
            bGTransPort = getBGTrans().getBGTransPort();
        } catch(javax.xml.rpc.ServiceException ex) {
            // TODO handle service exception
        }
        return bGTransPort;
    }
}
