/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.test.j2ee;

import java.io.File;
import junit.textui.TestRunner;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.nodes.JavaNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.lib.Utils;
import org.netbeans.test.j2ee.lib.ProgressSupport;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.netbeans.test.j2ee.debug.TestDebugRemote;
import org.netbeans.test.j2ee.debug.TestDebugRemoteHome;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.actions.CloseAllDocumentsAction;
import org.netbeans.jemmy.operators.*;
import java.util.*;
import org.netbeans.jemmy.operators.JMenuBarOperator;

/**
 *
 * @author jhorvath
 */
public class AppserverValidation extends JellyTestCase {
    
    public static final String EAR_PROJECT_NAME = "TestDebugEAR";
    public static final String EJB_PROJECT_NAME = EAR_PROJECT_NAME + "-EJBModule";
    
    public static final String EAR_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EAR_PROJECT_NAME;
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EAR_PROJECT_NAME + File.separator + EAR_PROJECT_NAME+ "-ejb";
    
    
    
    int modifiers;
    
    public static String openSourceAction = Bundle.getStringTrimmed("org.openide.actions.Bundle", "Open");
    
    /** Need to be defined because of JUnit */
    public AppserverValidation(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new AppserverValidation("addAppserver"));
        suite.addTest(new AppserverValidation("startAppserver"));
        suite.addTest(new AppserverValidation("deployEJBModule"));
        suite.addTest(new AppserverValidation("addBreakpoint"));
        suite.addTest(new AppserverValidation("debugEJBModule"));
        suite.addTest(new AppserverValidation("startAppClient"));
        suite.addTest(new AppserverValidation("undeployEJBModule"));
        suite.addTest(new AppserverValidation("deployEAR"));
        suite.addTest(new AppserverValidation("undeployEAR"));
        suite.addTest(new AppserverValidation("stopAppserver"));
        return suite;
    }
    
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        if (System.getProperty("os.name").startsWith("Mac OS X")) {
            modifiers = KeyEvent.META_DOWN_MASK;
        } else {
            modifiers = KeyEvent.CTRL_DOWN_MASK;
        }
    }
    
    public void tearDown() {
    }
    
    public void addAppserver() {
        Utils.addAppServer();
    }
    
    public void startAppserver() {
        Utils.startStopServer(true);
    }
    
    public void stopAppserver() {
        Utils.startStopServer(false);
    }

    
    public void addBreakpoint() {
        ProjectsTabOperator projectTab=ProjectsTabOperator.invoke();
        ProjectRootNode prn = projectTab.getProjectRootNode(EJB_PROJECT_NAME);
        new org.netbeans.jemmy.EventTool().waitNoEvent(1000);
        JavaNode javaNode = new JavaNode(prn, "Source Packages|test|TestDebugBean.java");
        javaNode.select();
        javaNode.performPopupAction(openSourceAction);
        EditorOperator editorOperator = new EditorOperator("TestDebugBean.java");
        editorOperator.setCaretPosition(63, 1);
        editorOperator.pushKey(KeyEvent.VK_F8, modifiers);
    }
    
    public void startAppClient() {
        MainWindowOperator.StatusTextTracer stt = MainWindowOperator.getDefault().getStatusTextTracer();        
        stt.start();        
        new Thread(new Runnable() {
            public void run() {
                Properties env = new Properties();
                env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.enterprise.naming.SerialInitContextFactory");
                env.put(Context.PROVIDER_URL, "iiop://localhost:3700");
                try {
                    Context initial = new InitialContext(env);
                    Object objref = initial.lookup("ejb/TestDebugBean");                    
                    TestDebugRemoteHome testDebugRH = (TestDebugRemoteHome)PortableRemoteObject.narrow(objref, TestDebugRemoteHome.class);
                    TestDebugRemote testDebugRemote=testDebugRH.create();                    
                    testDebugRemote.testMethod();
                } catch (javax.naming.NamingException ne) {
                    fail("unable to find ejb/TestDebugBean");
                } catch (javax.ejb.CreateException ce) {
                    fail();
                } catch (java.rmi.RemoteException re) {
                    fail();
                }
            };
        }, "appserver client thread").start();
        MainWindowOperator.getDefault().waitStatusText("Thread p: thread-pool-1; w: 2 stopped at TestDebugBean.java:63.");
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_F5, KeyEvent.SHIFT_MASK);
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);        
    }
    
    public void debugEJBModule() {
        ProjectsTabOperator projectTab=ProjectsTabOperator.invoke();
        ProjectRootNode prn = projectTab.getProjectRootNode(EJB_PROJECT_NAME);
        new org.netbeans.jemmy.EventTool().waitNoEvent(1000);
        prn.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjarproject.ui.Bundle", "LBL_DebugAction_Name"));
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", new String[] {"build.xml (debug)"}));
    }
    
    public void deployEJBModule() {
        System.err.println(EJB_PROJECT_PATH);
        J2eeProjectSupport.openProject(EJB_PROJECT_PATH);
        new org.netbeans.jemmy.EventTool().waitNoEvent(1000);
        ProjectsTabOperator projectTab=ProjectsTabOperator.invoke();
        ProjectRootNode prn = projectTab.getProjectRootNode(EJB_PROJECT_NAME);
        new org.netbeans.jemmy.EventTool().waitNoEvent(1000);
        prn.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjarproject.ui.Bundle", "LBL_RedeployAction_Name"));
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", new String[] {"build.xml (run)"}));
    }
    
    public void deployEAR() {
        J2eeProjectSupport.openProject(EAR_PROJECT_PATH);
        new org.netbeans.jemmy.EventTool().waitNoEvent(1000);
        ProjectsTabOperator projectTab=ProjectsTabOperator.invoke();
        ProjectRootNode prn = projectTab.getProjectRootNode(EAR_PROJECT_NAME);
        new org.netbeans.jemmy.EventTool().waitNoEvent(1000);
        prn.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.earproject.ui.Bundle", "LBL_DeployAction_Name"));
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", new String[] {"build.xml (run-deploy)"}));
    }
    
    
    public void undeployEJBModule() {
        RuntimeTabOperator runtimeTab = RuntimeTabOperator.invoke();
        Node serverNode = new Node(runtimeTab.getRootNode(), Bundle.getStringTrimmed("org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", "SERVER_REGISTRY_NODE")
        +"|Application Server");        
        Node applicationsNode = new Node(serverNode, Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_Applications"));
        Node ejbModulesNode = new Node(applicationsNode, Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_EjbModules"));
        ejbModulesNode.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.actions.Bundle", "LBL_RefreshAction"));
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        Node ejbModuleNode = new Node(ejbModulesNode, EJB_PROJECT_NAME);
        ejbModuleNode.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_Undeploy"));
        new org.netbeans.jemmy.EventTool().waitNoEvent(10000);
        if (ejbModulesNode.isChildPresent(EJB_PROJECT_NAME)) fail("Project is not undeployed");        
    }
    
    public void undeployEAR() {
        RuntimeTabOperator runtimeTab = RuntimeTabOperator.invoke();
        Node serverNode = new Node(runtimeTab.getRootNode(), Bundle.getStringTrimmed("org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", "SERVER_REGISTRY_NODE")
        +"|Application Server");        
        Node applicationsNode = new Node(serverNode, Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_Applications"));
        Node earNode = new Node(applicationsNode, Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_AppModules"));
        earNode.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.actions.Bundle", "LBL_RefreshAction"));
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        Node projectNode = new Node(earNode, EAR_PROJECT_NAME);
        projectNode.performPopupAction(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_Undeploy"));
        new org.netbeans.jemmy.EventTool().waitNoEvent(10000);
        if (earNode.isChildPresent(EAR_PROJECT_NAME)) fail("Project is not undeployed");        
    }    
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        TestRunner.run(suite());
    }
    
}
