/*
The contents of this file are subject to the terms of the Common Development
and Distribution License (the License). You may not use this file except in
compliance with the License.

You can obtain a copy of the License at http://www.netbeans.org/cddl.html
or http://www.netbeans.org/cddl.txt.

When distributing Covered Code, include this CDDL Header Notice in each file
and include the License file at http://www.netbeans.org/cddl.txt.
If applicable, add the following below the CDDL Header, with the fields
enclosed by brackets [] replaced by your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

The Original Software is NetBeans. The Initial Developer of the Original
Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.*;
import org.netbeans.test.j2ee.*;
import org.netbeans.test.j2ee.lib.Utils;

/**
 *
 * @author lm97939
 */
public class CreateCMPBeansFromDB extends JellyTestCase {
    
    
    /** Creates a new instance of AddMethodTest */
    public CreateCMPBeansFromDB(String name) {
        super(name);
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }
    
    public void testCreateCMPBeansFromDB() throws IOException {
        final String FILE_TYPE = "CMP Entity Beans from Database";
        
        NewFileWizardOperator op = NewFileWizardOperator.invoke();
        op.selectProject(EJBValidation.EAR_PROJECT_NAME+"-ejb");
        op.selectCategory("Enterprise");
        op.selectFileType(FILE_TYPE);
        op.next();
        WizardOperator wizard = new WizardOperator(FILE_TYPE);
        new JComboBoxOperator(wizard).selectItem("/sample");
        //new JComboBoxOperator(wizard,3).getTextField().clearText();
        new JComboBoxOperator(wizard,3).getTextField().enterText("cmpdb");
        wizard.next();
        //NbDialogOperator dialog = new NbDialogOperator("Connect");
        //new JTextFieldOperator(dialog,0).typeText("pbpublic");
        //dialog.ok();
        wizard = new WizardOperator(FILE_TYPE);
        new JButtonOperator(wizard, "Add All").push();
        //new JListOperator(wizard,2).selectItem("SALES_REP_DATA_TBL");
        //new JButtonOperator(wizard, "Remove").push();
        wizard.finish();

        //JDialogOperator status = new JDialogOperator("Progress");
        //status.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 300000);
        //status.waitClosed();

        String beanNames[] = { 
            "Customer", "DiscountCode", "Manufacture", "MicroMarkets",
            "Order", "ProductCode", "Product"              
            // "Office", "OfficeTypeCode", "SalesRep", "SalesTaxCode", "SalesRepData"
        };
        Node beansNode = new Node(new ProjectsTabOperator().getProjectRootNode(EJBValidation.EJB_PROJECT_NAME),
                             Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node"));
        beansNode.tree().getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 300000);
        for (int i=0; i<beanNames.length; i++) {
            new Node(beansNode,beanNames[i]);
        }
        new org.netbeans.jemmy.EventTool().waitNoEvent(10000);

        Utils utils = new Utils(this);
        String ddNames[] = { "ejb-jar.xml", "sun-ejb-jar.xml", "sun-cmp-mappings.xml" /*, "PBPUBLIC_TestingEntApp-EJBModule.dbschema" */};
        utils.assertFiles(new File(EJBValidation.EJB_PROJECT_PATH + File.separator + "src" + File.separator + "conf"), ddNames, getName()+"_");
	for (int i=0; i<beanNames.length; i++) {
            Node openFile = new Node(new ProjectsTabOperator().getProjectRootNode(EJBValidation.EJB_PROJECT_NAME),
                                 Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                                 +"|"+beanNames[i]);
            new OpenAction().performAPI(openFile);
            EditorOperator editor = new EditorWindowOperator().getEditor(beanNames[i]);
            editor.deleteLine(7);
            editor.deleteLine(7);
            editor.save();
            editor.close();
        }
        File dbBeansDir = new File(EJBValidation.EJB_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "cmpdb");
        String beanFiles[] = dbBeansDir.list(new FilenameFilter () {
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        if (beanFiles.length != 28)
            fail("28 generated db bean files are expected in "+dbBeansDir+" but "+String.valueOf(beanFiles.length)+" was found");
        utils.assertFiles(dbBeansDir, beanFiles, getName()+"_");
    }

}
