/*
The contents of this file are subject to the terms of the Common Development
and Distribution License (the License). You may not use this file except in
compliance with the License.

You can obtain a copy of the License at http://www.netbeans.org/cddl.html
or http://www.netbeans.org/cddl.txt.

When distributing Covered Code, include this CDDL Header Notice in each file
and include the License file at http://www.netbeans.org/cddl.txt.
If applicable, add the following below the CDDL Header, with the fields
enclosed by brackets [] replaced by your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

The Original Software is NetBeans. The Initial Developer of the Original
Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import junit.textui.TestRunner;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.*;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;
import org.netbeans.test.j2ee.*;
import org.netbeans.test.j2ee.lib.Utils;

/**
 *
 * @author lm97939
 */
public class FreeFormProjects extends JellyTestCase {
    
    public static final String CMP2_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + "freeform_projects" + File.separator + "cmp2";
    public static final String TRAVEL_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + "freeform_projects" + File.separator + "travel";
    public static final String SECURE_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + "freeform_projects" + File.separator + "Secure";

    /** Creates a new instance of AddMethodTest */
    public FreeFormProjects(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new FreeFormProjects("testFreeFormEjb"));
        suite.addTest(new FreeFormProjects("testEjbWithSources"));
        suite.addTest(new FreeFormProjects("testEarWithSources"));
        return suite;    
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        TestRunner.run(suite());
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }
    
    public void testFreeFormEjb() {
        createNewFreeFormEjbProject(CMP2_PROJECT_PATH, null, 
                new String[] {"Gangster Entity Bean", "Job Entity Bean", "Organization Entity Bean"},
                new String[] {"GangsterBean", "JobBean", "OrganizationBean"});
    }
    
    public void testEjbWithSources() {
        createNewEjbProjectFromExistingSources(TRAVEL_PROJECT_PATH, "Travel", TRAVEL_PROJECT_PATH+"-projects",
                new String[] {"TravelAgentEJB", "CabinEJB"},
                new String[] {"TravelAgentBean", "CabinBean"});
    }
    
    public void testEarWithSources() {
        createNewEarProjectFromExistingSources(SECURE_PROJECT_PATH, "Secure", SECURE_PROJECT_PATH+"-projects");
    }
    
    private void createNewFreeFormEjbProject(String location, String name, String beans[], String files[]) {
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory("Enterprise");
        npwo.selectProject("EJB Module with Existing Ant Script");
        npwo.next();
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        new JTextFieldOperator(npnlso,3).setText(location); // NOI18N
        if (name != null)
            new JTextFieldOperator(npnlso,1).setText(name);
        else
            name = new JTextFieldOperator(npnlso,1).getText();
        npnlso.next();
        new NewProjectWizardOperator().next();
        new NewProjectWizardOperator().next();
        new NewProjectWizardOperator().next();
        new NewProjectWizardOperator().finish();
        //wait project appear in projects view
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(name);
        // wait classpath scanning finished
        ProjectSupport.waitScanFinished();
        
        Node beansNode =  new Node(rootNode, Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node"));
        if (beans != null) {
            for (int i=0; i<beans.length; i++) {
                Node node = new Node(beansNode, beans[i]);
                node.expand();
                String children[] = node.getChildren();
                if (children == null || children.length <= 0) {
                    fail ("Bean node "+beans[i]+" has no children");
                }
                if (beans != null) {
                    new OpenAction().perform(node);
                    new EditorOperator(files[i]).close();
                }
            }
        }
        new Node(new ProjectsTabOperator().getProjectRootNode(name),
                      "Configuration Files|ejb-jar.xml");        
        // Build project
        rootNode.performPopupAction(Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Actions/Build"));
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", new String[] {name+" (build)"}));

    }
    
    private void createNewEjbProjectFromExistingSources(String location, String name, String folder, String beans[], String files[]) {
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory("Enterprise");
        npwo.selectProject("EJB Module with Existing Sources");
        npwo.next();
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        new JTextFieldOperator(npnlso,0).setText(location); // NOI18N
        new JTextFieldOperator(npnlso,1).setText(name); // NOI18N
        new JTextFieldOperator(npnlso,2).setText(folder); // NOI18N
        new NewProjectWizardOperator().next();
        new NewProjectWizardOperator().finish();
        //wait project appear in projects view
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(name);
        // wait classpath scanning finished
        ProjectSupport.waitScanFinished();
        Node beansNode =  new Node(rootNode, Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node"));
        if (beans != null) {
            for (int i=0; i<beans.length; i++) {
                Node node = new Node(beansNode, beans[i]);
                node.expand();
                String children[] = node.getChildren();
                if (children == null || children.length <= 0) {
                    fail ("Bean node "+beans[i]+" has no children");
                }
                if (beans != null) {
                    new OpenAction().perform(node);
                    new EditorOperator(files[i]).close();
                }
            }
        }
        new Node(new ProjectsTabOperator().getProjectRootNode(name), "Configuration Files|ejb-jar.xml");        
        // Build project
        rootNode.performPopupAction(Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Actions/Build"));
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        MainWindowOperator.getDefault().waitStatusText(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", new String[] {name+" (dist)"}));
    }
    
    private void createNewEarProjectFromExistingSources(String location, String name, String folder) {
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory("Enterprise");
        npwo.selectProject("Enterprise Application with Existing Sources");
        npwo.next();
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        new JTextFieldOperator(npnlso,1).setText(location); // NOI18N
        new JTextFieldOperator(npnlso,0).setText(name); // NOI18N
        new JTextFieldOperator(npnlso,2).setText(folder); // NOI18N
        new NewProjectWizardOperator().finish();
        new NbDialogOperator("Warning").ok();
        //wait project appear in projects view
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(name);
        // wait classpath scanning finished
        ProjectSupport.waitScanFinished();
       
        // Build project
        //rootNode.performPopupAction(Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Actions/Build"));
        //MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 300000);
        //MainWindowOperator.getDefault().waitStatusText(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", new String[] {name+" (build)"}));
    }
    
}
