/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectType;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileUtil;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.lib.Reporter;
import org.netbeans.test.j2ee.lib.RequiredFiles;


/**
 * Test creation of new projects via API
 * These tests are part of J2EE Functional test suite.
 *
 * @author jungi
 * @see <a href="http://qa.netbeans.org/modules/j2ee/promo-f/testspec/j2ee-wizards-testspec.html">J2EE Wizards Test Specification</a>
 */
public class J2eeProjectsTest extends JellyTestCase {
    
    private Reporter reporter;
    
    /**
     * Creates a new instance of J2eeProjectsTest
     */
    public J2eeProjectsTest(String name) {
        super(name);
    }
    
    
    public void setUp() throws Exception {
        super.setUp();
        reporter = Reporter.getReporter((NbTestCase)this);
    }
    
    public void tearDown() throws Exception {
        super.tearDown();
        reporter.close();
    }

    /**
     * Creates EJB Module project and checks if all files are created
     * succesfully (including server specific deployment descriptor)
     */
    public void testCreateEjbProject() {
        File wd = null;
        try {
            wd = getWorkDir();
        } catch (IOException ioe) {
            ioe.printStackTrace(reporter.getLogStream());
        }
        assertNotNull(wd);
        RequiredFiles rf = null;
        try {
            rf = new RequiredFiles(new File(getDataDir(), "structures/ejbProject.str"));
        } catch (IOException ioe) {
            ioe.printStackTrace(reporter.getLogStream());
        }
        assertNotNull(rf);
        Project p = (Project) J2eeProjectSupport.createProject(wd, "EJBModule", J2eeProjectSupport.EJB_PROJECT, null);
        assertNotNull(p);
        checkProjectStructure(p, rf);
    }
    
    /**
     * Creates Web Application project and checks if all files are created
     * succesfully (including server specific deployment descriptor)
     */
    public void testCreateWebProject() {
        File wd = null;
        try {
            wd = getWorkDir();
        } catch (IOException ioe) {
            ioe.printStackTrace(reporter.getLogStream());
        }
        assertNotNull(wd);
        RequiredFiles rf = null;
        try {
            rf = new RequiredFiles(new File(getDataDir(), "structures/webProject.str"));
        } catch (IOException ioe) {
            ioe.printStackTrace(reporter.getLogStream());
        }
        assertNotNull(rf);
        Project p = (Project) J2eeProjectSupport.createProject(wd, "WebModule", J2eeProjectSupport.WEB_PROJECT, null);
        assertNotNull(p);
        checkProjectStructure(p, rf);
    }
    
    /**
     * Creates empty Enterprise Application project and checks if all files
     * are created succesfully (including server specific deployment descriptor)
     */
    public void testCreateEmptyJ2eeProject() {
        File wd = null;
        try {
            wd = getWorkDir();
        } catch (IOException ioe) {
            ioe.printStackTrace(reporter.getLogStream());
        }
        assertNotNull(wd);
        RequiredFiles rf = null;
        try {
            rf = new RequiredFiles(new File(getDataDir(), "structures/emptyJ2eeProject.str"));
        } catch (IOException ioe) {
            ioe.printStackTrace(reporter.getLogStream());
        }
        assertNotNull(rf);
        Project p = (Project) J2eeProjectSupport.createProject(wd, "J2eePrj", J2eeProjectSupport.J2EE_PROJECT, null);
        assertNotNull(p);
        checkProjectStructure(p, rf);
    }

    /**
     * Add war and jar to ear.
     */
    public void testAddModulesToJ2eeProject() {
        EarProject earPrj = null;
        Project warPrj = null;
        Project ejbPrj = null;
        ProjectManager pm = ProjectManager.getDefault();
        try {
            earPrj = (EarProject) pm.findProject(FileUtil.toFileObject(new File(getWorkDir(), "../testCreateEmptyJ2eeProject/J2eePrj").getCanonicalFile()));
            warPrj = pm.findProject(FileUtil.toFileObject(new File(getWorkDir(), "../testCreateWebProject/WebModule").getCanonicalFile()));
            ejbPrj = pm.findProject(FileUtil.toFileObject(new File(getWorkDir(), "../testCreateEjbProject/EJBModule").getCanonicalFile()));
            AntProjectHelper h = earPrj.getUpdateHelper().getAntProjectHelper();
            AuxiliaryConfiguration aux = h.createAuxiliaryConfiguration();
            ReferenceHelper refHelper = new ReferenceHelper(h, aux, h.getStandardPropertyEvaluator());
            EarProjectProperties epp = new EarProjectProperties(earPrj, refHelper, new EarProjectType());
            epp.addJ2eeSubprojects(new Project[] {warPrj, ejbPrj});
        } catch (IOException ioe) {
            ioe.printStackTrace(reporter.getLogStream());
            fail("IOEx while adding modules to EAR project.");
        }
    }
    
    protected void checkProjectStructure(Project p, RequiredFiles r) {
        Set/*<String>*/ l = J2eeProjectSupport.getFileSet(p);
        Set/*<String>*/ rf = r.getRequiredFiles();
        reporter.ref("Project: " + p.toString());
        reporter.ref("Expected: " + rf);
        reporter.ref("Real: " + l);
        assertTrue("Files: " + getDifference(l, rf) + " are missing in project: " + p.toString() , l.containsAll(rf));
        rf = r.getRequiredFiles();
        reporter.ref("Project: " + p.toString());
        reporter.ref("Expected: " + rf);
        reporter.ref("Real: " + l);
        Set s = getDifference(rf, l);
        assertTrue("Files: " + s + " are new in project: " + p.toString() , s.isEmpty());
    }
    
    public static TestSuite suite() {
        TestSuite suite = new NbTestSuite();
        suite.addTest(new J2eeProjectsTest("testCreateEjbProject"));
        suite.addTest(new J2eeProjectsTest("testCreateWebProject"));
        suite.addTest(new J2eeProjectsTest("testCreateEmptyJ2eeProject"));
        suite.addTest(new J2eeProjectsTest("testAddModulesToJ2eeProject"));
        return suite;
    }
    
    private Set getDifference(Set s1, Set s2) {
        Set result = new HashSet();
        s2.removeAll(s1);
        for (Iterator i = s2.iterator(); i.hasNext();) {
            String s = (String) i.next();
            if (s.indexOf(".LCK") < 0) {
                result.add(s);
            } else {
                reporter.log("Additional file: " + s);
            }
        }
        return result;
    }
}
