/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee;

import java.io.*;
import junit.textui.TestRunner;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.NewFileWizardOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.DeleteAction;
import org.netbeans.jellytools.actions.NewFileAction;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;
import org.netbeans.test.j2ee.addmethod.AddOperationTest;
import org.netbeans.test.j2ee.addmethod.CallEJBTest;
import org.netbeans.test.j2ee.lib.ProgressSupport;
import org.netbeans.test.j2ee.lib.Utils;

/**
 * WSValidation suite for J2EE.
 * 
 * 
 * @author libor.martinek@sun.com
 */
public class WSValidation extends JellyTestCase {
    
    public static final String EAR_SAMPLE_PROJECT_NAME = "SampleApp";
    public static final String WEB_SAMPLE_PROJECT_NAME = EAR_SAMPLE_PROJECT_NAME + "-WebModule";
    public static final String EJB_SAMPLE_PROJECT_NAME = EAR_SAMPLE_PROJECT_NAME + "-EJBModule";
    public static final String WSC_SAMPLE_PROJECT_NAME = EAR_SAMPLE_PROJECT_NAME + "-WSClient";
    
    public static final String EAR_SAMPLE_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EAR_SAMPLE_PROJECT_NAME;
    public static final String EJB_SAMPLE_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EAR_SAMPLE_PROJECT_NAME + File.separator + EAR_SAMPLE_PROJECT_NAME + "-ejb";
    public static final String WEB_SAMPLE_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EAR_SAMPLE_PROJECT_NAME + File.separator + EAR_SAMPLE_PROJECT_NAME + "-war";
    public static final String WSC_SAMPLE_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EAR_SAMPLE_PROJECT_NAME + File.separator + WSC_SAMPLE_PROJECT_NAME;
    
    /** Need to be defined because of JUnit */
    public WSValidation(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
     
        suite.addTest(new WSValidation("openProjects"));
        suite.addTest(new EJBValidation("testStartServer"));

        suite.addTest(new AddOperationTest("testAddOperation1"));
        suite.addTest(new AddOperationTest("testAddOperation2"));
        suite.addTest(new CallEJBTest("testCallEJBInWS"));
        suite.addTest(new WSValidation("testDeploymentWS"));
        //suite.addTest(new WSValidation("testRegisterWS"));
        //suite.addTest(new WSValidation("testTestOperation"));
  
        suite.addTest(new WSValidation("testCreateWSClient"));
        suite.addTest(new WSValidation("testCallWS"));
        suite.addTest(new WSValidation("testRunWSClient"));
        suite.addTest(new WSValidation("testUndeployWSClient"));
               
        suite.addTest(new WSValidation("testUndeployWS"));
        
        suite.addTest(new WSValidation("testDeleteWSinWeb"));
        
        //suite.addTest(new GUIValidation("testNewWebServiceFromWSDL"));
        suite.addTest(new EJBValidation("testStopServer"));
        suite.addTest(new WSValidation("closeProjects"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        TestRunner.run(suite());
    }
        
    public void openProjects() {
        ProjectSupport.openProject(EAR_SAMPLE_PROJECT_PATH);
        ProjectSupport.waitScanFinished();
        ProjectSupport.openProject(EJB_SAMPLE_PROJECT_PATH);
        ProjectSupport.waitScanFinished();
        ProjectSupport.openProject(WEB_SAMPLE_PROJECT_PATH);
        ProjectSupport.waitScanFinished();
        ProjectSupport.openProject(WSC_SAMPLE_PROJECT_PATH);
        ProjectSupport.waitScanFinished();
        
        //TEMPORARY HACK
        try { new NbDialogOperator("Open Project").ok(); }
        catch (TimeoutExpiredException e) {}
        
        new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
    }
    
    public void closeProjects() {
        ProjectSupport.closeProject(EAR_SAMPLE_PROJECT_NAME);
        ProjectSupport.closeProject(EJB_SAMPLE_PROJECT_NAME);
        ProjectSupport.closeProject(WEB_SAMPLE_PROJECT_NAME);
        ProjectSupport.closeProject(WSC_SAMPLE_PROJECT_NAME);
    }    
    public void testDeploymentWS() throws IOException {
        String CONTROL_TEXT = "name=\"SampleWebService\""; 
        String page = Utils.deploy(EAR_SAMPLE_PROJECT_NAME, "http://localhost:8080/SampleApp-WebModule/SampleWebService?WSDL");
        log(page);
        assertTrue("WSDL doesn't contain expected text '"+CONTROL_TEXT+"'. See log for content.", page.indexOf(CONTROL_TEXT)>=0);
    }

    public void testUndeployWS() {
        Utils.undeploy(EAR_SAMPLE_PROJECT_NAME);
    }
    
    public void testDeleteWSinWeb() throws IOException {
        Node node = new Node(new ProjectsTabOperator().getProjectRootNode(WEB_SAMPLE_PROJECT_NAME),
                                 "Web Services|SampleWebService");
        new DeleteAction().performAPI(node);
        NbDialogOperator dialog = new NbDialogOperator("Confirm Web Service Deletion");
        dialog.yes();
        
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        Utils utils = new Utils(this);
        String ddNames[] = { "web.xml", 
                             "sun-web.xml" };
        utils.assertFiles(new File(WEB_SAMPLE_PROJECT_PATH + File.separator + "web" + File.separator + "WEB-INF"), ddNames, getName()+"_");

        File dir = new File(WEB_SAMPLE_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "sample");
        String deletedFiles[] = dir.list(new FilenameFilter () {
            public boolean accept(File dir, String name) {
                return name.startsWith("SampleWebService");
            }
        });
        File file = new File(WEB_SAMPLE_PROJECT_PATH + File.separator + "web" + File.separator + "WEB-INF" + File.separator + "webservices.xml");
        if (file.exists())
            fail("File "+file.getAbsolutePath()+" was not deleted.");
        // NOT YET IMPLEMENTED IN IDE
        /*
        if (deletedFiles != null && deletedFiles.length > 0) {
            fail("Web Service files was not deleted from directory "+dir.getAbsolutePath()+". I found "+Arrays.asList(deletedFiles));
        }
         */
    }
    
    public void testRegisterWS() {
        Node node = new Node(new ProjectsTabOperator().getProjectRootNode(WEB_SAMPLE_PROJECT_NAME),
                                 "Web Services|SampleWebService");
        node.performPopupActionNoBlock(Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_WSRegisterAction"));
        new NbDialogOperator(Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.ui.Bundle", "Enter_WSDL_Url")).ok();
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 120000);
        MainWindowOperator.getDefault().waitStatusText("Successfully compiled web service client code.");
        new Node(new RuntimeTabOperator().getRootNode(), "Web Services|SampleWebService|SampleWebServiceSEIPort|operation1");
    }
    
    public void testTestOperation() {
        String popup = "Test Operation";
        new Node(new RuntimeTabOperator().getRootNode(), "Web Services|SampleWebService|SampleWebServiceSEIPort|operation1").performPopupAction(popup);
        NbDialogOperator dialog = new NbDialogOperator("Test Web Service Operation");
        new JButtonOperator(dialog, "Submit").push();
        JTableOperator table = new JTableOperator(dialog,1);
        table.waitCell("sampleValue",0,1);
        dialog.close();
    }
    
    public void testCreateWSClient() {
        new NewFileAction().performMenu();
        NewFileWizardOperator wizard = new NewFileWizardOperator();
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        wizard.selectProject(WSC_SAMPLE_PROJECT_NAME);
        wizard.selectCategory("Web Services");
        wizard.selectFileType("Web Service Client");
        wizard.next();
        new JTextFieldOperator(wizard, 0).setText("http://localhost:8080/SampleApp-WebModule/SampleWebService?WSDL");
        new JComboBoxOperator(wizard,0).clearText();
        new JComboBoxOperator(wizard,0).typeText("test");
        new JButtonOperator(wizard, "Retrieve WSDL").push();
        wizard.finish();
        ProgressSupport.waitFinished("Creating webservice client", 30000);
    }
    
    public void testCallWS() {
        Node openFile = new Node(new ProjectsTabOperator().getProjectRootNode(WSC_SAMPLE_PROJECT_NAME),
                                 "Source Packages|servlet|TestServlet.java");
        new OpenAction().performAPI(openFile);
        EditorOperator editor = new EditorWindowOperator().getEditor("TestServlet.java");
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        editor.select(35);
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        new ActionNoBlock(null,"Web Service Client Resources|Call Web Service Operation").perform(editor);
        NbDialogOperator dialog = new NbDialogOperator("Select Operation to Invoke");
        new Node(new JTreeOperator(dialog),"SampleWebService|SampleWebServiceSEIPort|operation1").select();
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        dialog.ok();
        new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
        new Utils(this).checkAndModify("TestServlet.java", 37, "getSampleWebServiceSEIPort().operation1(/* TODO enter operation arguments */);",
                                       0, null, 37, true, "out.println(getSampleWebServiceSEIPort().operation1());");
    }
    
    public void testRunWSClient() throws IOException {
        String CONTROL_TEXT = "sampleValue"; 
        String page = Utils.deploy(WSC_SAMPLE_PROJECT_NAME, "http://localhost:8080/SampleApp-WSClient/TestServlet", true);
        log(page);
        assertTrue("TestServlet doesn't contain expected text '"+CONTROL_TEXT+"'. See log for content.", page.indexOf(CONTROL_TEXT)>=0);
    }
    
    public void testUndeployWSClient() {
        Utils.undeploy(Bundle.getStringTrimmed("org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.Bundle", "LBL_WebModules"), WSC_SAMPLE_PROJECT_NAME);
    }
    
    public void testNewWebServiceFromWSDL() {
        String dataDir = System.getProperty("xtest.data");
        String wsdlFile = dataDir + File.separator + "QuotesService.wsdl";
        File file = new File(wsdlFile);
        if (!file.exists())
            throw new RuntimeException("WSDL file not found:"+file.getAbsolutePath());
        new NewFileAction().performMenu();
        NewFileWizardOperator wizard = new NewFileWizardOperator();
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        wizard.selectProject(EAR_SAMPLE_PROJECT_NAME+"-war");
        wizard.selectCategory("Web Services");
        wizard.selectFileType("Web Service");
        wizard.next();
        new JTextFieldOperator(wizard, 0).setText("QuotesWebService");
        new JTextFieldOperator(wizard,2).typeText("quotes");
        new JRadioButtonOperator(wizard,"From Local WSDL File").push();
        new JTextFieldOperator(wizard,3).setText(file.getAbsolutePath());
        wizard.finish();
        JDialogOperator status = new JDialogOperator("Progress");
        status.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 120000);
        status.waitClosed();        
    }
            
}
