/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.addmethod;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.*;
import org.netbeans.jemmy.util.PNGEncoder;
import org.netbeans.test.j2ee.*;

/**
 *
 * @author lm97939
 */
public class AddCMPFieldTest extends AddMethodBase {
    
    protected String methodName;
    protected String returnType;
    private String description;
    private Boolean localGetter;
    private Boolean localSetter;
    private Boolean remoteGetter;
    private Boolean remoteSetter;
    
    /** Creates a new instance of AddMethodTest */
    public AddCMPFieldTest(String name) {
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        junit.textui.TestRunner.run(new AddCMPFieldTest("testAddCMPField1InEB"));
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }
    
    public void testAddCMPField1InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCmpFieldAction");
        methodName = "cmpTestField1x";
        description = null;
        returnType = "String";
        isDDModified = true;
        saveFile = true;
        addMethod();
    }

    public void testAddCMPField2InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCmpFieldAction");
        methodName = "cmpTestField2x";
        description = "Test Field";
        returnType = "int";
        localGetter = Boolean.TRUE;
        localSetter = Boolean.FALSE; 
        remoteGetter = Boolean.TRUE;
        remoteSetter = Boolean.TRUE; 
        isDDModified = true;
        saveFile = true;
        addMethod();
    }
    
    protected void addMethod() throws IOException {
        EditorOperator editor = new EditorWindowOperator().getEditor(beanName+"Bean.java");
        editor.select(11);

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(editor);
        AddCMPFieldDialog dialog = new AddCMPFieldDialog();
        dialog.setName(methodName);
        if (description != null) {
            dialog.setDescription(description);
        }
        if (returnType != null) {
            dialog.setType(returnType);
        }
        
        
        if (localGetter != null)
            dialog.checkLocalGetter(localGetter.booleanValue());
        if (localSetter != null)
            dialog.checkLocalSetter(localSetter.booleanValue());
        if (remoteGetter != null)
            dialog.checkRemoteGetter(remoteGetter.booleanValue());
        if (remoteSetter != null)
            dialog.checkRemoteSetter(remoteSetter.booleanValue());
        dialog.ok();
        
        if (saveFile) 
            editor.save();
        
        waitForEditorText(editor, methodName);
        
        compareFiles();
    }
    
}
