/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.addmethod;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.*;
import org.netbeans.test.j2ee.*;
import org.netbeans.test.j2ee.lib.Utils;

/**
 *
 * @author lm97939
 */
public class AddOperationTest extends AddMethodTest {
    
    
    /** Creates a new instance of AddMethodTest */
    public AddOperationTest(String name) {
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        junit.textui.TestRunner.run(new AddMethodTest("testAddOperation1"));
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }

    public void testAddOperation1()  throws IOException{
        beanName = "SampleWebService";
        editorPopup = /*Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_WebServiceActionGroup")
                               +"|"+*/Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_OperationAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_OperationAction");
        methodName = "operation1";
        returnType = "String";
        parameters = null;
        exceptions = null;
        isDDModified = false;
        saveFile = true;
        addMethod();
    }

    public void testAddOperation2()  throws IOException{
        beanName = "SampleWebService";
        editorPopup = /*Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_WebServiceActionGroup")
                               +"|"+*/Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_OperationAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_OperationAction");
        methodName = "operation2";
        returnType = "String";
        parameters = new String[][] {{"java.lang.String", "a"}, {"int", "b"}};
        exceptions = new String[] { "java.lang.Exception" };
        isDDModified = false;
        saveFile = true;
        addMethod();
    }
     
    
    protected void addMethod() throws IOException {
        Node openFile = new Node(new ProjectsTabOperator().getProjectRootNode(WSValidation.WEB_SAMPLE_PROJECT_NAME),
                                 "Web Services|"+beanName);
        new OpenAction().performAPI(openFile);
        
        EditorOperator editor = new EditorWindowOperator().getEditor(beanName+"Impl.java");
        //editor.select(12);
        //editor.requestFocus();

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(openFile);
        NbDialogOperator dialog = new NbDialogOperator(dialogTitle);
        
        new JTextFieldOperator(dialog).setText(methodName);
        if (returnType != null) {
            new JTextFieldOperator(dialog,1).setText(returnType);
        }
        fillParameters(dialog);
        fillExceptions(dialog);
        
        dialog.ok();
        if (saveFile) {
            editor.save();
        }
        
        waitForEditorText(editor, methodName);

        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        Utils utils = new Utils(this);
        String beanNames[] = { beanName+"Impl.java", 
                               beanName+"SEI.java", 
                               beanName+"-config.xml",
        };
        utils.assertFiles(new File(WSValidation.WEB_SAMPLE_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "sample"), beanNames, getName()+"_");
        String ddNames[] = { "web.xml", 
                             "sun-web.xml",
                             "webservices.xml"
        };
        utils.assertFiles(new File(WSValidation.WEB_SAMPLE_PROJECT_PATH + File.separator + "web" + File.separator + "WEB-INF"), ddNames, isDDModified?getName()+"_":"");

        editor.closeDiscard();
    }
    
  
    
}
