/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.addmethod;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTextAreaOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.util.PNGEncoder;
import org.netbeans.test.j2ee.*;

/**
 *
 * @author lm97939
 */
public class AddSelectMethodTest extends AddMethodTest {
    
    protected String ejbql = null;
    private String toSearchFile;
    
    /** Creates a new instance of AddMethodTest */
    public AddSelectMethodTest(String name) {
        super(name);
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }

    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        junit.textui.TestRunner.run(new AddSelectMethodTest("testAddSelectMethod1InEB"));
    }
    
    
    public void testAddSelectMethod1InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddSelectMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddSelectMethodAction");
        methodName = "ejbSelectByTest1";
        returnType = "int";
        parameters = null;
        ejbql = null;
        //toSearchFile = beanName+"LocalHome.java";
        isDDModified = true;
        saveFile = true;
        addMethod();
    }

    public void testAddSelectMethod2InEB()  throws IOException{
        beanName = "TestingEntity";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_EJBActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddSelectMethodAction");
        dialogTitle = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddSelectMethodAction");
        methodName = "ejbSelectByTest2";
        returnType = "int";
        parameters = new String[][] {{"java.lang.String", "a"}};
        ejbql = null;
        //toSearchFile = beanName+"LocalHome.java";
        isDDModified = true;
        saveFile = true;
        addMethod();
    }
    
    protected void addMethod() throws IOException {
        EditorOperator editor = new EditorWindowOperator().getEditor(beanName+"Bean.java");
        editor.select(11);

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(editor);
        NbDialogOperator dialog = new NbDialogOperator(dialogTitle);
        new JTextFieldOperator(dialog).setText(methodName);
        if (returnType != null) {
            new JTextFieldOperator(dialog,1).setText(returnType);
        }
        
        fillParameters(dialog);
        
        if (ejbql != null) {
            new JTextAreaOperator(dialog).setText(ejbql);
        }
        dialog.ok();
        
        if (saveFile) 
            editor.save();
        if (toSearchFile != null) {
            waitForEditorText(editor, methodName);
        }
        
        compareFiles();
    }
    
}
