/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.addmethod;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.test.j2ee.*;
import org.netbeans.test.j2ee.lib.Utils;

/**
 *
 * @author lm97939
 */
public class CallEJBTest extends AddMethodBase {

    private String calledBean;
    private boolean referencedLocal = true;
    private boolean convertExceptions = true;
    private String referenceName;
    
    /** Creates a new instance of AddMethodTest */
    public CallEJBTest(String name) {
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        junit.textui.TestRunner.run(new CallEJBTest("testCallEJB2InSB"));
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }
    
    public void testCallEJB1InSB()  throws IOException{
        beanName = "TestingSession";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_EnterpriseActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_CallEjbAction");
        calledBean = EJBValidation.EJB_PROJECT_NAME + "|TestingEntity";
        toSearchInEditor = "TestingEntityLocalHome lookupTestingEntityBean()";
        isDDModified = true;
        saveFile = true;
        addMethod();
    }

    public void testCallEJB2InSB()  throws IOException{
        beanName = "TestingSession";
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_EnterpriseActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_CallEjbAction");
        calledBean = EJBValidation.EJB_PROJECT_NAME + "|TestingEntity";
        toSearchInEditor = "TestingEntityRemoteHome lookupMyTestingEntityBean()";
        referencedLocal = false;
        convertExceptions = true;
        referenceName = "ejb/MyTestingEntityBean";
        isDDModified = true;
        saveFile = true;
        addMethod();
    }
    
    public void testCallEJBInServlet()  throws IOException{
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_EnterpriseActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_CallEjbAction");
        calledBean = EJBValidation.EJB_PROJECT_NAME + "|TestingSession";
        toSearchInEditor = "TestingSessionRemote lookupTestingSessionBean()";
        referencedLocal = false;
        isDDModified = true;
        saveFile = true;
        
        Node openFile = new Node(new ProjectsTabOperator().getProjectRootNode(EJBValidation.WEB_PROJECT_NAME),
                                 Bundle.getStringTrimmed("org.netbeans.modules.web.project.ui.Bundle", "LBL_Node_Sources")
                                 +"|test|TestingServlet.java");
        new OpenAction().performAPI(openFile);
        EditorOperator editor = new EditorWindowOperator().getEditor("TestingServlet.java");
        new org.netbeans.jemmy.EventTool().waitNoEvent(3000);
        editor.select(30);

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(editor);
        CallEnterpriseBeanDialog dialog = new CallEnterpriseBeanDialog();

        new Node(dialog.tree(),calledBean).select();
        if (referencedLocal) 
            dialog.local();
        else
            dialog.remote();
        dialog.checkConvertCheckedExceptionsToRuntimeException(convertExceptions);
        if (referenceName != null)
            dialog.setReferenceName(referenceName);
        
        dialog.ok();
        
        if (saveFile) 
            editor.save();
        
        waitForEditorText(editor, toSearchInEditor);
        
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        Utils utils = new Utils(this);
        utils.assertFiles(new File(EJBValidation.WEB_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "test"), new String[] {"TestingServlet.java"}, getName()+"_");
        String ddNames[] = { "web.xml", 
                             "sun-web.xml"
        };
        utils.assertFiles(new File(EJBValidation.WEB_PROJECT_PATH + File.separator + "web" + File.separator + "WEB-INF"), ddNames, isDDModified?getName()+"_":"");

        editor.closeDiscard();
        
    }

    public void testCallEJBInWS()  throws IOException{
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_EnterpriseActionGroup")
                               +"|"+Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.Bundle", "LBL_CallEjbAction");
        calledBean = WSValidation.EJB_SAMPLE_PROJECT_NAME + "|SampleSession";
        toSearchInEditor = "sample.SampleSessionRemote lookupSampleSessionBean()";
        referencedLocal = false;
        isDDModified = true;
        saveFile = true;
        
        Node openFile = new Node(new ProjectsTabOperator().getProjectRootNode(WSValidation.WEB_SAMPLE_PROJECT_NAME),
                                 "Web Services|SampleWebService");
        new OpenAction().performAPI(openFile);
        EditorOperator editor = new EditorWindowOperator().getEditor("SampleWebServiceImpl.java");
        new org.netbeans.jemmy.EventTool().waitNoEvent(3000);
        editor.select(11);

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(editor);
        CallEnterpriseBeanDialog dialog = new CallEnterpriseBeanDialog();

        new Node(dialog.tree(),calledBean).select();
        if (referencedLocal) 
            dialog.local();
        else
            dialog.remote();
        dialog.checkConvertCheckedExceptionsToRuntimeException(convertExceptions);
        if (referenceName != null)
            dialog.setReferenceName(referenceName);
        
        dialog.ok();
        
        new Utils(this).checkAndModify("SampleWebServiceImpl.java", 19, "// TODO implement operation", 20, "return null;", 20, true, "return lookupSampleSessionBean().sampleBusinessMethod();\n");
        
        if (saveFile) 
            editor.save();
        
        waitForEditorText(editor, toSearchInEditor);
        
        new org.netbeans.jemmy.EventTool().waitNoEvent(2000);
        Utils utils = new Utils(this);
        utils.assertFiles(new File(WSValidation.WEB_SAMPLE_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "sample"), new String[] {"SampleWebServiceImpl.java"}, getName()+"_");
        String ddNames[] = { "web.xml", 
                             "sun-web.xml",
                             "webservices.xml"
        };
        utils.assertFiles(new File(WSValidation.WEB_SAMPLE_PROJECT_PATH + File.separator + "web" + File.separator + "WEB-INF"), ddNames, isDDModified?getName()+"_":"");

        editor.closeDiscard();
    }
        
    protected void addMethod() throws IOException {
        EditorOperator editor = new EditorWindowOperator().getEditor(beanName+"Bean.java");
        editor.select(11);

        // invoke Add Business Method dialog
        new ActionNoBlock(null,editorPopup).perform(editor);
        CallEnterpriseBeanDialog dialog = new CallEnterpriseBeanDialog();

        new Node(dialog.tree(),calledBean).select();
        if (referencedLocal) 
            dialog.local();
        else
            dialog.remote();
        dialog.checkConvertCheckedExceptionsToRuntimeException(convertExceptions);
        if (referenceName != null) {
            dialog.clearReferenceName();
            dialog.typeReferenceName(referenceName);
        }
        
        dialog.ok();
        
        if (saveFile) 
            editor.save();
        
        waitForEditorText(editor, toSearchInEditor);
        
        compareFiles();
    }
    
}
