/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.cmp;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.netbeans.api.project.Project;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.lib.Utils;
import org.netbeans.test.j2ee.refactoring.Utility;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.cookies.EditorCookie;

import javax.swing.*;


/**
 *
 * @author blaha
 */
public class EjbCMPRefactorTest extends NbTestCase {
    public static final String EJB_PROJECT_NAME = "TestCMP";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;

    private static Project project;
    private static EjbJarMultiViewDataObject ddo;
    private static Entity bean;

    public EjbCMPRefactorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        NbTestSuite suite = new NbTestSuite(EjbCMPRefactorTest.class);
        return suite;
    }

    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }

    public void testOpenProject() throws Exception{
        File projectDir = new File(EJB_PROJECT_PATH);
        project = (Project)J2eeProjectSupport.openProject(projectDir);

        EjbJarProject ejbJarProject = (EjbJarProject)project;
        EjbJar ejb = ejbJarProject.getAPIEjbJar();
        FileObject ddFo = ejb.getDeploymentDescriptor();
        ddo = (EjbJarMultiViewDataObject)DataObject.find(ddFo);
        EditorCookie editorCookie = (EditorCookie) ddo.getCookie(EditorCookie.class);
        assertNotNull(editorCookie);
        editorCookie.open();

        // find Entity bean in project
        EnterpriseBeans beans = DDProvider.getDefault().
                getDDRoot(ddFo).getEnterpriseBeans();
        bean = (Entity)beans.findBeanByName(EnterpriseBeans.ENTITY, Ejb.EJB_NAME, "CustomerBean");
    }

    /*
    * Rename PK CMP field
    */
    public void testRenameCMPFromHelper() throws Exception{
        CmpField cmpField = null;

        // find correct CMP field, I want PK
        CmpField[] cmpFieldsArray = bean.getCmpField();
        for(int i = 0; i < cmpFieldsArray.length; i++){
            if(cmpFieldsArray[i].getFieldName().equals("id"))
                cmpField = cmpFieldsArray[i];
        }
        EntityHelper entityHelper = new EntityHelper((EjbJarMultiViewDataObject)ddo, bean);
        CmpFieldHelper cmpHelper = new CmpFieldHelper(entityHelper, cmpField);
        cmpHelper.setFieldName("newId"); //change CMP field name
        Utility.waitForAWTDispatchThread();
        assertTrue(Utility.saveDD(ddo));
        checkFiles(getName());
    }

    /*
    * Change PK CMP type
    */
    public void testChangeCMPTypeFromHelper() throws Exception{
        CmpField cmpField = null;

        // find correct CMP field, I want PK
        CmpField[] cmpFieldsArray = bean.getCmpField();
        for(int i = 0; i < cmpFieldsArray.length; i++){
            if(cmpFieldsArray[i].getFieldName().equals("newId"))
                cmpField = cmpFieldsArray[i];
        }

        EntityHelper entityHelper = new EntityHelper((EjbJarMultiViewDataObject)ddo, bean);
        CmpFieldHelper cmpHelper = new CmpFieldHelper(entityHelper, cmpField);
        cmpHelper.setType("java.lang.String"); //change CMP's type
        Utility.waitForAWTDispatchThread();
        assertTrue(Utility.saveDD(ddo));
        checkFiles(getName());
    }

    private void checkFiles(String methodName) throws IOException{
        Utils utils = new Utils(this);
        String ddNames[] = { "ejb-jar.xml", "sun-cmp-mappings.xml"};
        utils.assertFiles(new File(EJB_PROJECT_PATH + File.separator + "src" + File.separator + "conf"), ddNames, methodName+"_");

        String classNames[] = { "CustomerBean.java", "CustomerLocalBusiness.java"};
        utils.assertFiles(new File(EJB_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "cmp"), classNames, methodName+"_");
}
}
