/*
The contents of this file are subject to the terms of the Common Development
and Distribution License (the License). You may not use this file except in
compliance with the License.

You can obtain a copy of the License at http://www.netbeans.org/cddl.html
or http://www.netbeans.org/cddl.txt.

When distributing Covered Code, include this CDDL Header Notice in each file
and include the License file at http://www.netbeans.org/cddl.txt.
If applicable, add the following below the CDDL Header, with the fields
enclosed by brackets [] replaced by your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

The Original Software is NetBeans. The Initial Developer of the Original
Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.cmp;

import junit.textui.TestRunner;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;
import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.test.j2ee.lib.Utils;

/**
 *
 * @author blaha
 */
public class GUICMPTest extends JellyTestCase {
    
    public static final String EJB_PROJECT_NAME = "TestCMP";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;
    
    public static final String BEAN_NAME = "Customer";
    public static final String CMP_FIELD_NAME = "testCMP"; 
    public static final String RETURN_TYPE = "int";
    public static final String NEW_GETTER_NAME = "getNewId";
    public static final String NEW_G_CMP_NAME = "newId";
    public static final String NEW_SETTER_NAME = "setNewLastName";
    public static final String NEW_S_CMP_NAME = "newLastName";
    
    
    /** Creates a new instance of GUICMPTest */
    public GUICMPTest(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new GUICMPTest("testOpenProjects"));
        suite.addTest(new GUICMPTest("testAddCMPField"));
        suite.addTest(new GUICMPTest("testRenameGetterMethod"));
        suite.addTest(new GUICMPTest("testRenameSetterMethod"));
        suite.addTest(new GUICMPTest("testDeleteCMPField"));
        suite.addTest(new GUICMPTest("testCloseProject"));
        return suite;
    }
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        TestRunner.run(suite());
    }
    
    public void testOpenProjects(){
        ProjectSupport.openProject(EJB_PROJECT_PATH);
        ProjectSupport.waitScanFinished();
        new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
    }
    
    public void testAddCMPField() throws Exception{
       Node node = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME);
       new ActionNoBlock(null,org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddActionGroup")
       + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCmpFieldAction")).perform(node);
       NbDialogOperator dialog = new NbDialogOperator(org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.Bundle", "LBL_AddCmpFieldAction"));
       new JTextFieldOperator(dialog).setText(CMP_FIELD_NAME);
       new JComboBoxOperator(dialog).selectItem(RETURN_TYPE);
       dialog.ok();
       
       new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
       //saveProject();
       checkFiles("testAddCMPField"); //check java files and DD
       
       //check node in project tab
       node = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.Bundle", "LBL_CMPFields")
                + "|" + CMP_FIELD_NAME);
    }
    
    public void testRenameGetterMethod() throws Exception{
        Node beanNode = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME);
        new OpenAction().performAPI(beanNode);
        EditorOperator editor = new EditorWindowOperator().getEditor(BEAN_NAME);
        editor.select(65, 36,40);
        new ActionNoBlock(null,org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Action")
        + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Rename")).perform(editor);
        NbDialogOperator dialog = new NbDialogOperator(org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Rename"));
        new JButtonOperator(dialog,org.netbeans.jellytools.Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
        new JTextFieldOperator(dialog).setText(NEW_GETTER_NAME);
        new JButtonOperator(dialog,org.netbeans.jellytools.Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
        TopComponentOperator refactorWin = new TopComponentOperator(org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Refactoring"));
        new JButtonOperator(refactorWin,org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_DoRefactor")).push();
        
        editor.close();
        new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
        checkFiles("testRenameGetterMethod"); //check java files and DD
       // check Node
       Node node = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.Bundle", "LBL_CMPFields")
                + "|" + NEW_G_CMP_NAME);
    }
    
    public void testRenameSetterMethod() throws Exception{
        Node beanNode = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME);
        new OpenAction().performAPI(beanNode);
        EditorOperator editor = new EditorWindowOperator().getEditor(BEAN_NAME);
        editor.select(69, 26,36);
        new ActionNoBlock(null,org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Action")
        + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Rename")).perform(editor);
        NbDialogOperator dialog = new NbDialogOperator(org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Rename"));
        new JButtonOperator(dialog,org.netbeans.jellytools.Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
        new JTextFieldOperator(dialog).setText(NEW_SETTER_NAME);
        new JButtonOperator(dialog,org.netbeans.jellytools.Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
        TopComponentOperator refactorWin = new TopComponentOperator(org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_Refactoring"));
        new JButtonOperator(refactorWin,org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_DoRefactor")).push();
        
        editor.close();
        new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
        checkFiles("testRenameSetterMethod"); //check java files and DD
       // check Node
       Node node = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.Bundle", "LBL_CMPFields")
                + "|" + NEW_S_CMP_NAME);
    }
    
    public void testDeleteCMPField() throws Exception{
        Node node = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.Bundle", "LBL_CMPFields")
                + "|" + CMP_FIELD_NAME);
        new ActionNoBlock(null,org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.editor.Bundle", "popup-remove-selection")).perform(node);
       NbDialogOperator dialog = new NbDialogOperator(org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.refactoring.ui.Bundle", "LBL_SafeDel"));
       // first panel
       new JButtonOperator(dialog,org.netbeans.jellytools.Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
       // second panel
       new JButtonOperator(dialog,org.netbeans.jellytools.Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT")).push();
       
       new org.netbeans.jemmy.EventTool().waitNoEvent(5000);
       saveProject();
       checkFiles("testDeleteCMPField"); //check java files and DD
       // check Node
       try{
           node = new Node(new ProjectsTabOperator().getProjectRootNode(EJB_PROJECT_NAME),
                Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbjar.project.ui.Bundle", "LBL_node")
                + "|" + BEAN_NAME + "|" + org.netbeans.jellytools.Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.Bundle", "LBL_CMPFields")
                + "|" + CMP_FIELD_NAME);
           fail("Node isn't deleted!");
  
       }catch(TimeoutExpiredException timeE){
           // It's OK, node is deleted
       }
    }
    
    public void testCloseProject(){
        ProjectSupport.closeProject(EJB_PROJECT_NAME);
    }
    
    private void checkFiles(String methodName) throws IOException{
        Utils utils = new Utils(this);
        String ddNames[] = { "ejb-jar.xml", "sun-cmp-mappings.xml"};
        utils.assertFiles(new File(EJB_PROJECT_PATH + File.separator + "src" + File.separator + "conf"), ddNames, methodName+"_");

        String classNames[] = { "CustomerBean.java", "CustomerLocalBusiness.java"};
        utils.assertFiles(new File(EJB_PROJECT_PATH + File.separator + "src" + File.separator + "java" + File.separator + "cmp"), classNames, methodName+"_");
    }
    
    private void saveProject(){
        try{
        Action saveAll = new Action("File|Save All", null);
        saveAll.perform();
        }catch(TimeoutExpiredException timeE){
            // Save All action is disabled
        }
    }
}
