/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Micro//Systems, Inc. Portions Copyright 1997-2006 Sun
 * Micro//Systems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.hints;

import java.io.File;
import org.netbeans.junit.ide.ProjectSupport;

/**
 *
 * @author jindra
 */
public class EntityRelations extends HintsUtils{
    
    /** Creates a new instance of EntityRelations */
    public EntityRelations(String S) {
        super(S);
    }
    
    public void prepareProject() {
        ProjectSupport.openProject(new File(getDataDir(), "projects/EntityHintsApp"));
        ProjectSupport.openProject(new File(getDataDir(), "projects/EntityHintsEJB"));
    }
      
    public void testEntityHints(){
        EntityTest(new File(getDataDir(), "projects/EntityHintsApp/src/java/hints/B.java"), new File(getDataDir(), "projects/EntityHintsApp/src/java/hints/A.java"), 0, "Create");
    }
    
    public void testAARelation(){
        File f = new File(getDataDir(), "projects/EntityHintsApp/src/java/hints/CC.java");
        EntityTest(f,f,0, "");
    }
    
    public void testAAEJBRelation(){
        File f = new File(getDataDir(), "projects/EntityHintsEJB/src/java/hints/CC.java");
        EntityTest(f,f,1, "Create");
    }
    
    public void testEJBRelation(){
        EntityTest(new File(getDataDir(), "projects/EntityHintsEJB/src/java/hints/B.java"), new File(getDataDir(), "projects/EntityHintsEJB/src/java/hints/A.java"), 1, "Create");
    }
    
    public void testCreateID(){
        WebServiceTest(new File(getDataDir(), "projects/EntityHintsEJB/src/java/hints/CreateID.java"), "Create");             
    }
    
    public void testMakePublic(){
        File f=new File(getDataDir(), "projects/EntityHintsEJB/src/java/hints/MakePublic.java");
        WebServiceTest(f,"");
    }
    }
