/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Micro//Systems, Inc. Portions Copyright 1997-2006 Sun
 * Micro//Systems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.hints;

import java.io.File;
import org.netbeans.junit.ide.ProjectSupport;

/**
 *
 * @author jindra
 */
public class WebServices extends HintsUtils{
    
    /**
     * Creates a new instance of WebServices
     */
    public WebServices(String S) {
        super(S);
    }
    
    public void prepareProject() {
        ProjectSupport.openProject(new File(getDataDir(), "projects/WebServiceHintsEJB"));
    }
    
    public void testEndpointInterface(){
        WebServiceTest(new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/EndpointInterface.java"), "");        
    }
    
    public void testExceptions(){
        WebServiceTest(new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/Exceptions.java"), "");        
    }

    public void testHandlers(){
        WebServiceTest(new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/Handlers.java"), "");        
    }
    
    public void testIOParametrs(){
        WebServiceTest(new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/IOParametrs.java"), "");        
    }

    public void testReturnValue(){
        WebServiceTest(new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/ReturnValue.java"), "");        
    }

    public void testServiceName(){
        WebServiceTest(new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/ServiceName.java"), "");             
    }

    public void testWebMethodMissing(){
        File testedFile= new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/WebMethodMissing.java");
        String result = hintTest(testedFile, 1, "");//choose second possibility of hints list
        if (CREATE_GOLDENFILES) golden.println(result);
        ref.println(result);   
    }
    public void testAddOperation(){
        WebServiceTest(new File(getDataDir(), "projects/WebServiceHintsEJB/src/java/hints/AddOperation.java"), "Add");             
    }

}
