/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * AbstractJ2eeFile.java
 *
 * Created on May 24, 2005, 11:51 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package org.netbeans.test.j2ee.lib;

import java.io.File;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author jungi
 */
abstract class AbstractJ2eeFile {
    
    protected static final String MESSAGE = "$0 does not exist.";
    protected String pkgName;
    protected FileObject prjRoot;
    protected String name;
    protected boolean isEjbMod;
    protected String srcRoot;
    
    /** Creates a new instance of AbstractJ2eeFile */
    public AbstractJ2eeFile(String fqName, Project p) {
        this(fqName, p, "src/java");
    }
    
    public AbstractJ2eeFile(String fqName, Project p, String srcRoot) {
        int i = fqName.lastIndexOf('.') + 1;
        name = fqName.substring(i);
        pkgName = fqName.substring(0, i);
        prjRoot = p.getProjectDirectory();
        isEjbMod = p instanceof EjbJarProject;
        this.srcRoot = srcRoot;
    }
    
    protected boolean confFileExist(String name) {
        boolean retVal = false;
        String confDir = (isEjbMod) ? "src/conf" : "web/WEB-INF";
        File f = new File(FileUtil.toFile(prjRoot), confDir);
        try {
            File ff = new File(f, name);
            //System.err.println(ff.getAbsolutePath());
            //System.err.println("confEx: " + ff.exists());
            retVal = ff.exists();
        } catch (Exception e) {
        }
        return retVal;
    }
    
    protected boolean srcFileExist(String name) {
        boolean retVal = false;
        File f = new File(FileUtil.toFile(prjRoot), srcRoot);
        try {
            File ff = new File(f, name);
            //System.err.println(ff.getAbsolutePath());
            //System.err.println("srcEx: " + ff.exists());
            retVal = ff.exists();
        } catch (Exception e) {
        }
        return retVal;
    }
    
    /**
     * empty array iff there'are no errors, otherwise array of error messages
     *
     *@return empty array iff there'are no errors, otherwise array of error
     *     messages
     */
    public abstract String[] checkExistingFiles();
}
