/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Micro//Systems, Inc. Portions Copyright 1997-2006 Sun
 * Micro//Systems, Inc. All Rights Reserved.
 */
/*
 * Ejb.java
 *
 * Created on May 24, 2005, 6:01 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package org.netbeans.test.j2ee.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;

/**
 *
 * @author jungi
 */
public final class Ejb extends AbstractJ2eeFile {

    static final String IMPL = "Bean";
    static final String INTF = "Business";
    static final String HOME = "Home";
    static final String LOCAL = "Local";
    static final String REMOTE = "Remote";
    private boolean isLocal;
    private boolean isRemote;
    //private boolean isStateles;
    private String beanImpl;
    
    /** Creates a new instance of Ejb */
    public Ejb(String fqName, Project p, boolean local, boolean remote) {
        super(fqName, p);
        isLocal = local;
        isRemote = remote;
        beanImpl = name + IMPL;
    }
    
    public Ejb(String fqName, Project p, boolean local,
            boolean remote, String srcRoot) {
        super(fqName, p, srcRoot);
        isLocal = local;
        isRemote = remote;
        beanImpl = name + IMPL;
    }
    
    public String[] checkExistingFiles() {
        List l = new ArrayList();
        if (!implClassExists()) {
            l.add(MESSAGE.replaceAll("\\$0", "Bean impl class"));
        }
        if (isLocal) {
            if (!localIntfExists()) {
                l.add(MESSAGE.replaceAll("\\$0", "Local interface class"));
            }
            if (!localBusIntfExists()) {
                l.add(MESSAGE.replaceAll("\\$0", "Local business interface class"));
            }
            if (!localHomeIntfExists()) {
                l.add(MESSAGE.replaceAll("\\$0", "Local home interface class"));
            }
        }
        if (isRemote) {
            if (!remoteIntfExists()) {
                l.add(MESSAGE.replaceAll("\\$0", "Remote interface class"));
            }
            if (!remoteBusIntfExists()) {
                l.add(MESSAGE.replaceAll("\\$0", "Remote business interface class"));
            }
            if (!remoteHomeIntfExists()) {
                l.add(MESSAGE.replaceAll("\\$0", "Remote home interface class"));
            }
        }
        return (String[]) l.toArray(new String[l.size()]);
    }
    
    private boolean implClassExists() {
        String res = pkgName.replace('.', File.separatorChar) + beanImpl + ".java";
        //System.err.println("name: " + name);
        //System.err.println("impl: " + res);
        return srcFileExist(res);
    }
    
    private boolean localIntfExists() {
        String res = pkgName.replace('.', File.separatorChar) + name + LOCAL + ".java";
        //System.err.println("intf: " + res);
        return srcFileExist(res);
    }
    
    private boolean localBusIntfExists() {
        String res = pkgName.replace('.', File.separatorChar) + name + LOCAL + INTF + ".java";
        //System.err.println("intf: " + res);
        return srcFileExist(res);
    }
    
    private boolean localHomeIntfExists() {
        String res = pkgName.replace('.', File.separatorChar) + name + LOCAL + HOME + ".java";
        //System.err.println("intf: " + res);
        return srcFileExist(res);
    }
    
    private boolean remoteIntfExists() {
        String res = pkgName.replace('.', File.separatorChar) + name + REMOTE + ".java";
        //System.err.println("intf: " + res);
        return srcFileExist(res);
    }
    
    private boolean remoteBusIntfExists() {
        String res = pkgName.replace('.', File.separatorChar) + name + REMOTE + INTF + ".java";
        //System.err.println("intf: " + res);
        return srcFileExist(res);
    }
    
    private boolean remoteHomeIntfExists() {
        String res = pkgName.replace('.', File.separatorChar) + name + REMOTE + HOME + ".java";
        //System.err.println("intf: " + res);
        return srcFileExist(res);
    }
}
