/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.lib;

import org.netbeans.junit.diff.LineDiff;

/**
 *   Same as org.netbeans.junit.diff.LineDiff except of compareLines method.
 *
 * @author jungi
 */
public class FilteringLineDiff extends LineDiff {
    
    /**
     * Creates a new instance of FilteringLineDiff
     * 
     */
    public FilteringLineDiff() {
        this(false, false);
    }
    
    public FilteringLineDiff(boolean ignoreCase) {
        this(ignoreCase, false);
    }
    
    public FilteringLineDiff(boolean ignoreCase, boolean ignoreEmptyLines) {
        super(ignoreCase, ignoreEmptyLines);
    }
    
    /**
     *  Lines beginning with " * Created " or " * @author " are treated equals.
     *
     * @param l1 first line to compare
     * @param l2 second line to compare
     * @return true if lines equal
     */
    protected boolean compareLines(String l1,String l2) {
        if (super.compareLines(l1, l2)) {
            return true;
        }
        if (((l1.indexOf(" * Created ") == 0) && (l2.indexOf(" * Created ") == 0))
            || ((l1.indexOf(" * @author ") == 0) && (l2.indexOf(" * @author ") == 0))
            || ((l1.indexOf("Created-By: ") == 0) && (l2.indexOf("Created-By: ") == 0))) {
            return true;
        }
        return false;
    }
    
}
