/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.multiview;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.textui.TestRunner;
import org.netbeans.api.project.Project;
import org.netbeans.jellytools.JellyTestCase;
import junit.framework.Test;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.FinderMethodsNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.FinderMethodsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.QueryMethodHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.SelectMethodsNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.SelectMethodsTableModel;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.openide.cookies.EditCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

/**
 *
 * @author jp159440
 */
public class EBCMPFinderAndSelectMethodsTest extends JellyTestCase{
    
    public static final String EJB_PROJECT_NAME = "TestCMP";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;
    
    private static Project project;
    private static FileObject ddFo;
    private static EjbJar ejbJar;
    private static EjbJarMultiViewDataObject ddObj;
    private static Entity bean;
    private static CmpField[] cmpFields;
    private static Query[] query;
    
    /** Creates a new instance of EBCMPFinderAndSelectMethods */
    public EBCMPFinderAndSelectMethodsTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testOpenProject"));
        
        //test select methods
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testAddCMPSelectMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testExistingCMPSelectMethods"));
        //suite.addTest(new EBCMPFinderAndSelectMethodsTest("testModifyNameCMPSelectMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testModifyReturnTypeCMPSelectMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testModifyQueryCMPSelectMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testModifyDescriptionCMPSelectMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testRemoveCMPSelectMethod"));
        
        //test finder methods
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testExistingCMPFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testAddCMPFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testEditReturnCMPFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testEditQueryCMPFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testEditDescriptionCMPFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testRemoveCMPFinderMethod"));
        
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testAddRemoteFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testTransferRemote2LocalFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testTransferLocal2RemoteFinderMethod"));
        suite.addTest(new EBCMPFinderAndSelectMethodsTest("testBothInterfacesFinderMetohd"));
        return suite;
    }
    
    public void testOpenProject() throws Exception{
        File projectDir = new File(EJB_PROJECT_PATH);
        project = (Project)J2eeProjectSupport.openProject(projectDir);
        assertNotNull("Project is null.", project);
        Thread.sleep(1000);
        
        EjbJarProject ejbJarProject = (EjbJarProject)project;
        ddFo = ejbJarProject.getAPIEjbJar().getDeploymentDescriptor();  // deployment descriptor
        assertNotNull("ejb-jar.xml FileObject is null.", ddFo);
        
        ejbJar = DDProvider.getDefault().getDDRoot(ddFo);
        
        ddObj = (EjbJarMultiViewDataObject)DataObject.find(ddFo); //MultiView Editor
        assertNotNull("MultiViewDO is null.",ddObj);
        
        EditCookie edit = (EditCookie)ddObj.getCookie(EditCookie.class);
        edit.edit();
        Thread.sleep(1000);
        
        // select CustomerBean
        EnterpriseBeans beans = DDProvider.getDefault().getDDRoot(ddFo).getEnterpriseBeans();
        bean = (Entity)beans.findBeanByName(EnterpriseBeans.ENTITY,
                Ejb.EJB_NAME ,"CustomerBean");
        
        cmpFields = bean.getCmpField();
        
        ddObj.showElement(bean); //open visual editor
        Utils.waitForAWTDispatchThread();
    }
    
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }
    
    public void testExistingCMPFinderMethod() throws Exception {
        // inspects the contents of FinderMethods table via table model
        String[] methodsNames = {"findById","findByLastName","findByFirstName"};
        String[] methodsQuerys = {"SELECT OBJECT(c) FROM Customer AS c WHERE c.id = ?1",
        "SELECT OBJECT(c) FROM Customer AS c WHERE c.lastName = ?1",
        "SELECT OBJECT(c) FROM Customer AS c WHERE c.firstName = ?1"};
        String description = "auto generated method";
        FinderMethodsNode fmn = getFinderMethodNode(ddObj);
        fmn.getSectionNodePanel().open();  //open section in edior
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        FinderMethodsTableModel tableModel = entHelper.queries.getFinderMethodsTableModel();
        assertTrue("FinderMethod table has unexpected number of rows",tableModel.getRowCount()==3);
        for(int i=0;i<tableModel.getRowCount();i++) {  //controling each row in table
            assertEquals("Methods names do not match in "+i+". row",methodsNames[i],(String)tableModel.getValueAt(i,0));
            assertTrue("Return Collection is not set corectlly in "+i+". row",((Boolean)tableModel.getValueAt(i,1)).booleanValue());
            assertEquals("Result interfaces do not match in "+i+". row","local",(String)tableModel.getValueAt(i,2));
            assertEquals("Querys do not match in "+i+". row",methodsQuerys[i],(String)tableModel.getValueAt(i,3));
            assertEquals("Descriptions do not match in "+i+". row",description,(String)tableModel.getValueAt(i,4));
        }
    }
    
    public void testAddCMPFinderMethod() throws Exception {
        String methodName = "findByField" ;
        Method method = JMIUtils.createMethod(JMIUtils.findClass("cmp.CustomerBean"));
        method.setName(methodName);
        method.setType(JMIUtils.resolveType("java.util.Collection"));
        JMIUtils.addException(method, "javax.ejb.FinderException");
        EntityHelper entityHelper = new EntityHelper(ddObj, bean);
        EntityMethodController emc = entityHelper.getEntityMethodController();
        emc.addMethod(method,true,false);
        emc.addEjbQl(method,"SELECT OBJECT(o) FROM Customer o",ddFo);
        Thread.currentThread().sleep(500);
        getRowNumberByName(methodName);
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj,"<method-name>"+methodName+"</method-name>");
        utils.checkInXML(ddObj,"<ejb-ql>SELECT OBJECT(o) FROM Customer o</ejb-ql>");
        utils.checkFiles("testAddCMPFinderMethod", null, new String[]{"CustomerLocalHome.java"});
    }
    
    public void testEditReturnCMPFinderMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        FinderMethodsTableModel tableModel = entHelper.queries.getFinderMethodsTableModel();
        Utils utils = new Utils(this);
        int row = getRowNumberByName("findByField");
        tableModel.setValueAt(new Boolean(false),row,1);
        Thread.currentThread().sleep(500);
        QueryMethodHelper qmh = getQueryMethodHelperByName("findByField");
        assertEquals("Model not updated","cmp.CustomerLocal",qmh.getReturnType());
        utils.checkFiles("testEditReturnCMPFinderMethod",null,new String[]{"CustomerLocalHome.java"});
    }
    
    public void testEditQueryCMPFinderMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        QueryMethodHelper helper = getQueryMethodHelperByName("findByField");
        Utils utils = new Utils(this);
        int rowIndex = getRowNumberByName("findByField");
        boolean publishToLocal = helper.localMethod != null;
        boolean publishToRemote = helper.remoteMethod != null;
        boolean returnsCollection = helper.returnsCollection();
        Method method = helper.getPrototypeMethod();
        Query query = (Query) entHelper.queries.getFinderMethod(rowIndex).clone();
        query.setEjbQl("XXXX");
        helper.updateFinderMethod(method, query, !returnsCollection, publishToLocal, publishToRemote);
        Thread.currentThread().sleep(500);
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        saveCookie.save();
        utils.checkInXML(ddObj,"<ejb-ql>XXXX</ejb-ql>");
        assertEquals("Table model not updated","XXXX",entHelper.queries.getFinderMethodsTableModel().getValueAt(rowIndex,3));
        assertEquals("Model not updated","XXXX",helper.getEjbQl());
    }
    
    public void testEditDescriptionCMPFinderMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        FinderMethodsTableModel tableModel = entHelper.queries.getFinderMethodsTableModel();
        Utils utils = new Utils(this);
        int rowIndex = getRowNumberByName("findByField");
        tableModel.setValueAt("Modified description",rowIndex,4);
        Thread.currentThread().sleep(500);
        QueryMethodHelper helper = getQueryMethodHelperByName("findByField");
        SaveCookie saveCookie = (SaveCookie)ddObj.getCookie(SaveCookie.class);
        assertNotNull("Save cookie is null, Data object isn't changed!", saveCookie);
        saveCookie.save();
        utils.checkInXML(ddObj,"<description>Modified description</description>");
        assertEquals("Table model not updated","Modified description",entHelper.queries.getFinderMethodsTableModel().getValueAt(rowIndex,4));
        assertEquals("Model not updated","Modified description",helper.getDefaultDescription());
    }
    
    public void testEditNameCMPFinderMethod() throws Exception {
        //TODO
    }
    
    public void testRemoveCMPFinderMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        EntityMethodController emc = entHelper.getEntityMethodController();
        int row = getRowNumberByName("findByField");
        entHelper.queries.getFinderMethodsTableModel().removeRow(row);
        delayAndSave(ddObj);
        Utils utils = new Utils(this);
        utils.checkFiles("testRemoveCMPFinderMethod",null,new String[]{"CustomerLocalHome.java"});
        try {
            utils.checkInXML(ddObj,"<method-name>findByName</method-name>");
        } catch (AssertionFailedError aef) {
            //ok
            return;
        }
        fail("Method not removed from dd");
        return;
    }
    
    public void testAddCMPSelectMethod() throws Exception {
        SelectMethodsNode smn = getSelectMethodNode(ddObj);
        smn.getSectionNodePanel().open();
        Method method = JMIUtils.createMethod(JMIUtils.findClass("cmp.CustomerBean"));
        method.setName("ejbSelectBy");
        method.setType(JMIUtils.resolveType("int"));
        method.setModifiers(Modifier.PUBLIC|Modifier.ABSTRACT);
        JMIUtils.addException(method, "javax.ejb.FinderException");
        EntityHelper entityHelper = new EntityHelper(ddObj, bean);
        EntityMethodController emc = entityHelper.getEntityMethodController();
        emc.addSelectMethod(method,"SELECT COUNT(o) FROM Customer o",ddFo);
        Utils utils = new Utils(this);
        utils.checkFiles("testAddCMPSelectMethod",null,new String[]{"CustomerBean.java"});
        utils.checkInXML(ddObj,"<method-name>ejbSelectBy</method-name>");
        
    }
    
    public void testExistingCMPSelectMethods() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        SelectMethodsTableModel tableModel = entHelper.queries.getSelectMethodsTableModel();
        assertTrue("Wrong number of select methods",tableModel.getRowCount()==1);
        assertEquals("Unexpected Select method name","ejbSelectBy",tableModel.getValueAt(0,0));
        assertEquals("Unexpected Select method return type","int",tableModel.getValueAt(0,1));
        assertEquals("Unexpected Select method query","SELECT COUNT(o) FROM Customer o",tableModel.getValueAt(0,2));
        assertEquals("Unexpected Select method description",null,tableModel.getValueAt(0,3));
    }
    
    
    public void testModifyNameCMPSelectMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        SelectMethodsTableModel tableModel = entHelper.queries.getSelectMethodsTableModel();
        Query query = (Query) entHelper.queries.getSelecMethod(0).clone();
        QueryMethodHelper helper = tableModel.getQueryMethodHelper(0);
        Method method = helper.getPrototypeMethod();
        method.setType(JMIUtils.resolveType(method.getTypeName().getName()));
        method.setName("ejbSelectByMod");
        helper.updateSelectMethod(method,query);
    }
    
    public void testModifyReturnTypeCMPSelectMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        SelectMethodsTableModel tableModel = entHelper.queries.getSelectMethodsTableModel();
        Query query = (Query) entHelper.queries.getSelecMethod(0).clone();
        QueryMethodHelper helper = tableModel.getQueryMethodHelper(0);
        Method method = helper.getPrototypeMethod();
        method.setType(JMIUtils.resolveType("char"));
        helper.updateSelectMethod(method,query);
        Utils utils = new Utils(this);
        utils.checkFiles("testModifyReturnTypeCMPSelectMethod",null,new String[]{"CustomerBean.java"});
    }
    
    public void testModifyQueryCMPSelectMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        SelectMethodsTableModel tableModel = entHelper.queries.getSelectMethodsTableModel();
        Query query = (Query) entHelper.queries.getSelecMethod(0).clone();
        QueryMethodHelper helper = tableModel.getQueryMethodHelper(0);
        Method method = helper.getPrototypeMethod();
        query.setEjbQl("XXXX");
        helper.updateSelectMethod(method,query);
        delayAndSave(ddObj);
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj,"<ejb-ql>XXXX</ejb-ql>");
    }
    
    public void testModifyDescriptionCMPSelectMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        SelectMethodsTableModel tableModel = entHelper.queries.getSelectMethodsTableModel();
        tableModel.setValueAt("New description",0,3);
        delayAndSave(ddObj);
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj,"<description>New description</description>");
    }
    public void testRemoveCMPSelectMethod() throws Exception {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        EntityMethodController emc = entHelper.getEntityMethodController();
        entHelper.queries.getSelectMethodsTableModel().removeRow(0);
        delayAndSave(ddObj);
        Utils utils = new Utils(this);
        utils.checkFiles("testRemoveCMPSelectMethod",null,new String[]{"CustomerBean.java"});
        try {
            utils.checkInXML(ddObj,"<method-name>ejbSelectBy</method-name>");
        } catch (AssertionFailedError aef) {
            //ok
            return;
        }
        fail("Method not removed from dd");
        return;
    }
    
    public void testAddRemoteFinderMethod() throws Exception {
        ddObj.getEntityHelper(bean).addInterfaces(false); //added remote interface (tested elsewhere)
        String methodName = "findByAux" ;
        String queryString ="SELECT OBJECT(o) FROM Customer AUX";
        Method method = JMIUtils.createMethod(JMIUtils.findClass("cmp.CustomerBean"));
        method.setName(methodName);
        method.setType(JMIUtils.resolveType("java.util.Collection"));
        JMIUtils.addException(method, "javax.ejb.FinderException");
        //JMIUtils.addException(method, "java.rmi.RemoteException");
        EntityHelper entityHelper = new EntityHelper(ddObj, bean);
        EntityMethodController emc = entityHelper.getEntityMethodController();
        emc.addMethod(method,false,false); //adding to remote iface
        emc.addEjbQl(method,queryString,ddFo);
        delayAndSave(ddObj);
        //testing table model
        int row = getRowNumberByName(methodName);
        FinderMethodsTableModel tableModel = entityHelper.queries.getFinderMethodsTableModel();
        assertEquals("Wrong Result Interface description",tableModel.getValueAt(row,2),"remote");
        Utils utils = new Utils(this);
        //testig XML
        utils.checkInXML(ddObj,"<method-name>"+methodName+"</method-name>");
        utils.checkInXML(ddObj,"<ejb-ql>"+queryString+"</ejb-ql>");
        //testig classes
        JavaClass remoteHome = entityHelper.getHomeInterfaceClass();
        Method findMethod = getMethodByName(remoteHome,methodName);
        assertNotNull("Method not found",findMethod);
        assertEquals("Wrong return type","java.util.Collection",findMethod.getType().getName());
        assertEquals("Wrong modifiers",(Modifier.ABSTRACT | Modifier.PUBLIC),findMethod.getModifiers());
        List expectedEx  = new ArrayList();
        expectedEx.add("javax.ejb.FinderException");
        expectedEx.add("java.rmi.RemoteException");
        throwsExceptions(expectedEx,findMethod.getExceptions());
    }
    
    public void testTransferRemote2LocalFinderMethod() throws Exception {
        String methodName = "findByAux" ;
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        QueryMethodHelper helper = getQueryMethodHelperByName(methodName);
        Utils utils = new Utils(this);
        int rowIndex = getRowNumberByName(methodName);
        FinderMethodsTableModel tableModel = entHelper.queries.getFinderMethodsTableModel();
        boolean publishToLocal = true;
        boolean publishToRemote = false;
        boolean returnsCollection = helper.returnsCollection();
        Method method = helper.getPrototypeMethod();
        Query query = (Query) entHelper.queries.getFinderMethod(rowIndex).clone();
        JMIUtils.addException(method, "javax.ejb.FinderException");
        helper.updateFinderMethod(method, query, !returnsCollection, publishToLocal, publishToRemote);
        //testing table model
        assertEquals("Wrong Result Interface description",tableModel.getValueAt(rowIndex,2),"local");
        //testing classes
        JavaClass remoteHome = entHelper.getHomeInterfaceClass();
        JavaClass localHome = entHelper.getLocalHomeInterfaceClass();
        Method finder = getMethodByName(remoteHome,methodName);
        assertNull("Method not deleted from remote interface",finder);
        finder  = getMethodByName(localHome,methodName);
        assertNotNull("Method not found in local interface",finder);
        assertEquals("Wrong return type","java.util.Collection",finder.getType().getName());
        List expectedEx  = new ArrayList();
        expectedEx.add("javax.ejb.FinderException");
        throwsExceptions(expectedEx,finder.getExceptions());
    }
    
    public void testTransferLocal2RemoteFinderMethod() throws Exception {
        String methodName = "findByFirstName" ;
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        QueryMethodHelper helper = getQueryMethodHelperByName(methodName);
        FinderMethodsTableModel tableModel = entHelper.queries.getFinderMethodsTableModel();
        Utils utils = new Utils(this);
        int rowIndex = getRowNumberByName(methodName);
        boolean publishToLocal = false;
        boolean publishToRemote = true;
        boolean returnsCollection = helper.returnsCollection();
        Method method = helper.getPrototypeMethod();
        Query query = (Query) entHelper.queries.getFinderMethod(rowIndex).clone();
        JMIUtils.addException(method, "javax.ejb.FinderException");
        helper.updateFinderMethod(method, query, !returnsCollection, publishToLocal, publishToRemote);
        // testing table model
        assertEquals("Wrong Result Interface description",tableModel.getValueAt(rowIndex,2),"remote");
        //testing classes
        JavaClass remoteHome = entHelper.getHomeInterfaceClass();
        JavaClass localHome = entHelper.getLocalHomeInterfaceClass();
        Method finder  = getMethodByName(localHome,methodName);
        assertNull("Method not deleted from local interface",finder);
        finder = getMethodByName(remoteHome,methodName);
        assertNotNull("Method not found in remote interface",finder);
        assertEquals("Wrong return type","java.util.Collection",finder.getType().getName());
        List expectedEx  = new ArrayList();
        expectedEx.add("javax.ejb.FinderException");
        expectedEx.add("java.rmi.RemoteException");
        throwsExceptions(expectedEx,finder.getExceptions());
    }
    
    public void testBothInterfacesFinderMetohd() throws Exception {
        String methodName = "findByFirstName" ;
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        QueryMethodHelper helper = getQueryMethodHelperByName(methodName);
        FinderMethodsTableModel tableModel = entHelper.queries.getFinderMethodsTableModel();
        Utils utils = new Utils(this);
        int rowIndex = getRowNumberByName(methodName);
        boolean publishToLocal = true;
        boolean publishToRemote = true;
        boolean returnsCollection = helper.returnsCollection();
        Method method = helper.getPrototypeMethod();
        Query query = (Query) entHelper.queries.getFinderMethod(rowIndex).clone();
        helper.updateFinderMethod(method, query, !returnsCollection, publishToLocal, publishToRemote);
        delayAndSave(ddObj);
        // test table model (generation of methods tested in previous methods
        assertEquals("Wrong Result Interface description",tableModel.getValueAt(rowIndex,2),"local+remote");
    }
    
    private QueryMethodHelper getQueryMethodHelperByName(String name) {
        EntityHelper entHelper = ddObj.getEntityHelper(bean);
        Query[] queries = entHelper.queries.getQuery();
        for (int i = 0; i < queries.length; i++) {
            if(queries[i].getQueryMethod().getMethodName().equals(name)) return entHelper.queries.getQueryMethodHelper(queries[i]);
        }
        assertTrue("Querymethod "+name+" not found",false);
        return null;
    }
    
    private int getRowNumberByName(String name) {
        EntityHelper entityHelper = new EntityHelper(ddObj, bean);
        FinderMethodsTableModel tableModel = entityHelper.queries.getFinderMethodsTableModel();
        int i;
        for(i=0;i<tableModel.getRowCount();i++) {
            if(tableModel.getValueAt(i,0).equals(name)) break;
        }
        assertTrue("Method "+name+" is not added to table model",i!=tableModel.getRowCount());
        return i;
    }
    
    private FinderMethodsNode getFinderMethodNode(EjbJarMultiViewDataObject ddObj) {
        EntityNode entityNode = Utils.getEntityNode(ddObj);
        assertNotNull("No Entitynode found",entityNode);
        Node[] nodes = Utils.getChildrenNodes(entityNode);
        for (int i = 0; i < nodes.length; i++) {
            if(nodes[i] instanceof FinderMethodsNode) return (FinderMethodsNode)nodes[i];
        }
        fail("No FinderMethodsNode found");
        return null;
    }
    
    private SelectMethodsNode getSelectMethodNode(EjbJarMultiViewDataObject ddObj) {
        EntityNode entityNode = Utils.getEntityNode(ddObj);
        assertNotNull("No Entitynode found",entityNode);
        Node[] nodes = Utils.getChildrenNodes(entityNode);
        for (int i = 0; i < nodes.length; i++) {
            if(nodes[i] instanceof SelectMethodsNode) return (SelectMethodsNode)nodes[i];
        }
        fail("No SelectMethodsNode found");
        return null;
    }
    
    private void delayAndSave(EjbJarMultiViewDataObject obj) throws Exception {
        new StepIterator() {
            SaveCookie saveCookie;
            public boolean step() throws Exception {
                saveCookie = (SaveCookie) ddObj.getCookie(SaveCookie.class);
                return saveCookie!=null;
            }
        };
        SaveCookie saveCookie = (SaveCookie) ddObj.getCookie(SaveCookie.class);
        assertNotNull("Document was not modified",saveCookie);
        saveCookie.save();                
    }
    
    private Method getMethodByName(JavaClass jc,String name) {
        Method[] methods = JMIUtils.getMethods(jc);
        for(int i=0;i<methods.length;i++) if(methods[i].getName().equals(name)) return methods[i];
        return null;
    }
    
    private boolean throwsExceptions(List expected,List currentlyThrown) throws Exception {
        String temp;
        //    assertEquals("Count of expected and really declared exception differ",expected.size(),currentlyThrown.size());
        List exNames = new LinkedList();
        Iterator it = currentlyThrown.iterator();
        while(it.hasNext()) {
            temp = ((JavaClass)it.next()).getName();
            assertTrue("Unexpected exception "+temp+" is declared to be thrown",expected.contains(temp));
            exNames.add(temp);
        }
        it = expected.iterator();
        while(it.hasNext()) {
            temp = (String)it.next();
            assertTrue("Expected exception "+temp+" is not declared to be thrown",exNames.contains(temp));
        }
        return true;
    }
    
}
