/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.multiview;

import java.io.File;
import javax.swing.event.DocumentListener;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.netbeans.api.project.Project;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ddloaders.multiview.BeanDetailNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.BeanDetailsPanel;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldsNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpFieldsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.xml.multiview.ui.SectionNodePanel;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;


/**
 *
 * @author blaha
 */
public class EBDetailsAndCMPFieldPanelTest extends JellyTestCase {
    public static final String EJB_PROJECT_NAME = "TestCMP";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;
    
    private static Project project;
    private static EjbJarMultiViewDataObject ddObj;
    private static FileObject ddFo;
    private static Entity bean;
    private static EjbJar ejbJar;
    private static CmpField[] cmpFields;
    private static EntityMethodController mC;
    private static CmpField newCmpField;
    private static int row;
    
    public EBDetailsAndCMPFieldPanelTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        // general panel
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testOpenProject"));
         /*
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testEBName"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testDescription"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testSmallIcon"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testLargeIcon"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testRevertChanges"));*/
        
        // CMP fields panel
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testExistingCMPFields"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testAddNewCMPField"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPFieldName"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPMethods"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPType"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testChangeCMPDescription"));
        suite.addTest(new EBDetailsAndCMPFieldPanelTest("testDeleteCMPField"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }
    
    public void testOpenProject() throws Exception{
        File projectDir = new File(EJB_PROJECT_PATH);
        project = (Project)J2eeProjectSupport.openProject(projectDir);
        assertNotNull("Project is null.", project);
        Thread.sleep(1000);
        
        EjbJarProject ejbJarProject = (EjbJarProject)project;
        ddFo = ejbJarProject.getAPIEjbJar().getDeploymentDescriptor();  // deployment descriptor
        assertNotNull("ejb-jar.xml FileObject is null.", ddFo);
        
        ejbJar = DDProvider.getDefault().getDDRoot(ddFo);
        
        ddObj = (EjbJarMultiViewDataObject)DataObject.find(ddFo); //MultiView Editor
        assertNotNull("MultiViewDO is null.",ddObj);
        
        EditCookie edit = (EditCookie)ddObj.getCookie(EditCookie.class);
        edit.edit();
        Thread.sleep(1000);
        
        // select CustomerBean
        EnterpriseBeans beans = DDProvider.getDefault().getDDRoot(ddFo).getEnterpriseBeans();
        bean = (Entity)beans.findBeanByName(EnterpriseBeans.ENTITY,
                Ejb.EJB_NAME ,"CustomerBean");
        
        cmpFields = bean.getCmpField();
        
        ddObj.showElement(bean); //open visual editor
        Utils.waitForAWTDispatchThread();
    }
    
    public void testEBName() throws Exception{
        assertEquals("CustomerEB",getBeanDetailPanel().getDisplayNameTextField().getText());
        getBeanDetailPanel().getDisplayNameTextField().setText("testBeanName");
        assertEquals("testBeanName", bean.getDisplayName(null));
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<display-name>testBeanName</display-name>");
        utils.save(ddObj);
        utils.checkFiles("testEBName",new String[]{"ejb-jar.xml"},null);
    }
    
    public void testDescription() throws Exception{
        assertEquals("jdbc:mysql://localhost:3306/users [blaha on Default schema]",getBeanDetailPanel().getDescriptionTextArea().getText());
        getBeanDetailPanel().getDescriptionTextArea().setText("testDescription");
        assertEquals("testDescription", bean.getDescription(null));
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<description>testDescription</description>");
        utils.save(ddObj);
        utils.checkFiles("testDescription",new String[]{"ejb-jar.xml"},null);
    }
    
    public void testSmallIcon() throws Exception{
        assertEquals("",getBeanDetailPanel().getSmallIconTextField().getText().trim());
        getBeanDetailPanel().getSmallIconTextField().setText("testEntitySmallIcon");
        assertEquals("testEntitySmallIcon", bean.getSmallIcon(null));
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<small-icon>testEntitySmallIcon</small-icon>");
        utils.save(ddObj);
        utils.checkFiles("testSmallIcon",new String[]{"ejb-jar.xml"},null);
    }
    
    public void testLargeIcon() throws Exception{
        assertEquals("",getBeanDetailPanel().getLargeIconTextField().getText().trim());
        getBeanDetailPanel().getLargeIconTextField().setText("testEntityLargeIcon");
        assertEquals("testEntityLargeIcon", bean.getLargeIcon(null));
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<large-icon>testEntityLargeIcon</large-icon>");
        utils.save(ddObj);
        utils.checkFiles("testLargeIcon",new String[]{"ejb-jar.xml"},null);
    }
    
    public void testRevertChanges() throws Exception{
        bean.setDisplayName("CustomerEB"); // back changes
        bean.setDescription("jdbc:mysql://localhost:3306/users [blaha on Default schema]"); // back changes
        bean.setSmallIcon(null); // back changes
        bean.setLargeIcon(null); // back changes
        ejbJar.write(ddFo);
    }
    
    //CMP Field panel
    public void testExistingCMPFields(){
        String[] fieldsName = new String[]{"firstName","id","lastName"};
        String[] fieldsType = new String[]{"java.lang.String","java.lang.Long","java.lang.String"};
        for(int i = 0; i < cmpFields.length; i++){
            CmpFieldsTableModel cmpTableModel = getCmpTableModel();
            int row = ddObj.getEntityHelper(bean).cmpFields.getFieldRow(cmpFields[i]);
            assertEquals(fieldsName[i], cmpTableModel.getValueAt(i,0)); //name
            assertEquals(fieldsType[i], cmpTableModel.getValueAt(i,1)); //type
            assertTrue(((Boolean)cmpTableModel.getValueAt(i,2)).booleanValue()); // local getter
            if(cmpTableModel.getValueAt(i,0).equals("id")){
                assertFalse(((Boolean)cmpTableModel.getValueAt(i,3)).booleanValue()); // local setter
            }else{
                assertTrue(((Boolean)cmpTableModel.getValueAt(i,3)).booleanValue()); // local setter
            }
            assertFalse(((Boolean)cmpTableModel.getValueAt(i,4)).booleanValue()); // no remote getter
            assertFalse(((Boolean)cmpTableModel.getValueAt(i,5)).booleanValue()); // no remote setter
            assertNull(cmpTableModel.getValueAt(i,6)); // no description
        }
    }
    
    public void testAddNewCMPField() throws Exception{
        // create new CMP field
        JavaClass javaClass = JMIUtils.findClass("cmp.CustomerBean");
        assertNotNull("Can't find class", javaClass);
        mC = (EntityMethodController)EjbMethodController.createFromClass(javaClass);
        mC.addField(JMIUtils.createField(javaClass, "testCMPField", "java.lang.Float"),
                ddFo, true, true, false, false, "test CMP field");
        // check values in visual editor
        CmpFieldsTableModel cmpTableModel = getCmpTableModel();
        cmpFields = bean.getCmpField();
        for(int i = 0; i < cmpFields.length; i++){
            if(!cmpFields[i].getFieldName().equals("testCMPField")){
                if(i == (cmpFields.length - 1)){
                    fail("Can't find new CMP field");
                }
                continue;
            }
            int row = ddObj.getEntityHelper(bean).cmpFields.getFieldRow(cmpFields[i]);
            assertEquals("testCMPField", cmpTableModel.getValueAt(row,0));
            assertEquals("java.lang.Float", cmpTableModel.getValueAt(row,1));
            assertTrue(((Boolean)cmpTableModel.getValueAt(row,2)).booleanValue());
            assertTrue("Local setter is disabled.", ((Boolean)cmpTableModel.getValueAt(row,3)).booleanValue());
            assertFalse(((Boolean)cmpTableModel.getValueAt(row,4)).booleanValue());
            assertFalse(((Boolean)cmpTableModel.getValueAt(row,5)).booleanValue());
            assertEquals("test CMP field", cmpTableModel.getValueAt(row,6));
        }
        Utils utils = new Utils(this);
        // check xml view
        utils.checkInXML(ddObj, "<field-name>testCMPField</field-name>");
        utils.checkInXML(ddObj, "<description>test CMP field</description>");
    }
    
    public void testChangeCMPFieldName() throws Exception{
        // find CMP field, it should have index 3
        newCmpField = bean.getCmpField(3);
        assertEquals("testCMPField", newCmpField.getFieldName());
        row = ddObj.getEntityHelper(bean).cmpFields.getFieldRow(newCmpField);
        getCmpTableModel().setValueAt("testChangeCMPFieldName",row, 0);
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<field-name>testChangeCMPFieldName</field-name>");
        utils.checkFiles("testChangeCMPFieldName", new String[]{"ejb-jar.xml"}, 
                new String[]{"CustomerBean.java", "CustomerLocalBusiness.java"});
    }
    
    public void testChangeCMPMethods() throws Exception{
        Utils utils = new Utils(this);
        getCmpTableModel().setValueAt(new Boolean("false"),row,2);
        utils.checkFiles("testChangeCMPMethods", new String[]{"ejb-jar.xml"}, 
                new String[]{"CustomerBean.java", "CustomerLocalBusiness.java"});
    }
    
    public void testChangeCMPType() throws Exception{
        getCmpTableModel().setValueAt("boolean",row, 1);
        Utils utils = new Utils(this);
        utils.checkFiles("testChangeCMPType", new String[]{"ejb-jar.xml"}, 
                new String[]{"CustomerBean.java", "CustomerLocalBusiness.java"});
    }
    
    public void testChangeCMPDescription() throws Exception{
        getCmpTableModel().setValueAt("testChangeCMPDescription",row, 6);
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<description>testChangeCMPDescription</description>");
        utils.save(ddObj);
        utils.checkFiles("testChangeCMPDescription", new String[]{"ejb-jar.xml"}, null);
    }
    
    public void testDeleteCMPField() throws Exception{
        mC.deleteField(newCmpField, ddFo);
        Utils utils = new Utils(this);
        try {
            utils.checkInXML(ddObj, "<description>test CMP field</description>");
            utils.checkInXML(ddObj, "<field-name>testCMPField</field-name>");
            fail("Elements testCMPField is still visible in xml view.");
        } catch (AssertionFailedError e) {
            // it's ok
        }
        // try to find CMP field in dataModel
        for(int i = 0; i < getCmpTableModel().getRowCount(); i++){
            assertFalse(getCmpTableModel().getValueAt(i,0).equals("testCMPField"));
        }
        utils.checkFiles("testDeleteCMPField", new String[]{"ejb-jar.xml"}, 
                new String[]{"CustomerBean.java", "CustomerLocalBusiness.java"});
    }
    
    private BeanDetailsPanel getBeanDetailPanel(){
        Node[] nnChild = Utils.getChildrenNodes(Utils.getEntityNode(ddObj));
        for(int k = 0; k < nnChild.length; k++){
            if(nnChild[k] instanceof BeanDetailNode){
                SectionNodePanel overviewPanel = ((BeanDetailNode)nnChild[k]).getSectionNodePanel();
                overviewPanel.open();
                return (BeanDetailsPanel)overviewPanel.getInnerPanel();
            }
        }
        return null;
    }
    
    private CmpFieldsTableModel getCmpTableModel(){
        Node[] nnChild = Utils.getChildrenNodes(Utils.getEntityNode(ddObj));
        for(int k = 0; k < nnChild.length; k++){
            if(nnChild[k] instanceof CmpFieldsNode){
                SectionNodePanel cmpPanel = ((CmpFieldsNode)nnChild[k]).getSectionNodePanel();
                cmpPanel.open();
                EntityHelper entHelper = ddObj.getEntityHelper(bean);
                return entHelper.cmpFields.getCmpFieldsTableModel();
            }
        }
        return null;
    }
    
    private CmpFieldHelper getCmpFieldHelper(int row){
        return ddObj.getEntityHelper(bean).cmpFields.getCmpFieldHelper(row);
    }
    
}
