/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.multiview;

import java.io.File;
import java.io.IOException;
import javax.swing.text.StyledDocument;
import junit.textui.TestRunner;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import junit.framework.Test;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ddloaders.multiview.BeanEnvironmentNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpRelationshipsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbReferencesNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbReferencesTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.EnvironmentEntriesNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.EnvironmentEntriesTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTablePanel;
import org.netbeans.modules.j2ee.ddloaders.multiview.RelationshipHelper;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.ddloaders.multiview.ResourceEnvironmentReferencesNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.ResourceEnvironmentReferencesTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.ResourceReferencesNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.ResourceReferencesTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.SecurityRoleReferencesNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.SecurityRoleReferencesTableModel;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.xml.multiview.ui.SectionNodePanel;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.openide.cookies.EditCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

/**
 *
 * @author jhorvath
 */
public class EnvironmentPanelTest extends DDTestCase {
    public static final String EJB_PROJECT_NAME = "TestCMPRelationships";
    public static final String EJB_PROJECT_PATH = System.getProperty("xtest.tmpdir") + File.separator + EJB_PROJECT_NAME;

    private static final String TEST_BEAN_NAME="EntityABean";
    
    public EnvironmentPanelTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();        
        System.out.println("########  "+getName()+"  #######");
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        
        suite.addTest(new EnvironmentPanelTest("testOpenProject"));
          
        suite.addTest(new EnvironmentPanelTest("testAddBeanReference"));
        
        suite.addTest(new EnvironmentPanelTest("testEnvironmentEntries"));
       
        suite.addTest(new EnvironmentPanelTest("testXMTToVisualSync"));
       
        suite.addTest(new EnvironmentPanelTest("testResourceReferences"));
        suite.addTest(new EnvironmentPanelTest("testResourceEnvironmentReferences"));
        suite.addTest(new EnvironmentPanelTest("testSecurityRoleReferences"));
        
        suite.addTest(new EnvironmentPanelTest("testModifyEnvironmentEntries"));
        suite.addTest(new EnvironmentPanelTest("testModifyResourceReferences"));
        suite.addTest(new EnvironmentPanelTest("testModifyResourceEnvironmentReferences"));        
        suite.addTest(new EnvironmentPanelTest("testModifySecurityRoleReferences"));
        
        //suite.addTest(new EnvironmentPanelTest("testRemoveEnvironmentEntries")); 
        suite.addTest(new EnvironmentPanelTest("testRemoveResourceReferences"));
        suite.addTest(new EnvironmentPanelTest("testRemoveResourceEnvironmentReferences"));        
        suite.addTest(new EnvironmentPanelTest("testRemoveSecurityRoleReferences"));
        
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run only selected test case
        TestRunner.run(suite());
    }
    
    /*
     * Method open project
     *
     */
    public void testOpenProject() throws Exception{
        File projectDir = new File(EJB_PROJECT_PATH);
        project = (Project)J2eeProjectSupport.openProject(projectDir);
        assertNotNull("Project is null.", project);
        Thread.sleep(1000);
        
        EjbJarProject ejbJarProject = (EjbJarProject)project;
        ddFo = ejbJarProject.getAPIEjbJar().getDeploymentDescriptor();  // deployment descriptor
        assertNotNull("ejb-jar.xml FileObject is null.", ddFo);
        
        ejbJar = DDProvider.getDefault().getDDRoot(ddFo);
        
        ddObj = (EjbJarMultiViewDataObject)DataObject.find(ddFo); //MultiView Editor
        assertNotNull("MultiViewDO is null.",ddObj);
        
        EditCookie edit = (EditCookie)ddObj.getCookie(EditCookie.class);
        edit.edit();
        
        Thread.sleep(500);
        showBean();
        Utils.waitForAWTDispatchThread();
    }
    
    public void testXMTToVisualSync() throws Exception {
        ddObj.openView(2);
        ddObj.createInputStream();
        XmlMultiViewEditorSupport editor = (XmlMultiViewEditorSupport)ddObj.createCookie(EditCookie.class);
        StyledDocument document=editor.getDocument();
        String str=document.getText(0,document.getLength());
        int testPos=str.indexOf("testEntry");
        document.insertString(testPos, "XXXX", null);
        showBean();
        Thread.sleep(1500);
        EnvironmentEntriesTableModel model=(EnvironmentEntriesTableModel) getEnvironmentEntriesPanel().getTable().getModel();
        boolean fail=false;
        if (!"XXXXtestEntry".equals(model.getValueAt(0, 0))) fail=true;
        document.remove(testPos, 4);
        if (fail) fail("change is not propagated");
    }
    
    public void testEnvironmentEntries() throws Exception{
        Thread.sleep(500);
        EnvironmentEntriesTableModel model=(EnvironmentEntriesTableModel) getEnvironmentEntriesPanel().getTable().getModel();
        model.addRow();
        model.setValueAt("testEntry", 0, 0);
        model.setValueAt("true", 0, 2);
        model.setValueAt("test", 0, 3);
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<env-entry-name>testEntry</env-entry-name>");
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
    public void testModifyEnvironmentEntries() throws Exception{
        Thread.sleep(500);
        EnvironmentEntriesTableModel model=(EnvironmentEntriesTableModel) getEnvironmentEntriesPanel().getTable().getModel();        
        model.setValueAt("testEntryModified", 0, 0);
        model.setValueAt("false", 0, 2);
        model.setValueAt("change", 0, 3);
        Utils utils = new Utils(this);
        utils.checkInXML(ddObj, "<env-entry-name>testEntryModified</env-entry-name>");
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
  /*  public void testRemoveEnvironmentEntries() throws Exception{
        Thread.sleep(500);
        EnvironmentEntriesTableModel model=(EnvironmentEntriesTableModel) getEnvironmentEntriesPanel().getTable().getModel();        
        model.removeRow(0);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }*/
    
    public void testResourceReferences() throws Exception{
        
        Thread.sleep(500);
        ResourceReferencesTableModel model=(ResourceReferencesTableModel) getResourceReferencesPanel().getTable().getModel();
        model.addRow("test");
        model.setValueAt("test", 0, 1);
        model.setValueAt(ResourceRef.RES_SHARING_SCOPE_SHAREABLE, 0, 3);
        model.setValueAt("test", 0, 4);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
    public void testModifyResourceReferences() throws Exception{
        
        Thread.sleep(500);
        ResourceReferencesTableModel model=(ResourceReferencesTableModel) getResourceReferencesPanel().getTable().getModel();
        model.setValueAt("test1", 0, 1);
        model.setValueAt(ResourceRef.RES_SHARING_SCOPE_SHAREABLE, 0, 3);
        model.setValueAt("test1", 0, 4);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
    public void testRemoveResourceReferences() throws Exception{
        
        Thread.sleep(5000);
        ResourceReferencesTableModel model=(ResourceReferencesTableModel) getResourceReferencesPanel().getTable().getModel();
        model.removeRow(0);
        Thread.sleep(5000);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
    public void testResourceEnvironmentReferences() throws Exception{        
        Thread.sleep(500);
        ResourceEnvironmentReferencesTableModel model=(ResourceEnvironmentReferencesTableModel) getResourceEnvironmentReferencesPanel().getTable().getModel();
        model.addRow();
        model.setValueAt("test", 0, 0);
        model.setValueAt("test", 0, 1);
        model.setValueAt("test", 0, 2);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
    public void testModifyResourceEnvironmentReferences() throws Exception{        
        Thread.sleep(500);
        ResourceEnvironmentReferencesTableModel model=(ResourceEnvironmentReferencesTableModel) getResourceEnvironmentReferencesPanel().getTable().getModel();
        model.setValueAt("test1", 0, 0);
        model.setValueAt("test1", 0, 1);
        model.setValueAt("test1", 0, 2);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
    public void testRemoveResourceEnvironmentReferences() throws Exception{        
        Thread.sleep(500);
        ResourceEnvironmentReferencesTableModel model=(ResourceEnvironmentReferencesTableModel) getResourceEnvironmentReferencesPanel().getTable().getModel();
        model.removeRow(0);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");
    }
    
    public void testSecurityRoleReferences() throws Exception{        
        Thread.sleep(500);        
        SecurityRoleReferencesTableModel model=(SecurityRoleReferencesTableModel) getSecurityRoleReferencesPanel().getTable().getModel();
        model.addRow();
        model.setValueAt("test", 0, 0);
        model.setValueAt("test", 0, 1);
        model.setValueAt("test", 0, 2);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");        
    }
    
    public void testModifySecurityRoleReferences() throws Exception{        
        Thread.sleep(500);        
        SecurityRoleReferencesTableModel model=(SecurityRoleReferencesTableModel) getSecurityRoleReferencesPanel().getTable().getModel();
        model.setValueAt("test1", 0, 0);
        model.setValueAt("test1", 0, 1);
        model.setValueAt("test1", 0, 2);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");        
    }
    
    public void testRemoveSecurityRoleReferences() throws Exception{        
        Thread.sleep(500);        
        SecurityRoleReferencesTableModel model=(SecurityRoleReferencesTableModel) getSecurityRoleReferencesPanel().getTable().getModel();
        model.removeRow(0);
        Thread.sleep(500);
        Utils utils = new Utils(this);
        utils.save(ddObj);
        assertFile("ejb-jar.xml");        
    }
    
    public void testAddBeanReference() throws Exception {
        EnterpriseBeans eb=ddObj.getEjbJar().getEnterpriseBeans();
        Entity entityA=eb.getEntity(0);
        EjbReferencesTableModel model=(EjbReferencesTableModel) getEjbReferencesPanel().getTable().getModel();        
        Thread.sleep(500);
        JavaClass beanClass = (JavaClass) JMIUtils.resolveType(entityA.getEjbClass());
        Node ejbNode = getEjbNode(beanClass, "EntityBBean");
        EjbReference ref = (EjbReference) ejbNode.getCookie(org.netbeans.modules.j2ee.api.ejbjar.EjbReference.class);
        Thread.sleep(500);        
        org.netbeans.modules.j2ee.ejbcore.Utils.addReference(beanClass, ref, null, true, true, "ejb/Test", project);        
        Thread.sleep(500);
        model.refreshView();
        assertEquals("bad reference name", "ejb/Test", model.getValueAt(0,0));
        assertEquals("bad bean name", "EntityBBean", model.getValueAt(0,1));
        assertEquals("local/remote", "remote", model.getValueAt(0,2));
        Utils utils = new Utils(this);
        assertFile("ejb-jar.xml");
    }
    
    protected Node getEjbNode(JavaClass beanClass, String ejbName) {        
        Project[] allProjects = org.netbeans.modules.j2ee.ejbcore.Utils.getCallableEjbProjects(project);        
        for (int i = 0; i < allProjects.length; i++) {
            LogicalViewProvider lvp =
                    (LogicalViewProvider) allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            Node projectView = lvp.createLogicalView();
            Node [] nodes = projectView.getChildren().getNodes();
            for (int j = 0; j < nodes.length; j++) {
                if ("EJBS".equals(nodes[j].getName())) {
                    Node [] ejbs = nodes[j].getChildren().getNodes();
                    for (int k = 0; k < ejbs.length; k++) {   
                        System.out.println("*** "+ejbs[k].getName());
                        if (ejbName.equals(ejbs[k].getName())) return ejbs[k];
                    }
                }
            }            
        }
        return null;
    }
    
    //open bean's panel in visual editor
    protected void showBean() throws IOException {
        EnterpriseBeans beans = DDProvider.getDefault().getDDRoot(ddFo).getEnterpriseBeans();
        bean = (Entity)beans.findBeanByName(EnterpriseBeans.ENTITY,
                Ejb.EJB_NAME , TEST_BEAN_NAME);        
        ddObj.showElement(bean); 
    }
    
    protected BeanEnvironmentNode getBeanEnvironmentNode(){
        try {
            showBean();
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            Node[] nnChild = Utils.getChildrenNodes(Utils.getEntityNode(ddObj));
            for(int k = 0; k < nnChild.length; k++){
                if(nnChild[k] instanceof BeanEnvironmentNode) {
                    SectionNodePanel envPanel = ((BeanEnvironmentNode)nnChild[k]).getSectionNodePanel();
                    envPanel.open();
                    return (BeanEnvironmentNode) nnChild[k];
                }
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
    
    protected InnerTablePanel getEnvironmentEntriesPanel(){
        Node[] nnChild = Utils.getChildrenNodes(getBeanEnvironmentNode());
        for(int k = 0; k < nnChild.length; k++){
            if(nnChild[k] instanceof EnvironmentEntriesNode) {
                SectionNodePanel environmentPanel = ((EnvironmentEntriesNode)nnChild[k]).getSectionNodePanel();
                environmentPanel.open();
                return (InnerTablePanel) environmentPanel.getInnerPanel();
            }
        }
        return null;
    }
    
    protected InnerTablePanel getResourceReferencesPanel(){
        Node[] nnChild = Utils.getChildrenNodes(getBeanEnvironmentNode());
        for(int k = 0; k < nnChild.length; k++){
            if(nnChild[k] instanceof ResourceReferencesNode) {
                SectionNodePanel resourceReferencesPanel = ((ResourceReferencesNode)nnChild[k]).getSectionNodePanel();
                resourceReferencesPanel.open();
                return (InnerTablePanel) resourceReferencesPanel.getInnerPanel();
            }
        }
        return null;
    }
    
    protected InnerTablePanel getEjbReferencesPanel(){
        Node[] nnChild = Utils.getChildrenNodes(getBeanEnvironmentNode());
        for(int k = 0; k < nnChild.length; k++){
            if(nnChild[k] instanceof EjbReferencesNode) {
                SectionNodePanel ejbReferencesPanel = ((EjbReferencesNode)nnChild[k]).getSectionNodePanel();
                ejbReferencesPanel.open();
                return (InnerTablePanel) ejbReferencesPanel.getInnerPanel();
            }
        }
        return null;
    }
    
    protected InnerTablePanel getResourceEnvironmentReferencesPanel(){
        Node[] nnChild = Utils.getChildrenNodes(getBeanEnvironmentNode());
        for(int k = 0; k < nnChild.length; k++){
            if(nnChild[k] instanceof ResourceEnvironmentReferencesNode) {
                SectionNodePanel reReferencesPanel = ((ResourceEnvironmentReferencesNode)nnChild[k]).getSectionNodePanel();
                reReferencesPanel.open();
                return (InnerTablePanel) reReferencesPanel.getInnerPanel();
            }
        }
        return null;
    }
    
    protected InnerTablePanel getSecurityRoleReferencesPanel(){
        Node[] nnChild = Utils.getChildrenNodes(getBeanEnvironmentNode());
        for(int k = 0; k < nnChild.length; k++){
            if(nnChild[k] instanceof SecurityRoleReferencesNode) {
                SectionNodePanel srReferencesPanel = ((SecurityRoleReferencesNode)nnChild[k]).getSectionNodePanel();
                srReferencesPanel.open();
                return (InnerTablePanel) srReferencesPanel.getInnerPanel();
            }
        }
        return null;
    }

}
