/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.multiview;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import junit.framework.AssertionFailedError;
import org.netbeans.junit.AssertionFailedErrorException;

/**
 *
 * @author blaha
 */
public class TestDocumentListener implements DocumentListener{
    private String findText;

    public TestDocumentListener(String findText){
        this.findText = findText;
    }


    public void removeUpdate(javax.swing.event.DocumentEvent e) {
    }

    public void insertUpdate(javax.swing.event.DocumentEvent e) {
        fireEvent(e);
    }

    public void changedUpdate(javax.swing.event.DocumentEvent e) {
        fireEvent(e);
    }
    
    public void fireEvent(DocumentEvent e) throws RuntimeException{
        try {
            Document document = (Document)e.getDocument();
            String text = document.getText(0,document.getLength());
            int index = text.indexOf(findText);
            if(index<0){ // don't find the text in document
                throw new AssertionFailedError("Cannot find correct element " + findText + "in XML view (editor document)");
            }
            document.removeDocumentListener(this);
            System.out.println("Found text: " + findText + ", index: " + index);
        } catch (javax.swing.text.BadLocationException ex) {
            throw new AssertionFailedErrorException("Failed to read the document: ",ex);
        }
    }
    
}
