/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.refactoring.changesignature;

import java.io.File;
import java.lang.reflect.Modifier;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.refactoring.EjbModConstants;

/**
 *
 * @author jungi
 */

//TODO: put ejbPostCreate somewhere...
public class EjbModTest extends ChangeSignatureTestCase implements EjbModConstants {
    
    private static boolean prjOpened = false;
    
    private static final String METHOD_ACTIVATE = "ejbActivate";
    private static final String[] DUMMY_PARAMS = {};
    private static final String[][] CHANGE_PARAMS_TO
            = new String[][] {{"ab", "java.lang.String", "\"\""}};
    private static final String METHOD_PASIVATE = "ejbPassivate";
    private static final String METHOD_CREATE = "ejbCreate";
    private static final String METHOD_REMOVE = "ejbRemove";
    private static final String METHOD_LOAD = "ejbLoad";
    private static final String METHOD_STORE = "ejbStore";
    private static final String METHOD_SET_SESSION_CONTEXT = "setSessionContext";
    private static final String[] METHOD_SET_SESSION_CONTEXT_PARAMS
            = new String[] {"javax.ejb.SessionContext"};
    private static final String METHOD_SET_ENTITY_CONTEXT = "setEntityContext";
    private static final String[] METHOD_SET_ENTITY_CONTEXT_PARAMS
            = new String[] {"javax.ejb.EntityContext"};
    private static final String METHOD_UNSET_ENTITY_CONTEXT = "unsetEntityContext";
    private static final String METHOD_POST_CREATE = "ejbPostCreate";
    private static final String[] METHOD_POST_CREATE_PARAMS
            = new String[] {"java.lang.String"};
    private static final String METHOD_SET_MESSAGE_DRIVEN_CONTEXT
            = "setMessageDrivenContext";
    private static final String[] METHOD_SET_MESSAGE_DRIVEN_CONTEXT_PARAMS
            = new String[] {"javax.ejb.MessageDrivenContext"};
    private static final String METHOD_ON_MESSAGE = "onMessage";
    private static final String[] METHOD_ON_MESSAGE_PARAMS
            = new String[] {"javax.jms.Message"};
            
    private static final String METHOD_FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    private static final String[] METHOD_FIND_BY_PRIMARY_KEY_PARAMS
            = new String[] {"java.lang.String"};
    
    //_name_Bean, _name_Local, _name_LocalHome, _name_Remote, _name_RemoteHome, MDB
    
    /** Creates a new instance of EjbModTest */
    public EjbModTest(String name) {
        super(name);
    }
    
    public static TestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new EjbModTest("testWebSvcMethods"));
        suite.addTest(new EjbModTest("testStatelessSessionBeanMethods"));
        suite.addTest(new EjbModTest("testTopicMDBMethods"));
        suite.addTest(new EjbModTest("testQueueMDBMethods"));
        suite.addTest(new EjbModTest("testCMPEntityBeanMethods"));
        return suite;
    }
    
    public void testStatelessSessionBeanMethods() {
        checkSessionLCMethods(CLASS_SESSION_1);
        changeSignature(CLASS_SESSION_1, METHOD_CREATE,
                DUMMY_PARAMS, CHANGE_PARAMS_TO,
                Modifier.PUBLIC, false);
    }
    
    public void testWebSvcMethods() {
        //same as stateless session bean:
        checkSessionLCMethods(CLASS_WS_1);
        //user should not be able to change ejbCreate method in this case:
        changeSignature(CLASS_WS_1, METHOD_CREATE,
                DUMMY_PARAMS, CHANGE_PARAMS_TO,
                Modifier.PUBLIC, false);
    }
    
    public void testTopicMDBMethods() {
        checkMdbLCMethods(MDB_TOPIC);
    }
    
    public void testQueueMDBMethods() {
        checkMdbLCMethods(MDB_QUEUE);
    }

    public void testCMPEntityBeanMethods() {
        checkCMPEntityLCMethods(CLASS_CMP_ENTITY_4);
    }
    
    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

    public void prepareProject() {
        if (prjOpened) {
            return;
        }
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-util"));
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-ejb"));
        classPathWorkDir = new File(getDataDir(), "projects.League-ejb.src.java".replace('.', File.separatorChar));
        prjOpened = true;
    }
    
    private void checkSessionLCMethods(String ejbName) {
        changeSignature(ejbName, METHOD_ACTIVATE, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(ejbName, METHOD_PASIVATE, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(ejbName, METHOD_REMOVE, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(ejbName, METHOD_SET_SESSION_CONTEXT,
                METHOD_SET_SESSION_CONTEXT_PARAMS, CHANGE_PARAMS_TO,
                Modifier.PUBLIC, false);
    }
     
    private void checkMdbLCMethods(String mdbName) {
        changeSignature(mdbName, METHOD_REMOVE, DUMMY_PARAMS, 
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(mdbName, METHOD_SET_MESSAGE_DRIVEN_CONTEXT,
                METHOD_SET_MESSAGE_DRIVEN_CONTEXT_PARAMS, CHANGE_PARAMS_TO,
                Modifier.PUBLIC, false);
        changeSignature(mdbName, METHOD_ON_MESSAGE, METHOD_ON_MESSAGE_PARAMS, 
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(mdbName, METHOD_CREATE, DUMMY_PARAMS, 
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
    }
    
    private void checkCMPEntityLCMethods(String cmpName) {
        changeSignature(cmpName, METHOD_ACTIVATE, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(cmpName, METHOD_PASIVATE, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(cmpName, METHOD_REMOVE, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(cmpName, METHOD_SET_ENTITY_CONTEXT,
                METHOD_SET_ENTITY_CONTEXT_PARAMS, CHANGE_PARAMS_TO,
                Modifier.PUBLIC, false);
        changeSignature(cmpName, METHOD_UNSET_ENTITY_CONTEXT, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(cmpName, METHOD_LOAD, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
        changeSignature(cmpName, METHOD_STORE, DUMMY_PARAMS,
                CHANGE_PARAMS_TO, Modifier.PUBLIC, false);
    }
}
