/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.refactoring.changesignature;

import java.io.File;
import java.lang.reflect.Modifier;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.refactoring.WebAppConstants;

/**
 * Find Usages simple tests
 * @author  jungi
 */
public class WebAppTest extends ChangeSignatureTestCase implements WebAppConstants {

    private static boolean prjOpened = false;

    /** Creates a new instance of Signature1Test */
    public WebAppTest(String name) {
        super(name);
    }
    
    public static TestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new WebAppTest("testWsOperation"));
        //suite.addTest(new WebAppTest("testServlet"));
        return suite;
    }
    
    public void testWsOperation() {
        changeSignature(CLASS_NAME_1 , "callOtherWs", new String[0],
                new String[][] {{"s", "java.lang.String", "\"\""}},
                Modifier.PUBLIC, false);
    }
    
    public void testServlet() {
        String[] params = {"javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"};
        String[][] newParams = {
            {"request", "javax.servlet.http.HttpServletRequest", "request"},
            {"response", "javax.servlet.http.HttpServletResponse", "response"},
            {"par", "Object", "null"},
        };
        changeSignature(CLASS_NAME_2, "processRequest", params, newParams,
                Modifier.PROTECTED, false);
    }
    
    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    public void prepareProject() {
        if (prjOpened) {
            return;
        }
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/LoggingWS"));
        classPathWorkDir = new File(getDataDir(), "projects.LoggingWS.src.java".replace('.', File.separatorChar));
        prjOpened = true;
    }
    
}
