/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.refactoring.move;

import java.io.File;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.refactoring.EjbModConstants;

/**
 *
 * @author jungi
 */
public class EjbModTest extends MoveTestCase implements EjbModConstants {
    
    private static boolean prjOpened = false;
    
    //_name_Bean, _name_Local, _name_LocalHome, _name_Remote, _name_RemoteHome, MDB
    
    /** Creates a new instance of EjbModTest */
    public EjbModTest(String name) {
        super(name);
    }
    
    public static TestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new EjbModTest("testMoveWsSei"));
        suite.addTest(new EjbModTest("testMoveWsImpl"));
        suite.addTest(new EjbModTest("testMoveSessionBean"));
        suite.addTest(new EjbModTest("testMoveSessionBeanRemote"));
        suite.addTest(new EjbModTest("testMoveSessionBeanRemoteHome"));
        suite.addTest(new EjbModTest("testMoveUsedHandler"));
        suite.addTest(new EjbModTest("testMoveUnusedHandler"));
        suite.addTest(new EjbModTest("testMoveCMPEntityBean"));
        suite.addTest(new EjbModTest("testMoveCMPEntityBeanLocal"));
        suite.addTest(new EjbModTest("testMoveCMPEntityBeanLocalHome"));
        suite.addTest(new EjbModTest("testMoveTopicMdb"));
        /*
        suite.addTest(new EjbModTest("testUndoMoveWsSei"));
        suite.addTest(new EjbModTest("testUndoMoveWsImpl"));
        suite.addTest(new EjbModTest("testUndoMoveSessionBean"));
        suite.addTest(new EjbModTest("testUndoMoveUsedHandler"));
        suite.addTest(new EjbModTest("testUndoMoveUnusedHandler"));
        suite.addTest(new EjbModTest("testUndoMoveQueueMdb"));
         */
        return suite;
    }
    
    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    public void prepareProject() {
        if (prjOpened) {
            return;
        }
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-util"));
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-ejb"));
        classPathWorkDir = new File(getDataDir(), "projects.League-ejb.src.java".replace('.', File.separatorChar));
        prjOpened = true;
    }
    
    public void testMoveWsSei() {
        moveClass(INTERFACE_WS_1, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveWsImpl() {
        moveClass(CLASS_WS_1, DESTINATION_PACKAGE_2, false);
    }
    
    public void testMoveSessionBean() {
        moveClass(CLASS_SESSION_1, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveSessionBeanRemote() {
        moveClass(INTERFACE_SESSION_REMOTE_1, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveSessionBeanRemoteHome() {
        moveClass(INTERFACE_SESSION_REMOTE_HOME_1, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveUsedHandler() {
        moveClass(CLASS_HANDLER_1, DESTINATION_PACKAGE_2, false);
    }
    
    public void testMoveUnusedHandler() {
        moveClass(CLASS_HANDLER_2, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveCMPEntityBean() {
        moveClass(CLASS_CMP_ENTITY_1, DESTINATION_PACKAGE_2, false);
    }
    
    public void testMoveCMPEntityBeanLocal() {
        moveClass(INTERFACE_CMP_ENTITY_LOCAL_2, DESTINATION_PACKAGE_1, false);
    }
    
    public void testMoveCMPEntityBeanLocalHome() {
        moveClass(INTERFACE_CMP_ENTITY_LOCAL_HOME_3, DESTINATION_PACKAGE_2, false);
    }
    
    public void testMoveTopicMdb() {
        moveClass(MDB_TOPIC, DESTINATION_PACKAGE_1, false);
    }
    
    public void testUndoMoveQueueMdb() {
        moveClass(MDB_QUEUE, DESTINATION_PACKAGE_2, false);
    }
    
    //undo
    public void testUndoMoveWsSei() {
        moveClass(INTERFACE_WS_1, DESTINATION_PACKAGE_1, true);
    }
    
    public void testUndoMoveWsImpl() {
        moveClass(CLASS_WS_1, DESTINATION_PACKAGE_2, true);
    }
    
    public void testUndoMoveSessionBean() {
        moveClass(CLASS_SESSION_1, DESTINATION_PACKAGE_1, true);
    }
    
    public void testUndoMoveUsedHandler() {
        assertTrue("See issue 59611.", false);
        moveClass(CLASS_HANDLER_1, DESTINATION_PACKAGE_2, true);
    }
    
    public void testUndoMoveUnusedHandler() {
        moveClass(CLASS_HANDLER_2, DESTINATION_PACKAGE_1, true);
    }
    
    
}
