/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.j2ee.refactoring.usages;

import java.io.File;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.lib.J2eeProjectSupport;
import org.netbeans.test.j2ee.refactoring.EjbModConstants;

/**
 *
 * @author jungi
 */
public class EjbModTest extends WhereUsedTestCase implements EjbModConstants {
    
    private static boolean prjOpened = false;
    
    //_name_Bean, _name_Local, _name_LocalHome, _name_Remote, _name_RemoteHome, MDB
    
    /** Creates a new instance of EjbModTest */
    public EjbModTest(String name) {
        super(name);
    }
    
    public static TestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new EjbModTest("testInterface"));
        suite.addTest(new EjbModTest("testInterfaceParams"));
        suite.addTest(new EjbModTest("testClass"));
        suite.addTest(new EjbModTest("testClassParams"));
        suite.addTest(new EjbModTest("testMsgHandler"));
        return suite;
    }
    
    /**
     * Used for running test from inside the IDE by internal execution.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

    public void prepareProject() {
        if (prjOpened) {
            return;
        }
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-util"));
        J2eeProjectSupport.openProject(new File(getDataDir(), "projects/League-ejb"));
        classPathWorkDir = new File(getDataDir(), "projects.League-ejb.src.java".replace('.', File.separatorChar));
        prjOpened = true;
    }

    public void testClass() {
        findClass(CLASS_WS_1);
        findClass(CLASS_SESSION_1);
        findClass(CLASS_CMP_ENTITY_1);
        findClass(CLASS_CMP_ENTITY_2);
        findClass(MDB_QUEUE);
        try {
            findClass("com.foo.bar.Ab");
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing class was found!");
    }
    
    public void testClassParams() {
        findClassParams(CLASS_JAVA_1, CLASS_USAGES);
        findClassParams(CLASS_JAVA_2, CLASS_USAGES);
        findClassParams(CLASS_WS_1, CLASS_USAGES);
        findClassParams(CLASS_SESSION_1, CLASS_USAGES);
        findClassParams(CLASS_CMP_ENTITY_3, CLASS_USAGES);
        findClassParams(CLASS_CMP_ENTITY_4, CLASS_USAGES);
        findClassParams(CLASS_CMP_ENTITY_5, CLASS_USAGES);
        findClassParams(MDB_TOPIC, CLASS_USAGES);
        try {
            findClassParams("com.foo.bar.XY", CLASS_USAGES);
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing class was found!");
    }
    
    public void testInterface() {
        findClass(INTERFACE_CMP_ENTITY_LOCAL_1);
        findClass(INTERFACE_CMP_ENTITY_LOCAL_2);
        findClass(INTERFACE_CMP_ENTITY_LOCAL_3);
        findClass(INTERFACE_CMP_ENTITY_LOCAL_HOME_1);
        findClass(INTERFACE_CMP_ENTITY_LOCAL_HOME_2);
        findClass(INTERFACE_CMP_ENTITY_LOCAL_HOME_3);
        findClass(INTERFACE_SESSION_REMOTE_1);
        findClass(INTERFACE_SESSION_REMOTE_HOME_1);
        findClass(INTERFACE_WS_1);
        try {
            findClass("com.foo.bar.Ij");
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing interface was found!");
    }
    
    public void testInterfaceParams() {
        findClassParams(INTERFACE_CMP_ENTITY_LOCAL_4, CLASS_USAGES);
        findClassParams(INTERFACE_CMP_ENTITY_LOCAL_5, CLASS_USAGES);
        findClassParams(INTERFACE_CMP_ENTITY_LOCAL_HOME_4, CLASS_USAGES);
        findClassParams(INTERFACE_CMP_ENTITY_LOCAL_HOME_5, CLASS_USAGES);
        findClassParams(INTERFACE_SESSION_REMOTE_1, CLASS_USAGES);
        findClassParams(INTERFACE_SESSION_REMOTE_HOME_1, CLASS_USAGES);
        findClassParams(INTERFACE_WS_1, CLASS_USAGES);
        try {
            findClassParams("com.foo.bar.Iss", CLASS_USAGES);
        } catch (IllegalStateException ise) {
            ref("");
            ref(ise.getMessage());
            ref("");
            return;
        }
        fail("Non existing interface was found!");
    }
    
    public void testMsgHandler() {
        findClassParams(CLASS_HANDLER_1, CLASS_USAGES);
        findClass(CLASS_HANDLER_2);
    }

}
