/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.ws;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.api.project.Project;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.NewFileNameLocationStepOperator;
import org.netbeans.jellytools.OutputTabOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;
import org.netbeans.test.j2ee.AppServerTest;
import org.netbeans.test.j2ee.wizard.WizardUtils;

/**
 *  Basic validation suite for web services support in the IDE
 *
 * @author lukas.jungmann@sun.com
 */
public class WsValidation extends JellyTestCase {
    
    private static final String WEB_SERVICES_NODE_NAME
            = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.jaxws.nodes.Bundle", "LBL_WebServices");
    
    private static final String WEB_SERVICE_CLIENTS_NODE_NAME
            = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.jaxws.nodes.Bundle", "LBL_ServiceReferences");
    
    private static final String TARGET_SERVER_NAME = "Application Server"; //NOI18N
    
    private static File projectHome;
    
    /** Creates a new instance of WsValidation */
    public WsValidation(String name) {
        super(name);
    }
    
    /**
     *  Creates a sample web project and checks whether the project has been created
     * @throws java.io.IOException
     */
    public void createWsProjectOnGlassFish() throws IOException {
        // close Welcome screen
        // "Welcome
        String welcomeTitle = Bundle.getString("org.netbeans.modules.welcome.Bundle", "LBL_Tab_Title");
        new TopComponentOperator(welcomeTitle).close();
        final String projectName = "WsInWebGlassFish";//NOI18N
        assertNull(projectHome);
        projectHome = new File(getWorkDir(), projectName); //NOI18N
        //"Web"
        String webLabel = Bundle.getStringTrimmed("org.netbeans.modules.web.project.ui.wizards.Bundle", "Templates/Project/Web");
        //"Web Application"
        String webApplicationLabel = Bundle.getStringTrimmed("org.netbeans.modules.web.project.ui.wizards.Bundle", "Templates/Project/Web/emptyWeb.xml");
        WizardUtils.createNewProject(webLabel, webApplicationLabel);
        WizardUtils.setProjectNameLocation(projectName, projectHome.getParentFile().getAbsolutePath()).finish(); //NOI18N
        waitForProjectOpening(projectName);
    }
    
    /**
     * Creates a new web service in a web project and checks whether web service
     * node has been created in the project view and web service implementation
     * class has been opened in the editor
     * @throws java.io.IOException
     */
    public void createNewWs() throws IOException {
        final String wsName = "MyWebService"; //NOI18N
        final String wsPkgName = "org.mycompany.websvc"; //NOI18N
        final String projectName = "WsInWebGlassFish"; //NOI18N
        ProjectRootNode node = ProjectsTabOperator.invoke().getProjectRootNode(projectName);
        Project p = (Project) ((org.openide.nodes.Node) node.getOpenideNode()).getLookup().lookup(Project.class);
        assertNotNull("Project can't be null", p); //NOI18N
        //Web Services
        String webServicesLabel = Bundle.getStringTrimmed("org.netbeans.modules.websvc.dev.wizard.Bundle", "Templates/WebServices");
        //Web Service
        String webServiceLabel = Bundle.getStringTrimmed("org.netbeans.modules.websvc.dev.wizard.Bundle", "Templates/WebServices/WebService.java");
        WizardUtils.createNewFile(p, webServicesLabel, webServiceLabel);
        WizardUtils.setFileNameLocation(wsName, wsPkgName, null).finish(); //NOI18N
        // needed for slower machines
        JemmyProperties.setCurrentTimeout("JTreeOperator.WaitNextNodeTimeout", 30000); //NOI18N
        //TODO: following nodes should be expanded by default - this test should check it as well
        Node wsRootNode = new Node(node, WEB_SERVICES_NODE_NAME);
        wsRootNode.expand();
        Node wsImplNode = new Node(wsRootNode, wsName);
        wsImplNode.expand();
        new EditorOperator(wsName);
    }
    
    /**
     * Tests adding operation to webservice using
     * - add operation action from editor's popup menu
     * - add operation action from ws node's context menu
     */
    public void addOperation() {
        final EditorOperator eo = new EditorOperator("MyWebService"); //NOI18N
        eo.select(20);
        String actionGroupName = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_WebServiceActionGroup");
        String actionName = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "LBL_OperationAction");
        new ActionNoBlock(null, actionGroupName + "|" + actionName).performPopup(eo);
        NbDialogOperator dialog = new NbDialogOperator(Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "TTL_AddOperation"));
        new JTextFieldOperator(dialog).setText("myStringMethod"); //NOI18N
        new JTextFieldOperator(dialog,1).setText("String"); //NOI18N
        dialog.ok();
        eo.save();
        waitForTextInEditor(eo, "myStringMethod"); //NOI18N
        final String wsName = "MyWebService"; //NOI18N
        final String projectName = "WsInWebGlassFish"; //NOI18N
        ProjectRootNode node = new ProjectsTabOperator().getProjectRootNode(projectName);
        Node wsRootNode = new Node(node, WEB_SERVICES_NODE_NAME);
        wsRootNode.expand();
        Node wsImplNode = new Node(wsRootNode, wsName);
        wsImplNode.callPopup().pushMenuNoBlock(actionName);
        dialog = new NbDialogOperator(Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.webservices.action.Bundle", "TTL_AddOperation"));
        new JTextFieldOperator(dialog).setText("myIntMethod"); //NOI18N
        new JTextFieldOperator(dialog,1).setText("int[]"); //NOI18N
        dialog.ok();
        eo.save();
        waitForTextInEditor(eo, "myIntMethod"); //NOI18N
//      wsImplNode.expand();
//      assertTrue(wsImplNode.isChildPresent("myMethod")); //NOI18N
//      assertTrue(wsImplNode.isChildPresent("myMethod2")); //NOI18N
        eo.close(true);
    }
    
    /**
     * Deploys a project
     */
    public void deployProject() throws IOException {
        ProjectRootNode node = new ProjectsTabOperator().getProjectRootNode(projectHome.getName());
        String deployProjectLabel = Bundle.getStringTrimmed("org.netbeans.modules.web.project.ui.Bundle", "LBL_RedeployAction_Name");
        node.performPopupAction(deployProjectLabel);
        OutputTabOperator oto = new OutputTabOperator(projectHome.getName());
        JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", 60000); //NOI18N
        oto.waitText("(total time: "); //NOI18N
        assertTrue(oto.getText().indexOf("BUILD SUCCESSFUL") > -1); //NOI18N
    }
    
    /**
     *  Creates a sample web project and checks whether the project has been created
     * @throws java.io.IOException
     */
    public void createWsClientProjectOnGlassFish() throws IOException {
        final String projectName = "WsClientInWebGlassFish"; //NOI18N
        projectHome = new File(getWorkDir(), projectName);
        assertFalse("Project directory[" + projectHome.getAbsolutePath() + "] exists and is not empty", projectHome.exists() && projectHome.list().length > 0); //NOI18N
        //"Web"
        String webLabel = Bundle.getStringTrimmed("org.netbeans.modules.web.project.ui.wizards.Bundle", "Templates/Project/Web");
        //"Web Application"
        String webApplicationLabel = Bundle.getStringTrimmed("org.netbeans.modules.web.project.ui.wizards.Bundle", "Templates/Project/Web/emptyWeb.xml");
        WizardUtils.createNewProject(webLabel, webApplicationLabel);
        WizardUtils.setProjectNameLocation(projectName, projectHome.getParentFile().getAbsolutePath()).finish();
        waitForProjectOpening(projectName);
    }
    
    /**
     * Creates a new web service client in a web project and checks whether web
     * service client node has been created in the project view
     * @throws java.io.IOException
     */
    public void createNewWsClient() throws IOException {
        ProjectRootNode node = new ProjectsTabOperator().getProjectRootNode(projectHome.getName());
        Project p = (Project) ((org.openide.nodes.Node) node.getOpenideNode()).getLookup().lookup(Project.class);
        assertNotNull("Project can't be null", p); //NOI18N
        //Web Services
        String webServicesLabel = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.client.wizard.Bundle", "Templates/WebServices");
        //Web Service Client
        String webServiceClientLabel = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.client.wizard.Bundle", "Templates/WebServices/WebServiceClient");
        WizardUtils.createNewFile(p, webServicesLabel, webServiceClientLabel);
        NewFileNameLocationStepOperator op = new NewFileNameLocationStepOperator();
        new JButtonOperator(op, 3).push();
        NbDialogOperator ndo = new NbDialogOperator(Bundle.getStringTrimmed(
                "org.netbeans.modules.websvc.core.client.wizard.Bundle", "TTL_SelectService"));
        JTreeOperator jto = new JTreeOperator(ndo);
        jto.selectPath(jto.findPath("WsInWebGlassFish|MyWebService")); //NOI18N
        ndo.ok();
        new JComboBoxOperator(op, 0).typeText("org.mycompany.websvc.client"); //NOI18N
        op.finish();
        //expand ws client node
        Node wsClientRootNode = new Node(node, WEB_SERVICE_CLIENTS_NODE_NAME);
        wsClientRootNode.expand();
        Node wsClientNode = new Node(wsClientRootNode, "MyWebService"); //NOI18N
        wsClientNode.expand();
        Node wsClientServiceNode = new Node(wsClientNode, "MyWebService"); //NOI18N
        wsClientServiceNode.expand();
        Node wsClientPortNode = new Node(wsClientServiceNode, "MyWebService"); //NOI18N
        wsClientPortNode.expand();
        assertTrue(wsClientPortNode.isChildPresent("myStringMethod")); //NOI18N
        assertTrue(wsClientPortNode.isChildPresent("myIntMethod")); //NOI18N
        assertEquals(wsClientPortNode.getChildren().length, 2);
        OutputTabOperator oto = new OutputTabOperator("(wsimport-client-compile)"); //NOI18N
        oto.waitText("(total time: "); //NOI18N
        assertTrue(oto.getText().indexOf("BUILD SUCCESSFUL") > -1); //NOI18N
    }
    
    /**
     * Tests Call Web Service Operation action in a servlet
     */
    public void callWsOperationInServlet() {
        //create a servlet
        ProjectRootNode node = new ProjectsTabOperator().getProjectRootNode(projectHome.getName());
        Project p = (Project) ((org.openide.nodes.Node) node.getOpenideNode()).getLookup().lookup(Project.class);
        assertNotNull("Project can't be null", p); //NOI18N
        //Web
        String webLabel = Bundle.getStringTrimmed("org.netbeans.modules.web.core.Bundle", "Templates/JSP_Servlet");
        //Servlet
        String servletLabel = Bundle.getStringTrimmed("org.netbeans.modules.web.core.Bundle", "Templates/JSP_Servlet/Servlet.java");
        WizardUtils.createNewFile(p, webLabel, servletLabel);
        NewFileNameLocationStepOperator op = new NewFileNameLocationStepOperator();
        JComboBoxOperator jcbo = new JComboBoxOperator(op, 1);
        jcbo.typeText("org.mycompany.servlets"); //NOI18N
        op.finish();
        //edit code in the servlet
        EditorOperator eo = new EditorOperator("NewServlet"); //NOI18N
        eo.deleteLine(30);
        eo.deleteLine(38);
        eo.setCaretPosition(35, 89);
        eo.insert("\n\t"); //NOI18N
        eo.select(36);
        //Call Web Service Operation action
        String actionGroupName = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.client.actions.Bundle", "LBL_WSClientResources");
        String actionName = Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.client.actions.Bundle", "LBL_CallWebServiceOperation");
        new ActionNoBlock(null, actionGroupName + "|" + actionName).performPopup(eo);
        NbDialogOperator ndo = new NbDialogOperator(Bundle.getStringTrimmed("org.netbeans.modules.websvc.core.client.actions.Bundle", "TTL_SelectOperation"));
        JTreeOperator jto = new JTreeOperator(ndo);
        jto.selectPath(jto.findPath("WsClientInWebGlassFish|MyWebServiceService|MyWebServiceService|MyWebServicePort|myIntMethod")); //NOI18N
        ndo.ok();
        waitForTextInEditor(eo, "port.myIntMethod()");
    }
    
    /**
     * Starts a server
     */
    public void startServer() {
        J2eeServerNode serverNode = J2eeServerNode.invoke(TARGET_SERVER_NAME);
        JemmyProperties.setCurrentTimeout("Waiter.WaitingTime", 120000);
        serverNode.start();
    }
    
    /**
     * Cleanup method - undeploys projects deployed by this suite
     */
    public void undeployProjects() throws IOException {
        //TODO: I18N
        //Note: this part is GlassFish specific for now
        assertEquals("Unsupported server", TARGET_SERVER_NAME, "Application Server"); //NOI18N
        J2eeServerNode serverNode = J2eeServerNode.invoke(TARGET_SERVER_NAME);
        serverNode.expand();
        Node webappsNode = new Node(serverNode, "Applications|Web Applications");
        webappsNode.expand();
        webappsNode.callPopup().pushMenu("Refresh");
        if (webappsNode.isChildPresent("WsInWebGlassFish")) {
            Node n = new Node(webappsNode, "WsInWebGlassFish");
            n.callPopup().pushMenu("Undeploy");
            new EventTool().waitNoEvent(2000);
        };
        webappsNode.callPopup().pushMenu("Refresh");
        if (webappsNode.isChildPresent("WsClientInWebGlassFish")) {
            Node n = new Node(webappsNode, "WsClientInWebGlassFish");
            n.callPopup().pushMenu("Undeploy");
            new EventTool().waitNoEvent(2000);
        };
        webappsNode.callPopup().pushMenu("Refresh");
        new EventTool().waitNoEvent(2000);
    }
    
    /**
     * Stops a server
     */
    public void stopServer() {
        J2eeServerNode serverNode = J2eeServerNode.invoke(TARGET_SERVER_NAME);
        JemmyProperties.setCurrentTimeout("Waiter.WaitingTime", 60000);
        serverNode.stop();
        new EventTool().waitNoEvent(2000);
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite();
        suite.addTest(new AppServerTest("testWaitAppServerInstall")); //NOI18N
        suite.addTest(new WsValidation("createWsProjectOnGlassFish")); //NOI18N
        suite.addTest(new WsValidation("createNewWs")); //NOI18N
        suite.addTest(new WsValidation("addOperation")); //NOI18N
        suite.addTest(new WsValidation("startServer")); //NOI18N
        suite.addTest(new WsValidation("deployProject")); //NOI18N
        suite.addTest(new WsValidation("createWsClientProjectOnGlassFish")); //NOI18N
        suite.addTest(new WsValidation("createNewWsClient")); //NOI18N
        suite.addTest(new WsValidation("callWsOperationInServlet")); //NOI18N
        suite.addTest(new WsValidation("deployProject")); //NOI18N
        suite.addTest(new WsValidation("undeployProjects")); //NOI18N
        suite.addTest(new WsValidation("stopServer")); //NOI18N
        return suite;
    }
    
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    private void waitForProjectOpening(String projectName) {
        // Opening Projects
        String  openingProjectsTitle= Bundle.getString("org.netbeans.modules.project.ui.Bundle", "LBL_Opening_Projects_Progress");
        try {
            // wait at most 60 second until progress dialog dismiss
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", 60000); //NOI18N
            new NbDialogOperator(openingProjectsTitle).waitClosed();
        } catch (TimeoutExpiredException e) {
            // ignore when progress dialog was closed before we started to wait for it
        }
        // wait project appear in projects view
        new ProjectsTabOperator().getProjectRootNode(projectName);
        // wait classpath scanning finished
        ProjectSupport.waitScanFinished();
    }
    
    private void waitForTextInEditor(final EditorOperator eo,final String text) {
        try {
            new Waiter(new Waitable() {
                public Object actionProduced(Object obj) {
                    return eo.contains(text) ? Boolean.TRUE : null; //NOI18N
                }
                public String getDescription() {
                    return("Editor contains " + text); // NOI18N
                }
            }).waitAction(null);
        } catch (InterruptedException ie) {
            throw new JemmyException("Interrupted.", ie); //NOI18N
        }
    }    
}
