/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes;

import java.awt.Image;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.openide.cookies.OpenCookie;

/**
 * This interfaces provides a strategy for working with component methods. 
 * @author  rico
 * @author Chris Webster
 */
public interface ComponentMethodViewStrategy {
    
  /**
   * Get the badge for the MethodElement (if any) depending on its presence in the interfaces
   * @param me MethodElement from one of the interfaces in the collection
   * @param interfaces Collection of ClassElements (interfaces), one of which has me
   * @return Image of the appropriate badge or null 
   */  
  public Image getBadge(Method me, Collection interfaces);
  
  /**
   * Get the icon for the MethodElement. The general implementation of this
   * method determines the icon based on the interface the method is present in
   * along with the signature. 
   * @param me MethodElement from one of the collection intefaces
   * @param interfaces <code>ClassElement</code>'s which represent the client
   * view of a component. 
   * @return Image, this method should not return null
   */
  public Image getIcon(Method me, Collection interfaces);
  
  /**
   * Delete the method from the implementation class
   * @param me MethodElement from one of the interfaces in the collection
   * @param implClass Implementation class where the corresponding method will be deleted
   * @param interfaces Collection of ClassElements (interfaces), one of which has me
   */
  public void deleteImplMethod(Method me, JavaClass implClass, Collection interfaces) throws IOException;
  
  /**
   * Get the OpenCookie of the MethodElement in the implementation class
   * @param me MethodElement from one of the interfaces in the collection
   * @param implClass Implementation class where the corresponding method will be opened
   * @param interfaces Collection of ClassElements (interfaces), one of which has me
   * @return The OpenCookie of the corresponding method in the implementation class implClass.
   */
  public OpenCookie getOpenCookie(Method me, JavaClass implClass, Collection interfaces); 
}
