/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes;

import java.util.ResourceBundle;

import javax.swing.*;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;

import org.openide.*;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;

/** Customizer for FieldElement
 *
 * @author Petr Hamernik
 */
public class FieldCustomizer extends JPanel {
    /** Source of the localized human presentable strings. */
    static ResourceBundle bundle = NbBundle.getBundle(FieldCustomizer.class);

    /** The edited field */
    Field element;

    /** Predefined types in the type combo */
    public static final String[] COMMON_TYPES = {
        "String", // NOI18N
        "boolean", // NOI18N
        "char", // NOI18N
        "int", // NOI18N
        "long", // NOI18N
        "byte", // NOI18N
        "short", // NOI18N
        "float", // NOI18N
        "double" // NOI18N
    };
    
    boolean isOK = true;

    /**
     * Create new FieldCustomizer component
     *
     * @param element      The field to be customized
     * @param description
     * @param localGetter
     * @param localSetter
     * @param remoteGetter
     * @param remoteSetter
     */
    public FieldCustomizer(Field element, String description, boolean localEnabled, boolean remoteEnabled,
            boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter) {

        this.element = element;

        initComponents();

        descriptionTextField.setText(description);
        localGetterCheckBox.setEnabled(localEnabled);
        localSetterCheckBox.setEnabled(localEnabled);
        remoteGetterCheckBox.setEnabled(remoteEnabled);
        remoteSetterCheckBox.setEnabled(remoteEnabled);
        localGetterCheckBox.setSelected(localGetter && localEnabled);
        localSetterCheckBox.setSelected(localSetter && localEnabled);
        remoteGetterCheckBox.setSelected(remoteGetter && remoteEnabled);
        remoteSetterCheckBox.setSelected(remoteSetter && remoteEnabled);

        nameTextField.setText(element.getName().toString());

        Type type = element.getType();
        if (type != null) {
            typeCombo.setSelectedItem(type.getName());
        }

        initAccessibility();
    }

    public void addNotify() {
        super.addNotify();

        // select the name
        int l = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(l);
        nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        descriptionLabel = new javax.swing.JLabel();
        descriptionTextField = new javax.swing.JTextField();
        typeLabel = new javax.swing.JLabel();
        typeCombo = new javax.swing.JComboBox(COMMON_TYPES);
        addToLocalLabel = new javax.swing.JLabel();
        localGetterCheckBox = new javax.swing.JCheckBox();
        localSetterCheckBox = new javax.swing.JCheckBox();
        addToRemoteLabel = new javax.swing.JLabel();
        remoteGetterCheckBox = new javax.swing.JCheckBox();
        remoteSetterCheckBox = new javax.swing.JCheckBox();
        spacerLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 6, 6)));
        nameLabel.setLabelFor(nameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Name_"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 8, 0, 8);
        add(nameLabel, gridBagConstraints);

        nameTextField.setColumns(30);
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 8);
        add(nameTextField, gridBagConstraints);
        nameTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Name_AD"));

        descriptionLabel.setLabelFor(descriptionTextField);
        org.openide.awt.Mnemonics.setLocalizedText(descriptionLabel, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Description"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 8);
        add(descriptionLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 8);
        add(descriptionTextField, gridBagConstraints);
        descriptionTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Description_AD"));

        typeLabel.setLabelFor(typeCombo);
        org.openide.awt.Mnemonics.setLocalizedText(typeLabel, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Type"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 8);
        add(typeLabel, gridBagConstraints);

        typeCombo.setEditable(true);
        typeCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 8);
        add(typeCombo, gridBagConstraints);
        typeCombo.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Type_AD"));

        org.openide.awt.Mnemonics.setLocalizedText(addToLocalLabel, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "LBL_AddToLocalInterface"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(16, 8, 0, 8);
        add(addToLocalLabel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(localGetterCheckBox, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Getter_Local"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 16, 0, 16);
        add(localGetterCheckBox, gridBagConstraints);
        localGetterCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Getter_Local_AN"));
        localGetterCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Getter_Local_AD"));

        org.openide.awt.Mnemonics.setLocalizedText(localSetterCheckBox, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Setter_Local"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 16, 0, 16);
        add(localSetterCheckBox, gridBagConstraints);
        localSetterCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Setter_Local_AN"));
        localSetterCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Setter_Local_AD"));

        org.openide.awt.Mnemonics.setLocalizedText(addToRemoteLabel, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "LBL_AddToRemoteInterface"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(16, 8, 0, 8);
        add(addToRemoteLabel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(remoteGetterCheckBox, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Getter_Remote"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 16, 0, 16);
        add(remoteGetterCheckBox, gridBagConstraints);
        remoteGetterCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Getter_Remote_AN"));
        remoteGetterCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Getter_Remote_AD"));

        org.openide.awt.Mnemonics.setLocalizedText(remoteSetterCheckBox, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Setter_Remote"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 16, 0, 16);
        add(remoteSetterCheckBox, gridBagConstraints);
        remoteSetterCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Setter_Remote_AN"));
        remoteSetterCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "Setter_Remote_AD"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(spacerLabel, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void jComboBox1ActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        Object selItem = typeCombo.getSelectedItem();
        Type oldValue = element.getType();
        boolean ok = false;

        if (selItem != null) {
            try {
                final Type newValue = JMIUtils.resolveType((String) typeCombo.getSelectedItem());
                if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
                    return;
                } else {
                    element.setType(newValue);
                    ok = true;
                }
            } catch (IllegalArgumentException e) {
                ErrorManager.getDefault().annotate(
                        e, ErrorManager.USER, null,
                        bundle.getString("MSG_Not_Valid_Type"),
                        null, null);
                ErrorManager.getDefault().notify(e);
            }
        }
        isOK = ok;
        if (!ok)
            typeCombo.setSelectedItem(oldValue.toString());
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if (evt != null && evt.isTemporary()) {
            return;
        }

        String newName = nameTextField.getText();
        String oldName = element.getName().toString();
        if (!oldName.equals(newName)) {
            Exception x = validateFieldName(newName);
            if (x == null) {
                element.setName(newName);
            }
            if (x != null) {
                isOK = false;
                nameTextField.setText(oldName);
                ErrorManager.getDefault().notify(x);
            } else {
                isOK = true;
            }
        }
    }//GEN-LAST:event_nameTextFieldFocusLost

    public static IllegalArgumentException validateFieldName(String newName) {
        String messageId;
        if (Utilities.isJavaIdentifier(newName)) {
            if (Character.isLowerCase(newName.charAt(0))) {
                messageId = null;
            } else {
                messageId = "MSG_Field_Starts_Upper"; // NOI18N 
            }
        } else {
            messageId = "MSG_Not_Valid_Identifier"; // NOI18N
        }
        if (messageId != null) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name"); // NOI18N
            ErrorManager.getDefault().annotate(x, ErrorManager.USER, null, bundle.getString(messageId), null, null);
            return x;
        }
        return null;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel addToLocalLabel;
    private javax.swing.JLabel addToRemoteLabel;
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JTextField descriptionTextField;
    private javax.swing.JCheckBox localGetterCheckBox;
    private javax.swing.JCheckBox localSetterCheckBox;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JCheckBox remoteGetterCheckBox;
    private javax.swing.JCheckBox remoteSetterCheckBox;
    private javax.swing.JLabel spacerLabel;
    private javax.swing.JComboBox typeCombo;
    private javax.swing.JLabel typeLabel;
    // End of variables declaration//GEN-END:variables

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AddFieldDialog"));
    }
    
    public boolean isOK() {
        nameTextFieldFocusLost(null);
        boolean result = isOK;
        jComboBox1ActionPerformed(null);
        result = result && isOK;
        return result;
    }

    public String getDescription() {
        return descriptionTextField.getText();
    }

    public boolean isLocalGetter() {
        return localGetterCheckBox.isSelected();
    }

    public boolean isLocalSetter() {
        return localSetterCheckBox.isSelected();
    }

    public boolean isRemoteGetter() {
        return remoteGetterCheckBox.isSelected();
    }

    public boolean isRemoteSetter() {
        return remoteSetterCheckBox.isSelected();
    }
}
