/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.common.ui.nodes;

import org.netbeans.jmi.javamodel.Method;
import org.openide.util.NbBundle;

import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 * Provide a factory for obtaining MethodCustomizer instances
 * @author Chris Webster
 */
public class MethodCollectorFactory {
    private MethodCollectorFactory() {}
    
    private static MethodCustomizer commonCollector(Method method, boolean remote, boolean local, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = new MethodCustomizer(method);
        mc.setAvailableInterface(local, remote);
	mc.setSelectedInterface(checkLocal, checkRemote);
        mc.hideEJBQL();
        mc.hideFinderReturn();
        return mc;
    }
    
    public static MethodCustomizer businessCollector(Method method, boolean remote, boolean local, Method[] mes, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = commonCollector(method, remote, local, checkRemote, checkLocal);
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodExists_Error")); //NOI18N 
        mc.enablePrefixForName("", NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodName_Empty_Error")); //NOI18N
        return mc;
    }
    
    public static MethodCustomizer homeCollector(Method method, boolean remote, boolean local, Method[] mes, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = commonCollector(method, remote, local, checkRemote, checkLocal);
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodExists_Error")); //NOI18N 
        mc.enablePrefixForName("", NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodName_Empty_Error")); //NOI18N
        return mc;
    }
    
    public static MethodCustomizer createCollector(Method method, boolean remote, boolean local, Method[] mes, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = commonCollector(method, remote, local, checkRemote, checkLocal);
        mc.hideReturn();
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodExists_Error")); //NOI18N 
        mc.enablePrefixForName("create", NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodName_Create_Error")); //NOI18N
        return mc;
    }
    
    public static MethodCustomizer finderCollector(Method method, boolean remote, boolean local, boolean ql, Method[] mes, boolean checkRemote, boolean checkLocal) {
        final MethodCustomizer mc = new MethodCustomizer(method);
        mc.setAvailableInterface(local, remote);
	mc.setSelectedInterface(checkLocal, checkRemote);
        mc.hideReturn();
        mc.hideExceptions();
        if (!ql) {
            mc.hideEJBQL();
        }
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodExists_Error")); //NOI18N 
        mc.enablePrefixForName("find", NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodName_Find_Error")); //NOI18N
        final JCheckBox localCheckbox = mc.getLocalCheckbox();
        final JCheckBox remoteCheckbox = mc.getRemoteCheckbox();
        final ActionListener actionListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                boolean isValid = localCheckbox.isSelected() || remoteCheckbox.isSelected();
                mc.firePropertyChange(MethodCustomizer.OK_ENABLED, !isValid, isValid);
            }
        };
        localCheckbox.addActionListener(actionListener);
        remoteCheckbox.addActionListener(actionListener);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                actionListener.actionPerformed(null);
            }
        });
        return mc;
    }
    
    public static MethodCustomizer operationCollector(Method method) {
        MethodCustomizer mc = new MethodCustomizer(method);
        mc.hideInterfaceSelection();
        mc.hideEJBQL();
        mc.hideFinderReturn();
        mc.enablePrefixForName("", NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodName_Select_Error")); //NOI18N
        return mc;
    }
    
    public static MethodCustomizer selectCollector(Method method, Method[] mes) {
        MethodCustomizer mc = new MethodCustomizer(method);
        mc.hideInterfaceSelection();
        mc.hideFinderReturn();
        mc.hideExceptions();
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodExists_Error")); //NOI18N 
        mc.enablePrefixForName("ejbSelect", NbBundle.getMessage(MethodCollectorFactory.class, "LBL_MethodName_Operation_Error")); //NOI18N
        return mc;
    }
}
